/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time;

import com.ethlo.time.internal.util.DurationFormatter;
import java.time.Instant;
import java.util.Comparator;
import java.util.Objects;

public class Duration
implements Comparable<Duration> {
    public static final Duration ZERO = new Duration(0L, 0);
    public static final int NANOS_PER_SECOND = 1000000000;
    public static final long SECONDS_PER_MINUTE = 60L;
    public static final long SECONDS_PER_HOUR = 3600L;
    public static final long SECONDS_PER_DAY = 86400L;
    public static final long SECONDS_PER_WEEK = 604800L;
    public static final long NANOS_PER_MICROSECOND = 1000L;
    public static final long NANOS_PER_MILLISECOND = 1000000L;
    private final long seconds;
    private final int nanos;

    Duration(long seconds, int nanos) {
        this.seconds = seconds;
        if (nanos < 0) {
            throw new IllegalArgumentException("nanos cannot be negative");
        }
        if (nanos >= 1000000000) {
            throw new IllegalArgumentException("nanos cannot be larger than 999,999,999");
        }
        this.nanos = nanos;
    }

    public static Duration ofMillis(long millis) {
        return Duration.ofNanos(Math.multiplyExact(1000000L, millis));
    }

    public static Duration ofMicros(long micros) {
        return Duration.ofNanos(Math.multiplyExact(1000L, micros));
    }

    public static Duration ofNanos(long nanos) {
        int remainderNanos;
        long seconds = nanos / 1000000000L;
        int nano = remainderNanos = (int)(nanos % 1000000000L);
        if (seconds < 0L || nano < 0) {
            --seconds;
            nano = 1000000000 + remainderNanos;
        }
        return new Duration(seconds, nano);
    }

    public static Duration ofWeeks(long weeks) {
        return new Duration(Math.multiplyExact(604800L, weeks), 0);
    }

    public static Duration ofDays(long days) {
        return new Duration(Math.multiplyExact(86400L, days), 0);
    }

    public static Duration ofHours(long hours) {
        return new Duration(Math.multiplyExact(3600L, hours), 0);
    }

    public static Duration ofMinutes(long minutes) {
        return new Duration(Math.multiplyExact(60L, minutes), 0);
    }

    public static Duration ofSeconds(long seconds) {
        return new Duration(seconds, 0);
    }

    public static Duration of(long seconds, int nanos) {
        return new Duration(seconds, nanos);
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNanos() {
        return this.nanos;
    }

    public String normalized() {
        return DurationFormatter.normalizeDuration(this);
    }

    public Instant timeline() {
        return this.timeline(Instant.now());
    }

    public Instant timeline(Instant instant) {
        return instant.plusSeconds(this.seconds).plusNanos(this.nanos);
    }

    java.time.Duration toDuration() {
        return java.time.Duration.ofSeconds(this.seconds, this.nanos);
    }

    public Duration add(Duration other) {
        long totalSeconds = Math.addExact(this.seconds, other.seconds);
        long totalNanos = (long)this.nanos + (long)other.nanos;
        long overflowSeconds = totalNanos / 1000000000L;
        int remainderNanos = (int)(totalNanos % 1000000000L);
        long adjustedTotalSeconds = Math.addExact(totalSeconds, overflowSeconds);
        return new Duration(adjustedTotalSeconds, remainderNanos);
    }

    public Duration subtract(Duration other) {
        return this.add(other.negate());
    }

    public Duration negate() {
        long negatedSeconds = Math.negateExact(this.seconds);
        int negatedNano = -this.nanos;
        if (negatedNano < 0) {
            --negatedSeconds;
            negatedNano += 1000000000;
        }
        return new Duration(negatedSeconds, negatedNano);
    }

    public Duration abs() {
        if (this.isNegative()) {
            return this.negate();
        }
        return this;
    }

    private boolean isNegative() {
        return this.seconds < 0L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Duration that = (Duration)object;
        return this.seconds == that.seconds && this.nanos == that.nanos;
    }

    public int hashCode() {
        return Objects.hash(this.seconds, this.nanos);
    }

    public String toString() {
        return this.normalized();
    }

    @Override
    public int compareTo(Duration o) {
        return Comparator.comparingLong(Duration::getSeconds).thenComparingInt(Duration::getNanos).compare(this, o);
    }

    public Duration plusHours(long hours) {
        return this.plusSeconds(Math.multiplyExact(hours, 3600L));
    }

    public Duration plusMinutes(long minutes) {
        return this.plusSeconds(Math.multiplyExact(minutes, 60L));
    }

    public Duration plusSeconds(long seconds) {
        return new Duration(Math.addExact(this.seconds, seconds), this.nanos);
    }

    public Duration plusNanos(long nanos) {
        long nanosTotal = Math.addExact((long)this.nanos, nanos);
        int nanosRemainder = Math.toIntExact(nanosTotal % 1000000000L);
        long extraSecs = nanosTotal / 1000000000L;
        return new Duration(Math.addExact(this.seconds, extraSecs), nanosRemainder);
    }
}

