/*
 * Decompiled with CFR 0.152.
 */
package liquibase.license;

import java.util.Date;
import liquibase.configuration.ConfiguredValue;
import liquibase.license.LicenseInfo;
import liquibase.license.LicenseInstallResult;
import liquibase.license.Location;
import liquibase.plugin.Plugin;
import liquibase.util.StringUtil;

public interface LicenseService
extends Plugin {
    public static final String TRIAL_LICENSE_URL = "https://liquibase.com/trial";
    public static final String BASE_INVALID_LICENSE_MESSAGE = "Using '%s' requires a valid Liquibase Secure or Labs license. Get a free license key at https://liquibase.com/trial.";
    public static final String END_INVALID_LICENSE_MESSAGE = " Add liquibase.licenseKey=<yourKey> into your defaults file or use --license-key=<yourKey> before your command in the CLI.";

    public int getPriority();

    public boolean licenseIsInstalled();

    public boolean licenseIsValid(String var1);

    public String getLicenseInfo();

    public LicenseInfo getLicenseInfoObject();

    public LicenseInstallResult installLicense(Location ... var1);

    public void disable();

    default public void reset() {
    }

    public boolean licenseIsAboutToExpire();

    public int daysTilExpiration();

    default public Date getExpirationDate() {
        return null;
    }

    default public String getInvalidLicenseMessage(String[] commandNames) {
        return String.format("Using '%s' requires a valid Liquibase Secure or Labs license. Get a free license key at https://liquibase.com/trial. Add liquibase.licenseKey=<yourKey> into your defaults file or use --license-key=<yourKey> before your command in the CLI.", StringUtil.join(commandNames, " "));
    }

    default public ConfiguredValue<String> getLicenseKey() {
        return null;
    }
}

