/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.health;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.health.Indicator;
import org.logstash.health.ReportContext;
import org.logstash.health.Status;

public class MultiIndicator
implements Indicator<Report> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, Indicator<?>> indicators = new ConcurrentHashMap();

    public void attachIndicator(String name, Indicator<?> indicatorToAttach) {
        Indicator<?> existing = this.indicators.putIfAbsent(name, indicatorToAttach);
        if (Objects.nonNull(existing) && !Objects.equals(existing, indicatorToAttach)) {
            throw new IllegalArgumentException(String.format("Cannot attach indicator %s (%s) because a different one of the same name is already attached (%s).", name, indicatorToAttach, existing));
        }
        LOGGER.debug("attached indicator {}=>{} (res:{})", (Object)name, indicatorToAttach, (Object)this);
    }

    public void detachIndicator(String name, Indicator<?> indicatorToDetach) {
        Indicator remaining = this.indicators.computeIfPresent(name, (key, existing) -> Objects.isNull(indicatorToDetach) || Objects.equals(indicatorToDetach, existing) ? null : existing);
        if (Objects.nonNull(remaining)) {
            throw new IllegalArgumentException("Cannot detach indicator " + name + " because a different one of the same name is attached.");
        }
        LOGGER.debug("detached indicator {}<={} (res:{})", (Object)name, indicatorToDetach, (Object)this);
    }

    public <INDICATOR extends Indicator<?>> Optional<INDICATOR> getIndicator(String name, Class<INDICATOR> indicatorClass) {
        return this.getIndicator(name).map(indicatorClass::cast);
    }

    public Optional<Indicator<?>> getIndicator(String name) {
        return Optional.ofNullable(this.indicators.get(name));
    }

    @Override
    public Report report(ReportContext reportContext) {
        LOGGER.debug("report starting with indicators {} for {}", this.indicators, (Object)reportContext);
        Status.Holder combinedStatus = new Status.Holder();
        HashMap<String, Indicator.Report> reports = new HashMap<String, Indicator.Report>();
        HashMap indicatorNamesByStatus = new HashMap();
        this.indicators.forEach((indicatorName, indicator) -> {
            if (reportContext.isMuted((String)indicatorName)) {
                LOGGER.trace("sub-indicator {} is muted for {}", indicatorName, (Object)reportContext);
            } else {
                reportContext.descend((String)indicatorName, scopedContext -> {
                    Object report = indicator.report((ReportContext)scopedContext);
                    combinedStatus.reduce(report.status());
                    reports.put((String)indicatorName, (Indicator.Report)report);
                    indicatorNamesByStatus.computeIfAbsent(report.status(), k -> new HashSet()).add(indicatorName);
                });
            }
        });
        StringBuilder symptom = new StringBuilder();
        ArrayList<String> summaryByStatus = new ArrayList<String>(indicatorNamesByStatus.size());
        for (int i = Status.values().length - 1; i >= 0; --i) {
            Status summarizingStatus = Status.values()[i];
            if (!indicatorNamesByStatus.containsKey((Object)summarizingStatus)) continue;
            Set indicatorNames = (Set)indicatorNamesByStatus.get((Object)summarizingStatus);
            summaryByStatus.add(String.format("%s " + (indicatorNames.size() == 1 ? "indicator is" : "indicators are") + " %s (`%s`)", indicatorNames.size(), summarizingStatus.descriptiveValue(), String.join((CharSequence)"`, `", indicatorNames)));
        }
        if (summaryByStatus.isEmpty()) {
            symptom.append("no indicators");
        } else if (summaryByStatus.size() == 1) {
            symptom.append((String)summaryByStatus.get(0));
        } else if (summaryByStatus.size() == 2) {
            symptom.append((String)summaryByStatus.get(0)).append(" and ").append((String)summaryByStatus.get(1));
        } else {
            int lastIndex = summaryByStatus.size() - 1;
            symptom.append(String.join((CharSequence)", ", summaryByStatus.subList(0, lastIndex))).append(", and ").append((String)summaryByStatus.get(lastIndex));
        }
        return new Report(combinedStatus.value(), symptom.toString(), reports);
    }

    public String toString() {
        return "MultiIndicator{indicators=" + String.valueOf(this.indicators) + "}";
    }

    @JsonSerialize(using=JsonSerializer.class)
    public static class Report
    implements Indicator.Report {
        private final Status status;
        private final String symptom;
        private final Map<String, Indicator.Report> indicators;

        Report(Status status, String symptom, Map<String, Indicator.Report> indicators) {
            this.status = status;
            this.symptom = symptom;
            this.indicators = Map.copyOf(indicators);
        }

        @Override
        public Status status() {
            return this.status;
        }

        public String symptom() {
            return this.symptom;
        }

        public Map<String, Indicator.Report> indicators() {
            return this.indicators;
        }

        public static class JsonSerializer
        extends com.fasterxml.jackson.databind.JsonSerializer<Report> {
            public void serialize(Report report, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeObjectField("status", (Object)report.status());
                jsonGenerator.writeStringField("symptom", report.symptom);
                jsonGenerator.writeObjectField("indicators", report.indicators());
                jsonGenerator.writeEndObject();
            }
        }
    }
}

