/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Converters;
import jakarta.annotation.Priority;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntFunction;
import org.eclipse.microprofile.config.spi.Converter;

@Priority(value=3200)
public class ProfileConfigSourceInterceptor
implements ConfigSourceInterceptor {
    private static final long serialVersionUID = -6305289277993917313L;
    private static final Converter<ArrayList<String>> PROFILES_CONVERTER = Converters.newCollectionConverter(Converters.newTrimmingConverter(Converters.STRING_CONVERTER), new ArrayListFactory());
    private final List<String> profiles;
    private final List<String> prefixProfiles;

    public ProfileConfigSourceInterceptor(String profile) {
        this(profile != null ? ProfileConfigSourceInterceptor.convertProfile(profile) : new ArrayList<String>());
    }

    public ProfileConfigSourceInterceptor(List<String> profiles) {
        ArrayList<String> reverseProfiles = new ArrayList<String>(profiles);
        Collections.reverse(reverseProfiles);
        this.profiles = reverseProfiles;
        this.prefixProfiles = new ArrayList<String>();
        for (String profile : this.profiles) {
            this.prefixProfiles.add("%" + profile + ".");
        }
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        String normalizeName;
        ConfigValue profileValue;
        if (!this.profiles.isEmpty() && (profileValue = this.getProfileValue(context, normalizeName = ProfileConfigSourceInterceptor.activeName(name, this.profiles))) != null) {
            ConfigValue originalValue = context.proceed(normalizeName);
            if (originalValue != null && ConfigValue.CONFIG_SOURCE_COMPARATOR.compare(originalValue, profileValue) > 0) {
                return originalValue;
            }
            return profileValue.withName(normalizeName);
        }
        return context.proceed(name);
    }

    public ConfigValue getProfileValue(ConfigSourceInterceptorContext context, String normalizeName) {
        for (int i = 0; i < this.profiles.size(); ++i) {
            String profile = this.profiles.get(i);
            ConfigValue profileValue = context.proceed(this.prefixProfiles.get(i).concat(normalizeName));
            if (profileValue == null) continue;
            return profileValue.withProfile(profile);
        }
        return null;
    }

    @Override
    public Iterator<String> iterateNames(final ConfigSourceInterceptorContext context) {
        return new Iterator<String>(){
            final Iterator<String> iterator;
            {
                this.iterator = context.iterateNames();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public String next() {
                return ProfileConfigSourceInterceptor.activeName(this.iterator.next(), ProfileConfigSourceInterceptor.this.profiles);
            }
        };
    }

    public List<String> getProfiles() {
        return this.profiles;
    }

    public static String activeName(String name, List<String> profiles) {
        block7: {
            if (name.isEmpty() || name.charAt(0) != '%') break block7;
            int profilesEnd = name.indexOf(46, 1);
            int multipleSplit = -1;
            for (int i = 1; i < profilesEnd; ++i) {
                if (name.charAt(i) != ',') continue;
                multipleSplit = i;
                break;
            }
            if (multipleSplit == -1) {
                for (String profile : profiles) {
                    if (profilesEnd != profile.length() + 1 || !name.regionMatches(1, profile, 0, profile.length())) continue;
                    return name.substring(profilesEnd + 1);
                }
            } else {
                int nextSplit = multipleSplit;
                int toOffset = 1;
                while (nextSplit != -1) {
                    for (String profile : profiles) {
                        char expectedEnd;
                        int end = toOffset + profile.length();
                        if (end >= name.length() || (expectedEnd = name.charAt(end)) != '.' && expectedEnd != ',' || !name.regionMatches(toOffset, profile, 0, profile.length())) continue;
                        return name.substring(profilesEnd + 1);
                    }
                    toOffset = nextSplit + 1;
                    nextSplit = -1;
                    for (int i = toOffset; i < profilesEnd; ++i) {
                        if (name.charAt(i) != ',') continue;
                        nextSplit = i;
                        break;
                    }
                    if (toOffset >= profilesEnd || nextSplit != -1) continue;
                    nextSplit = profilesEnd;
                }
            }
        }
        return name;
    }

    public static List<String> convertProfile(String profile) {
        List<String> profiles = (List<String>)PROFILES_CONVERTER.convert(profile);
        return profiles != null ? profiles : Collections.emptyList();
    }

    private static class ArrayListFactory
    implements IntFunction<ArrayList<String>> {
        private ArrayListFactory() {
        }

        @Override
        public ArrayList<String> apply(int value) {
            return new ArrayList<String>(value);
        }
    }
}

