/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.selectors.pseudofunctions;

import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.MissingResourceException;
import org.w3c.css.selectors.PseudoFunctionSelector;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssValue;

public class PseudoFunctionLang
extends PseudoFunctionSelector {
    public PseudoFunctionLang(String name, CssExpression exp, ApplContext ac) throws InvalidParamException {
        this.setName(name);
        this.setParam(PseudoFunctionLang.parseLang(ac, exp, this.functionName()));
    }

    public static final CssValue parseLang(ApplContext ac, CssExpression exp, String caller) throws InvalidParamException {
        String lang;
        if (exp.getCount() != 1) {
            throw new InvalidParamException("unrecognize", caller, ac);
        }
        CssValue val = exp.getValue();
        switch (val.getType()) {
            case 0: {
                lang = val.getIdent().toString();
                break;
            }
            case 1: {
                lang = val.getString().toString();
                if (lang.charAt(0) != '\"' && lang.charAt(0) != '\'') break;
                lang = lang.substring(1, lang.lastIndexOf(lang.charAt(0)));
                break;
            }
            default: {
                throw new InvalidParamException("value", val.toString(), caller, ac);
            }
        }
        try {
            if (lang.contains("*")) {
                return val;
            }
            Locale.Builder builder = new Locale.Builder();
            builder.setLanguageTag(lang);
            Locale l = builder.build();
            lang = l.getISO3Language();
            return val;
        }
        catch (IllformedLocaleException | MissingResourceException ex) {
            throw new InvalidParamException("value", lang, caller, ac);
        }
    }
}

