/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.time.ZonedDateTime;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.handler.BaseModuleHandler;
import org.openhab.core.automation.handler.TimeBasedConditionHandler;
import org.openhab.core.automation.internal.module.config.EphemerisConditionConfig;
import org.openhab.core.ephemeris.EphemerisManager;

@NonNullByDefault
public class EphemerisConditionHandler
extends BaseModuleHandler<Condition>
implements TimeBasedConditionHandler {
    public static final String HOLIDAY_MODULE_TYPE_ID = "ephemeris.HolidayCondition";
    public static final String NOT_HOLIDAY_MODULE_TYPE_ID = "ephemeris.NotHolidayCondition";
    public static final String WEEKEND_MODULE_TYPE_ID = "ephemeris.WeekendCondition";
    public static final String WEEKDAY_MODULE_TYPE_ID = "ephemeris.WeekdayCondition";
    public static final String DAYSET_MODULE_TYPE_ID = "ephemeris.DaysetCondition";
    private final EphemerisManager ephemerisManager;
    private final @Nullable String dayset;
    private final int offset;

    public EphemerisConditionHandler(Condition condition, EphemerisManager ephemerisManager) {
        super(condition);
        this.ephemerisManager = ephemerisManager;
        EphemerisConditionConfig config = this.getConfigAs(EphemerisConditionConfig.class);
        this.offset = config.offset;
        this.dayset = DAYSET_MODULE_TYPE_ID.equals(((Condition)this.module).getTypeUID()) ? EphemerisConditionHandler.getValidStringConfigParameter(config.dayset, ((Condition)this.module).getId()) : null;
    }

    private static String getValidStringConfigParameter(@Nullable String value, String moduleId) {
        if (value != null && !value.trim().isEmpty()) {
            return value;
        }
        throw new IllegalArgumentException(String.format("Config parameter 'dayset' is missing in the configuration of module '%s'.", moduleId));
    }

    @Override
    public boolean isSatisfiedAt(ZonedDateTime time) {
        ZonedDateTime offsetTime = time.plusDays(this.offset);
        switch (((Condition)this.module).getTypeUID()) {
            case "ephemeris.HolidayCondition": {
                return this.ephemerisManager.isBankHoliday(offsetTime);
            }
            case "ephemeris.NotHolidayCondition": {
                return !this.ephemerisManager.isBankHoliday(offsetTime);
            }
            case "ephemeris.WeekendCondition": {
                return this.ephemerisManager.isWeekend(offsetTime);
            }
            case "ephemeris.WeekdayCondition": {
                return !this.ephemerisManager.isWeekend(offsetTime);
            }
            case "ephemeris.DaysetCondition": {
                String dayset = this.dayset;
                if (dayset == null) break;
                return this.ephemerisManager.isInDayset(dayset, offsetTime);
            }
        }
        return false;
    }

    @Override
    public boolean isSatisfied(Map<String, Object> inputs) {
        ZonedDateTime target = ZonedDateTime.now();
        return this.isSatisfiedAt(target);
    }
}

