/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.context;

import java.util.HashMap;
import org.jfree.layouting.layouter.context.ElementContext;

public class DefaultElementContext
implements ElementContext {
    private HashMap strings;
    private HashMap counters;
    private ElementContext parentContext;

    public DefaultElementContext(ElementContext elementContext) {
        this.parentContext = elementContext;
    }

    @Override
    public int getCounterValue(String string) {
        Integer n;
        if (this.counters != null && (n = (Integer)this.counters.get(string)) != null) {
            return n;
        }
        if (this.parentContext != null) {
            return this.parentContext.getCounterValue(string);
        }
        return 0;
    }

    @Override
    public void incrementCounter(String string, int n) {
        if (this.counters != null && this.counters.containsKey(string)) {
            int n2 = this.getCounterValue(string);
            this.counters.put(string, new Integer(n2 + n));
            return;
        }
        if (this.parentContext != null) {
            this.parentContext.incrementCounter(string, n);
            return;
        }
        int n3 = this.getCounterValue(string);
        if (this.counters == null) {
            this.counters = new HashMap();
        }
        this.counters.put(string, new Integer(n3 + n));
    }

    @Override
    public void resetCounter(String string, int n) {
        if (this.counters == null) {
            this.counters = new HashMap();
        }
        this.counters.put(string, new Integer(n));
    }

    @Override
    public boolean isCounterDefined(String string) {
        if (this.counters == null) {
            return false;
        }
        return this.counters.containsKey(string);
    }

    @Override
    public void setString(String string, String string2, boolean bl) {
        if (!bl && this.parentContext != null) {
            this.parentContext.setString(string, string2, bl);
            return;
        }
        if (string2 == null) {
            if (this.strings != null) {
                this.strings.remove(string);
            }
        } else {
            if (this.strings == null) {
                this.strings = new HashMap();
            }
            this.strings.put(string, string2);
        }
    }

    @Override
    public String getString(String string) {
        String string2;
        if (this.strings != null && (string2 = (String)this.strings.get(string)) != null) {
            return string2;
        }
        if (this.parentContext != null) {
            return this.parentContext.getString(string);
        }
        return null;
    }
}

