/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.fonts;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.font.FontSizeConstant;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.keys.font.RelativeFontSize;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.computed.ConstantsResolveHandler;

public class MinMaxFontSizeResolveHandler
extends ConstantsResolveHandler {
    private static final String SIZE_FACTOR_PREFIX = "org.jfree.layouting.defaults.FontSizeFactor.";
    private double fontSize = this.parseDouble("org.jfree.layouting.defaults.FontSize", 12.0);
    private CSSNumericValue[] predefinedSizes = new CSSNumericValue[7];
    private double[] predefinedScalingFactors;

    public MinMaxFontSizeResolveHandler() {
        this.predefinedSizes[0] = this.computePredefinedSize(FontSizeConstant.XX_SMALL);
        this.predefinedSizes[1] = this.computePredefinedSize(FontSizeConstant.X_SMALL);
        this.predefinedSizes[2] = this.computePredefinedSize(FontSizeConstant.SMALL);
        this.predefinedSizes[3] = this.computePredefinedSize(FontSizeConstant.MEDIUM);
        this.predefinedSizes[4] = this.computePredefinedSize(FontSizeConstant.LARGE);
        this.predefinedSizes[5] = this.computePredefinedSize(FontSizeConstant.X_LARGE);
        this.predefinedSizes[6] = this.computePredefinedSize(FontSizeConstant.XX_LARGE);
        this.predefinedScalingFactors = new double[7];
        this.predefinedScalingFactors[0] = this.computePredefinedScalingFactor(FontSizeConstant.XX_SMALL);
        this.predefinedScalingFactors[1] = this.computePredefinedScalingFactor(FontSizeConstant.X_SMALL);
        this.predefinedScalingFactors[2] = this.computePredefinedScalingFactor(FontSizeConstant.SMALL);
        this.predefinedScalingFactors[3] = this.computePredefinedScalingFactor(FontSizeConstant.MEDIUM);
        this.predefinedScalingFactors[4] = this.computePredefinedScalingFactor(FontSizeConstant.LARGE);
        this.predefinedScalingFactors[5] = this.computePredefinedScalingFactor(FontSizeConstant.X_LARGE);
        this.predefinedScalingFactors[6] = this.computePredefinedScalingFactor(FontSizeConstant.XX_LARGE);
        this.addValue(FontSizeConstant.XX_SMALL, this.predefinedSizes[0]);
        this.addValue(FontSizeConstant.X_SMALL, this.predefinedSizes[1]);
        this.addValue(FontSizeConstant.SMALL, this.predefinedSizes[2]);
        this.addValue(FontSizeConstant.MEDIUM, this.predefinedSizes[3]);
        this.addValue(FontSizeConstant.LARGE, this.predefinedSizes[4]);
        this.addValue(FontSizeConstant.X_LARGE, this.predefinedSizes[5]);
        this.addValue(FontSizeConstant.XX_LARGE, this.predefinedSizes[6]);
    }

    private CSSNumericValue computePredefinedSize(CSSConstant cSSConstant) {
        String string = SIZE_FACTOR_PREFIX + cSSConstant.getCSSText();
        double d = this.parseDouble(string, 100.0);
        return CSSNumericValue.createValue(CSSNumericType.PT, this.fontSize * d / 100.0);
    }

    private double computePredefinedScalingFactor(CSSConstant cSSConstant) {
        String string = SIZE_FACTOR_PREFIX + cSSConstant.getCSSText();
        return this.parseDouble(string, 100.0);
    }

    private double parseDouble(String string, double d) {
        String string2 = LibLayoutBoot.getInstance().getGlobalConfig().getConfigProperty(string);
        if (string2 == null) {
            return d;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{FontStyleKeys.FONT_SIZE};
    }

    @Override
    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        double d;
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        CSSValue cSSValue = layoutContext.getValue(styleKey);
        if (!(cSSValue instanceof CSSConstant)) {
            return;
        }
        CSSConstant cSSConstant = (CSSConstant)cSSValue;
        double d2 = layoutElement.getLayoutContext().getFontSpecification().getFontSize();
        if (RelativeFontSize.LARGER.equals(cSSValue)) {
            d = this.getScaleLargerFactor(d2);
            layoutContext.setValue(styleKey, CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, d));
        } else if (RelativeFontSize.SMALLER.equals(cSSValue)) {
            d = this.getScaleSmallerFactor(d2);
            layoutContext.setValue(styleKey, CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, d));
        }
        CSSValue cSSValue2 = this.lookupValue(cSSConstant);
        if (cSSValue2 != null) {
            layoutContext.setValue(styleKey, cSSValue2);
            return;
        }
        if (styleKey.equals(FontStyleKeys.MAX_FONT_SIZE)) {
            layoutContext.setValue(styleKey, CSSNumericValue.createValue(CSSNumericType.PT, 32767.0));
        } else {
            layoutContext.setValue(styleKey, CSSNumericValue.createValue(CSSNumericType.PT, 0.0));
        }
    }

    public double getScaleLargerFactor(double d) {
        for (int i = 0; i < this.predefinedSizes.length; ++i) {
            CSSNumericValue cSSNumericValue = this.predefinedSizes[i];
            if (!(d < cSSNumericValue.getValue())) continue;
            return this.predefinedScalingFactors[i];
        }
        return this.predefinedScalingFactors[6];
    }

    public double getScaleSmallerFactor(double d) {
        for (int i = this.predefinedSizes.length; i >= 0; --i) {
            CSSNumericValue cSSNumericValue = this.predefinedSizes[i];
            if (!(d > cSSNumericValue.getValue())) continue;
            return this.predefinedScalingFactors[i];
        }
        return this.predefinedScalingFactors[0];
    }
}

