/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.zipreader;

import java.util.Date;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentCreationException;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.zipreader.ZipReadContentItem;
import org.pentaho.reporting.libraries.repository.zipreader.ZipReadRepository;

public class ZipReadContentLocation
implements ContentLocation {
    private static final Logger logger = Logger.getLogger(ZipReadContentLocation.class.getName());
    private ZipReadRepository repository;
    private ZipReadContentLocation parent;
    private String comment;
    private String name;
    private long size;
    private long time;
    private String entryName;
    private HashMap entries;

    public ZipReadContentLocation(ZipReadRepository repository, ZipReadContentLocation parent, String entryName) {
        if (repository == null) {
            throw new NullPointerException();
        }
        if (entryName == null) {
            throw new NullPointerException();
        }
        this.repository = repository;
        this.parent = parent;
        this.entryName = entryName;
        this.entries = new HashMap();
        this.name = RepositoryUtilities.buildName(this, "/") + '/';
    }

    public ZipReadContentLocation(ZipReadRepository repository, ZipReadContentLocation parent, ZipEntry zipEntry) {
        if (repository == null) {
            throw new NullPointerException();
        }
        if (parent == null) {
            throw new NullPointerException();
        }
        if (zipEntry == null) {
            throw new NullPointerException();
        }
        this.repository = repository;
        this.parent = parent;
        this.comment = zipEntry.getComment();
        this.size = zipEntry.getSize();
        this.time = zipEntry.getTime();
        this.entries = new HashMap();
        this.entryName = IOUtils.getInstance().getFileName(zipEntry.getName());
        this.name = RepositoryUtilities.buildName(this, "/") + '/';
    }

    private void updateMetaData(ZipEntry zipEntry) {
        this.comment = zipEntry.getComment();
        this.size = zipEntry.getSize();
        this.time = zipEntry.getTime();
    }

    public void updateDirectoryEntry(String[] name, int index, ZipEntry zipEntry) {
        ZipReadContentLocation location;
        if (name == null) {
            throw new NullPointerException();
        }
        if (zipEntry == null) {
            throw new NullPointerException();
        }
        String path = name[index];
        Object entry = this.entries.get(path);
        if (entry instanceof ContentItem) {
            logger.warning("Directory-Entry with the same name as a Content-Entry encountered: " + path);
            return;
        }
        if (entry == null) {
            location = new ZipReadContentLocation(this.repository, this, path);
            this.entries.put(path, location);
        } else {
            location = (ZipReadContentLocation)entry;
        }
        int nextNameIdx = index + 1;
        if (nextNameIdx < name.length) {
            location.updateDirectoryEntry(name, nextNameIdx, zipEntry);
        } else if (nextNameIdx == name.length) {
            location.updateMetaData(zipEntry);
        }
    }

    public void updateEntry(String[] name, int index, ZipEntry zipEntry, byte[] data) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (zipEntry == null) {
            throw new NullPointerException();
        }
        if (data == null) {
            throw new NullPointerException();
        }
        String path = name[index];
        Object entry = this.entries.get(path);
        int nextNameIdx = index + 1;
        if (nextNameIdx < name.length) {
            ZipReadContentLocation location;
            if (entry instanceof ContentItem) {
                logger.warning("Directory-Entry with the same name as a Content-Entry encountered: " + path);
                return;
            }
            if (entry == null) {
                location = new ZipReadContentLocation(this.repository, this, path);
                this.entries.put(path, location);
            } else {
                location = (ZipReadContentLocation)entry;
            }
            if (nextNameIdx < name.length) {
                location.updateEntry(name, nextNameIdx, zipEntry, data);
            }
        } else if (nextNameIdx == name.length) {
            if (entry instanceof ContentItem) {
                logger.warning("Duplicate Content-Entry encountered: " + path);
                return;
            }
            if (entry != null) {
                logger.warning("Replacing Directory-Entry with the same name as a Content-Entry: " + path);
            }
            ZipReadContentItem contentItem = new ZipReadContentItem(this.repository, this, zipEntry, data);
            this.entries.put(path, contentItem);
        }
    }

    @Override
    public ContentEntity[] listContents() throws ContentIOException {
        return this.entries.values().toArray(new ContentEntity[this.entries.size()]);
    }

    @Override
    public ContentEntity getEntry(String name) throws ContentIOException {
        ContentEntity contentEntity = (ContentEntity)this.entries.get(name);
        if (contentEntity == null) {
            throw new ContentIOException("Not found:" + name);
        }
        return contentEntity;
    }

    @Override
    public boolean exists(String name) {
        return this.entries.containsKey(name);
    }

    @Override
    public ContentItem createItem(String name) throws ContentCreationException {
        throw new ContentCreationException();
    }

    @Override
    public ContentLocation createLocation(String name) throws ContentCreationException {
        throw new ContentCreationException();
    }

    @Override
    public String getName() {
        return this.entryName;
    }

    @Override
    public Object getContentId() {
        return this.name;
    }

    @Override
    public Object getAttribute(String domain, String key) {
        if ("org.jfree.repository".equals(domain)) {
            if ("size".equals(key)) {
                return new Long(this.size);
            }
            if ("version".equals(key)) {
                return new Date(this.time);
            }
        } else if ("org.jfree.repository.zip".equals(domain) && "comment".equals(key)) {
            return this.comment;
        }
        return null;
    }

    @Override
    public boolean setAttribute(String domain, String key, Object value) {
        return false;
    }

    @Override
    public ContentLocation getParent() {
        return this.parent;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public boolean delete() {
        return false;
    }
}

