/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.validator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.validator.KettleValidatorException;
import org.pentaho.di.trans.steps.validator.Messages;
import org.pentaho.di.trans.steps.validator.Validation;
import org.pentaho.di.trans.steps.validator.ValidatorData;
import org.pentaho.di.trans.steps.validator.ValidatorMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validator
extends BaseStep
implements StepInterface {
    private ValidatorMeta meta;
    private ValidatorData data;

    public Validator(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] r;
        block20: {
            Iterator<KettleValidatorException> i$;
            boolean notFirst;
            StringBuffer codes;
            StringBuffer fields;
            StringBuffer messages;
            List<KettleValidatorException> exceptions;
            block19: {
                this.meta = (ValidatorMeta)smi;
                this.data = (ValidatorData)sdi;
                if (!this.first) {
                    r = this.getRow();
                    if (r == null) {
                        this.setOutputDone();
                        return false;
                    }
                } else {
                    this.first = false;
                    this.readSourceValuesFromInfoSteps();
                    r = this.getRow();
                    if (r == null) {
                        this.setOutputDone();
                        return false;
                    }
                    this.data.fieldIndexes = new int[this.meta.getValidations().length];
                    for (int i = 0; i < this.meta.getValidations().length; ++i) {
                        Validation field = this.meta.getValidations()[i];
                        if (Const.isEmpty((String)field.getFieldName())) {
                            throw new KettleStepException("There is no name specified for validator field #" + (i + 1));
                        }
                        this.data.fieldIndexes[i] = this.getInputRowMeta().indexOfValue(field.getFieldName());
                        if (this.data.fieldIndexes[i] >= 0) continue;
                        throw new KettleStepException("Unable to find the specified fieldname '" + field.getFieldName() + "' for validation#" + (i + 1));
                    }
                }
                if (this.log.isRowLevel()) {
                    this.log.logRowlevel(this.toString(), "Read row #" + this.getLinesRead() + " : " + this.getInputRowMeta().getString(r), new Object[0]);
                }
                try {
                    exceptions = this.validateFields(this.getInputRowMeta(), r);
                    if (exceptions.size() > 0) {
                        if (!this.getStepMeta().isDoingErrorHandling()) {
                            KettleValidatorException e = exceptions.get(0);
                            throw new KettleException(e.getMessage(), (Throwable)((Object)e));
                        }
                        if (this.meta.isConcatenatingErrors()) {
                            messages = new StringBuffer();
                            fields = new StringBuffer();
                            codes = new StringBuffer();
                            notFirst = false;
                            i$ = exceptions.iterator();
                            break block19;
                        }
                        for (KettleValidatorException e : exceptions) {
                            this.putError(this.getInputRowMeta(), r, 1L, e.getMessage(), e.getFieldname(), e.getCodeDesc());
                        }
                        break block20;
                    }
                    this.putRow(this.getInputRowMeta(), r);
                }
                catch (KettleValidatorException e) {
                    if (!this.getStepMeta().isDoingErrorHandling()) {
                        throw new KettleException(e.getMessage(), (Throwable)((Object)e));
                    }
                    this.putError(this.getInputRowMeta(), r, 1L, e.getMessage(), e.getFieldname(), e.getCodeDesc());
                }
                break block20;
            }
            while (i$.hasNext()) {
                KettleValidatorException e = i$.next();
                if (notFirst) {
                    messages.append(this.meta.getConcatenationSeparator());
                    fields.append(this.meta.getConcatenationSeparator());
                    codes.append(this.meta.getConcatenationSeparator());
                } else {
                    notFirst = true;
                }
                messages.append(e.getMessage());
                fields.append(e.getFieldname());
                codes.append(e.getCodeDesc());
            }
            this.putError(this.getInputRowMeta(), r, exceptions.size(), messages.toString(), fields.toString(), codes.toString());
        }
        if (this.log.isRowLevel()) {
            this.log.logRowlevel(this.toString(), "Wrote row #" + this.getLinesWritten() + " : " + this.getInputRowMeta().getString(r), new Object[0]);
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    private void readSourceValuesFromInfoSteps() throws KettleStepException {
        for (int i = 0; i < this.meta.getValidations().length; ++i) {
            Validation field = this.meta.getValidations()[i];
            if (!field.isSourcingValues()) continue;
            if (field.getSourcingStep() == null) {
                throw new KettleStepException("There is no valid source step specified for the allowed values of validation [" + field.getName() + "]");
            }
            if (Const.isEmpty((String)field.getSourcingField())) {
                throw new KettleStepException("There is no valid source field specified for the allowed values of validation [" + field.getName() + "]");
            }
            RowSet allowedRowSet = this.findInputRowSet(field.getSourcingStep().getName());
            int fieldIndex = -1;
            ArrayList<Object> allowedValues = new ArrayList<Object>();
            Object[] allowedRowData = this.getRowFrom(allowedRowSet);
            while (allowedRowData != null) {
                Object allowedValue;
                RowMetaInterface allowedRowMeta = allowedRowSet.getRowMeta();
                if (fieldIndex < 0) {
                    fieldIndex = allowedRowMeta.indexOfValue(field.getSourcingField());
                    if (fieldIndex < 0) {
                        throw new KettleStepException("Source field [" + field.getSourcingField() + "] is not found in the source row data");
                    }
                    this.data.constantsMeta[i] = allowedRowMeta.getValueMeta(fieldIndex);
                }
                if ((allowedValue = allowedRowData[fieldIndex]) != null) {
                    allowedValues.add(allowedValue);
                }
                allowedRowData = this.getRowFrom(allowedRowSet);
            }
            this.data.listValues[i] = allowedValues.toArray(new Object[allowedValues.size()]);
        }
    }

    private List<KettleValidatorException> validateFields(RowMetaInterface inputRowMeta, Object[] r) throws KettleValidatorException, KettleValueException {
        ArrayList<KettleValidatorException> exceptions = new ArrayList<KettleValidatorException>();
        for (int i = 0; i < this.meta.getValidations().length; ++i) {
            Matcher matcher;
            KettleValidatorException exception;
            KettleValidatorException exception2;
            KettleValidatorException exception3;
            Validation field = this.meta.getValidations()[i];
            int valueIndex = this.data.fieldIndexes[i];
            ValueMetaInterface validatorMeta = this.data.constantsMeta[i];
            ValueMetaInterface valueMeta = inputRowMeta.getValueMeta(valueIndex);
            Object valueData = r[valueIndex];
            boolean isNull = valueMeta.isNull(valueData);
            if (!field.isNullAllowed() && isNull) {
                exception3 = new KettleValidatorException(field, 1, Messages.getString("Validator.Exception.NullNotAllowed", field.getFieldName(), inputRowMeta.getString(r)), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception3);
                } else {
                    throw exception3;
                }
            }
            if (field.isOnlyNullAllowed() && !isNull) {
                exception3 = new KettleValidatorException(field, 15, Messages.getString("Validator.Exception.OnlyNullAllowed", field.getFieldName(), inputRowMeta.getString(r)), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception3);
                } else {
                    throw exception3;
                }
            }
            if (field.isDataTypeVerified() && field.getDataType() != 0 && field.getDataType() != valueMeta.getType()) {
                exception3 = new KettleValidatorException(field, 4, Messages.getString("Validator.Exception.UnexpectedDataType", field.getFieldName(), valueMeta.toStringMeta(), validatorMeta.toStringMeta()), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception3);
                } else {
                    throw exception3;
                }
            }
            if (isNull || field.getMinimumLength() < 0 && field.getMaximumLength() < 0 && this.data.minimumValue[i] == null && this.data.maximumValue[i] == null && this.data.listValues[i].length <= 0 && !field.isSourcingValues() && Const.isEmpty((String)field.getStartString()) && Const.isEmpty((String)field.getEndString()) && Const.isEmpty((String)field.getStartStringNotAllowed()) && Const.isEmpty((String)field.getEndStringNotAllowed()) && !field.isOnlyNumericAllowed() && this.data.patternExpected[i] == null && this.data.patternDisallowed[i] == null) continue;
            String stringValue = valueMeta.getString(valueData);
            if (field.getMinimumLength() >= 0 && stringValue.length() < field.getMinimumLength()) {
                exception2 = new KettleValidatorException(field, 3, Messages.getString("Validator.Exception.ShorterThanMininumLength", field.getFieldName(), valueMeta.getString(valueData), Integer.toString(stringValue.length()), Integer.toString(field.getMinimumLength())), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception2);
                } else {
                    throw exception2;
                }
            }
            if (field.getMaximumLength() >= 0 && stringValue.length() > field.getMaximumLength()) {
                exception2 = new KettleValidatorException(field, 2, Messages.getString("Validator.Exception.LongerThanMaximumLength", field.getFieldName(), valueMeta.getString(valueData), Integer.toString(stringValue.length()), Integer.toString(field.getMaximumLength())), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception2);
                } else {
                    throw exception2;
                }
            }
            if (this.data.minimumValue[i] != null && valueMeta.compare(valueData, validatorMeta, this.data.minimumValue[i]) < 0) {
                exception2 = new KettleValidatorException(field, 5, Messages.getString("Validator.Exception.LowerThanMinimumValue", field.getFieldName(), valueMeta.getString(valueData), this.data.constantsMeta[i].getString(this.data.minimumValue[i])), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception2);
                } else {
                    throw exception2;
                }
            }
            if (this.data.maximumValue[i] != null && valueMeta.compare(valueData, validatorMeta, this.data.maximumValue[i]) > 0) {
                exception2 = new KettleValidatorException(field, 6, Messages.getString("Validator.Exception.HigherThanMaximumValue", field.getFieldName(), valueMeta.getString(valueData), this.data.constantsMeta[i].getString(this.data.maximumValue[i])), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception2);
                } else {
                    throw exception2;
                }
            }
            if (field.isSourcingValues() || this.data.listValues[i].length > 0) {
                boolean found = false;
                for (Object object : this.data.listValues[i]) {
                    if (object == null || this.data.listValues[i] == null || valueMeta.compare(valueData, validatorMeta, object) != 0) continue;
                    found = true;
                }
                if (!found) {
                    exception = new KettleValidatorException(field, 7, Messages.getString("Validator.Exception.NotInList", field.getFieldName(), valueMeta.getString(valueData)), field.getFieldName());
                    if (this.meta.isValidatingAll()) {
                        exceptions.add(exception);
                    } else {
                        throw exception;
                    }
                }
            }
            if (field.isOnlyNumericAllowed() && (valueMeta.isNumeric() || !this.containsOnlyDigits(valueMeta.getString(valueData)))) {
                KettleValidatorException exception4 = new KettleValidatorException(field, 8, Messages.getString("Validator.Exception.NonNumericDataNotAllowed", field.getFieldName(), valueMeta.toStringMeta()), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception4);
                } else {
                    throw exception4;
                }
            }
            if (!Const.isEmpty((String)field.getStartString()) && !stringValue.startsWith(field.getStartString())) {
                KettleValidatorException exception5 = new KettleValidatorException(field, 9, Messages.getString("Validator.Exception.DoesNotStartWithString", field.getFieldName(), valueMeta.getString(valueData), field.getStartString()), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception5);
                } else {
                    throw exception5;
                }
            }
            if (!Const.isEmpty((String)field.getEndString()) && !stringValue.endsWith(field.getEndString())) {
                KettleValidatorException exception6 = new KettleValidatorException(field, 10, Messages.getString("Validator.Exception.DoesNotStartWithString", field.getFieldName(), valueMeta.getString(valueData), field.getEndString()), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception6);
                } else {
                    throw exception6;
                }
            }
            if (!Const.isEmpty((String)field.getStartStringNotAllowed()) && stringValue.startsWith(field.getStartStringNotAllowed())) {
                KettleValidatorException exception7 = new KettleValidatorException(field, 11, Messages.getString("Validator.Exception.StartsWithString", field.getFieldName(), valueMeta.getString(valueData), field.getStartStringNotAllowed()), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception7);
                } else {
                    throw exception7;
                }
            }
            if (!Const.isEmpty((String)field.getEndStringNotAllowed()) && stringValue.endsWith(field.getEndStringNotAllowed())) {
                KettleValidatorException exception8 = new KettleValidatorException(field, 12, Messages.getString("Validator.Exception.EndsWithString", field.getFieldName(), valueMeta.getString(valueData), field.getEndStringNotAllowed()), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception8);
                } else {
                    throw exception8;
                }
            }
            if (this.data.patternExpected[i] != null && !(matcher = this.data.patternExpected[i].matcher(stringValue)).matches()) {
                exception = new KettleValidatorException(field, 13, Messages.getString("Validator.Exception.MatchingRegExpExpected", field.getFieldName(), valueMeta.getString(valueData), field.getRegularExpression()), field.getFieldName());
                if (this.meta.isValidatingAll()) {
                    exceptions.add(exception);
                } else {
                    throw exception;
                }
            }
            if (this.data.patternDisallowed[i] == null || !(matcher = this.data.patternDisallowed[i].matcher(stringValue)).matches()) continue;
            exception = new KettleValidatorException(field, 14, Messages.getString("Validator.Exception.MatchingRegExpNotAllowed", field.getFieldName(), valueMeta.getString(valueData), field.getRegularExpressionNotAllowed()), field.getFieldName());
            if (this.meta.isValidatingAll()) {
                exceptions.add(exception);
                continue;
            }
            throw exception;
        }
        return exceptions;
    }

    private boolean containsOnlyDigits(String string) {
        for (char c : string.toCharArray()) {
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ValidatorMeta)smi;
        this.data = (ValidatorData)sdi;
        if (super.init(smi, sdi)) {
            this.data.constantsMeta = new ValueMetaInterface[this.meta.getValidations().length];
            this.data.minimumValue = new Object[this.meta.getValidations().length];
            this.data.maximumValue = new Object[this.meta.getValidations().length];
            this.data.listValues = new Object[this.meta.getValidations().length][];
            this.data.patternExpected = new Pattern[this.meta.getValidations().length];
            this.data.patternDisallowed = new Pattern[this.meta.getValidations().length];
            for (int i = 0; i < this.meta.getValidations().length; ++i) {
                Validation field = this.meta.getValidations()[i];
                this.data.constantsMeta[i] = new ValueMeta(field.getFieldName(), field.getDataType());
                this.data.constantsMeta[i].setConversionMask(field.getConversionMask());
                this.data.constantsMeta[i].setDecimalSymbol(field.getDecimalSymbol());
                this.data.constantsMeta[i].setGroupingSymbol(field.getGroupingSymbol());
                ValueMetaInterface stringMeta = this.data.constantsMeta[i].clone();
                stringMeta.setType(2);
                try {
                    this.data.minimumValue[i] = Const.isEmpty((String)field.getMinimumValue()) ? null : this.data.constantsMeta[i].convertData(stringMeta, (Object)field.getMinimumValue());
                    this.data.maximumValue[i] = Const.isEmpty((String)field.getMaximumValue()) ? null : this.data.constantsMeta[i].convertData(stringMeta, (Object)field.getMaximumValue());
                    int listSize = field.getAllowedValues() != null ? field.getAllowedValues().length : 0;
                    this.data.listValues[i] = new Object[listSize];
                    for (int s = 0; s < listSize; ++s) {
                        this.data.listValues[i][s] = Const.isEmpty((String)field.getAllowedValues()[s]) ? null : this.data.constantsMeta[i].convertData(stringMeta, (Object)field.getAllowedValues()[s]);
                    }
                }
                catch (KettleValueException e) {
                    if (field.getDataType() == 0) {
                        this.logError(Messages.getString("Validator.Exception.SpecifyDataType"), e);
                    } else {
                        this.logError(Messages.getString("Validator.Exception.DataConversionErrorEncountered"), e);
                    }
                    return false;
                }
                if (!Const.isEmpty((String)field.getRegularExpression())) {
                    this.data.patternExpected[i] = Pattern.compile(field.getRegularExpression());
                }
                if (Const.isEmpty((String)field.getRegularExpressionNotAllowed())) continue;
                this.data.patternDisallowed[i] = Pattern.compile(field.getRegularExpressionNotAllowed());
            }
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }

    public class FieldIndexes {
        public int indexName;
        public int indexA;
        public int indexB;
        public int indexC;
    }
}

