/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.writer.builder;

import com.android.tools.smali.dexlib2.base.reference.BaseTypeReference;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.util.MethodUtil;
import com.android.tools.smali.dexlib2.writer.builder.BuilderAnnotationSet;
import com.android.tools.smali.dexlib2.writer.builder.BuilderEncodedValues;
import com.android.tools.smali.dexlib2.writer.builder.BuilderField;
import com.android.tools.smali.dexlib2.writer.builder.BuilderMethod;
import com.android.tools.smali.dexlib2.writer.builder.BuilderStringReference;
import com.android.tools.smali.dexlib2.writer.builder.BuilderTypeList;
import com.android.tools.smali.dexlib2.writer.builder.BuilderTypeReference;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class BuilderClassDef
extends BaseTypeReference
implements ClassDef {
    final BuilderTypeReference type;
    final int accessFlags;
    final BuilderTypeReference superclass;
    final BuilderTypeList interfaces;
    final BuilderStringReference sourceFile;
    final BuilderAnnotationSet annotations;
    final SortedSet<BuilderField> staticFields;
    final SortedSet<BuilderField> instanceFields;
    final SortedSet<BuilderMethod> directMethods;
    final SortedSet<BuilderMethod> virtualMethods;
    final BuilderEncodedValues.BuilderArrayEncodedValue staticInitializers;
    int classDefIndex = -1;
    int annotationDirectoryOffset = 0;

    BuilderClassDef(BuilderTypeReference type, int accessFlags, BuilderTypeReference superclass, BuilderTypeList interfaces, BuilderStringReference sourceFile, BuilderAnnotationSet annotations, SortedSet<BuilderField> staticFields, SortedSet<BuilderField> instanceFields, Iterable<? extends BuilderMethod> methods, BuilderEncodedValues.BuilderArrayEncodedValue staticInitializers) {
        if (methods == null) {
            methods = ImmutableList.of();
        }
        if (staticFields == null) {
            staticFields = ImmutableSortedSet.of();
        }
        if (instanceFields == null) {
            instanceFields = ImmutableSortedSet.of();
        }
        this.type = type;
        this.accessFlags = accessFlags;
        this.superclass = superclass;
        this.interfaces = interfaces;
        this.sourceFile = sourceFile;
        this.annotations = annotations;
        this.staticFields = staticFields;
        this.instanceFields = instanceFields;
        this.directMethods = ImmutableSortedSet.copyOf(Iterables.filter(methods, MethodUtil.METHOD_IS_DIRECT));
        this.virtualMethods = ImmutableSortedSet.copyOf(Iterables.filter(methods, MethodUtil.METHOD_IS_VIRTUAL));
        this.staticInitializers = staticInitializers;
    }

    @Override
    public String getType() {
        return this.type.getType();
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    public String getSuperclass() {
        return this.superclass == null ? null : this.superclass.getType();
    }

    @Override
    public String getSourceFile() {
        return this.sourceFile == null ? null : this.sourceFile.getString();
    }

    public BuilderAnnotationSet getAnnotations() {
        return this.annotations;
    }

    public SortedSet<BuilderField> getStaticFields() {
        return this.staticFields;
    }

    public SortedSet<BuilderField> getInstanceFields() {
        return this.instanceFields;
    }

    public SortedSet<BuilderMethod> getDirectMethods() {
        return this.directMethods;
    }

    public SortedSet<BuilderMethod> getVirtualMethods() {
        return this.virtualMethods;
    }

    @Override
    public List<String> getInterfaces() {
        return Lists.transform(this.interfaces, Functions.toStringFunction());
    }

    public Collection<BuilderField> getFields() {
        return new AbstractCollection<BuilderField>(){

            @Override
            public Iterator<BuilderField> iterator() {
                return Iterators.mergeSorted(ImmutableList.of(BuilderClassDef.this.staticFields.iterator(), BuilderClassDef.this.instanceFields.iterator()), Ordering.natural());
            }

            @Override
            public int size() {
                return BuilderClassDef.this.staticFields.size() + BuilderClassDef.this.instanceFields.size();
            }
        };
    }

    public Collection<BuilderMethod> getMethods() {
        return new AbstractCollection<BuilderMethod>(){

            @Override
            public Iterator<BuilderMethod> iterator() {
                return Iterators.mergeSorted(ImmutableList.of(BuilderClassDef.this.directMethods.iterator(), BuilderClassDef.this.virtualMethods.iterator()), Ordering.natural());
            }

            @Override
            public int size() {
                return BuilderClassDef.this.directMethods.size() + BuilderClassDef.this.virtualMethods.size();
            }
        };
    }
}

