/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command;

import java.io.PrintStream;
import liquibase.command.DiffToChangeLogCommand;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.util.StringUtils;

public class GenerateChangeLogCommand
extends DiffToChangeLogCommand {
    private String author;
    private String context;

    @Override
    public String getName() {
        return "generateChangeLog";
    }

    public String getAuthor() {
        return this.author;
    }

    public GenerateChangeLogCommand setAuthor(String author) {
        this.author = author;
        return this;
    }

    public String getContext() {
        return this.context;
    }

    public GenerateChangeLogCommand setContext(String context) {
        this.context = context;
        return this;
    }

    @Override
    protected Object run() throws Exception {
        DiffResult diffResult = this.createDiffResult();
        DiffToChangeLog changeLogWriter = new DiffToChangeLog(diffResult, this.getDiffOutputControl());
        changeLogWriter.setChangeSetAuthor(this.author);
        changeLogWriter.setChangeSetContext(this.context);
        changeLogWriter.setChangeSetPath(this.getChangeLogFile());
        if (StringUtils.trimToNull(this.getChangeLogFile()) != null) {
            changeLogWriter.print(this.getChangeLogFile());
        } else {
            PrintStream outputStream = this.getOutputStream();
            if (outputStream == null) {
                outputStream = System.out;
            }
            changeLogWriter.print(outputStream);
        }
        return null;
    }

    @Override
    protected DatabaseSnapshot createTargetSnapshot() throws DatabaseException, InvalidExampleException {
        SnapshotControl snapshotControl = new SnapshotControl(this.getReferenceDatabase(), this.getSnapshotTypes());
        return SnapshotGeneratorFactory.getInstance().createSnapshot(this.getCompareControl().getSchemas(CompareControl.DatabaseRole.REFERENCE), null, snapshotControl);
    }
}

