/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.ICodeInfo;
import jadx.api.JavaClass;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.info.AccessInfo;
import jadx.gui.treemodel.JField;
import jadx.gui.treemodel.JLoadableNode;
import jadx.gui.treemodel.JMethod;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.TextNode;
import jadx.gui.ui.TabbedPane;
import jadx.gui.ui.codearea.ClassCodeContentPanel;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.utils.CacheObject;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;

public class JClass
extends JLoadableNode {
    private static final long serialVersionUID = -1239986875244097177L;
    private static final ImageIcon ICON_CLASS = UiUtils.openSvgIcon("nodes/class");
    private static final ImageIcon ICON_CLASS_ABSTRACT = UiUtils.openSvgIcon("nodes/abstractClass");
    private static final ImageIcon ICON_CLASS_PUBLIC = UiUtils.openSvgIcon("nodes/publicClass");
    private static final ImageIcon ICON_CLASS_PRIVATE = UiUtils.openSvgIcon("nodes/privateClass");
    private static final ImageIcon ICON_CLASS_PROTECTED = UiUtils.openSvgIcon("nodes/protectedClass");
    private static final ImageIcon ICON_INTERFACE = UiUtils.openSvgIcon("nodes/interface");
    private static final ImageIcon ICON_ENUM = UiUtils.openSvgIcon("nodes/enum");
    private static final ImageIcon ICON_ANNOTATION = UiUtils.openSvgIcon("nodes/annotationtype");
    private final transient JavaClass cls;
    private final transient JClass jParent;
    private transient boolean loaded;

    public JClass(JavaClass cls) {
        this.cls = cls;
        this.jParent = null;
        this.loaded = false;
    }

    public JClass(JavaClass cls, JClass parent) {
        this.cls = cls;
        this.jParent = parent;
        this.loaded = true;
    }

    public JavaClass getCls() {
        return this.cls;
    }

    @Override
    public void loadNode() {
        this.getRootClass().load();
    }

    @Override
    public boolean canRename() {
        return !this.cls.getClassNode().contains(AFlag.DONT_RENAME);
    }

    private synchronized void load() {
        if (this.loaded) {
            return;
        }
        this.cls.decompile();
        this.loaded = true;
        this.update();
    }

    public synchronized ICodeInfo reload(CacheObject cache) {
        cache.getNodeCache().removeWholeClass(this.cls);
        ICodeInfo codeInfo = this.cls.reload();
        this.loaded = true;
        this.update();
        return codeInfo;
    }

    public synchronized void unload(CacheObject cache) {
        cache.getNodeCache().removeWholeClass(this.cls);
        this.cls.unload();
        this.loaded = false;
    }

    public synchronized void update() {
        this.removeAllChildren();
        if (!this.loaded) {
            this.add(new TextNode(NLS.str("tree.loading")));
        } else {
            for (JavaClass javaClass : this.cls.getInnerClasses()) {
                JClass innerCls = new JClass(javaClass, this);
                this.add(innerCls);
                innerCls.update();
            }
            for (JavaField f : this.cls.getFields()) {
                this.add(new JField(f, this));
            }
            for (JavaMethod m : this.cls.getMethods()) {
                this.add(new JMethod(m, this));
            }
        }
    }

    @Override
    public ICodeInfo getCodeInfo() {
        return this.cls.getCodeInfo();
    }

    @Override
    public ContentPanel getContentPanel(TabbedPane tabbedPane) {
        return new ClassCodeContentPanel(tabbedPane, this);
    }

    public String getSmali() {
        return this.cls.getSmali();
    }

    @Override
    public String getSyntaxName() {
        return "text/java";
    }

    @Override
    public Icon getIcon() {
        AccessInfo accessInfo = this.cls.getAccessInfo();
        if (accessInfo.isEnum()) {
            return ICON_ENUM;
        }
        if (accessInfo.isAnnotation()) {
            return ICON_ANNOTATION;
        }
        if (accessInfo.isInterface()) {
            return ICON_INTERFACE;
        }
        if (accessInfo.isAbstract()) {
            return ICON_CLASS_ABSTRACT;
        }
        if (accessInfo.isProtected()) {
            return ICON_CLASS_PROTECTED;
        }
        if (accessInfo.isPrivate()) {
            return ICON_CLASS_PRIVATE;
        }
        if (accessInfo.isPublic()) {
            return ICON_CLASS_PUBLIC;
        }
        return ICON_CLASS;
    }

    @Override
    public JavaNode getJavaNode() {
        return this.cls;
    }

    @Override
    public JClass getJParent() {
        return this.jParent;
    }

    @Override
    public JClass getRootClass() {
        if (this.jParent == null) {
            return this;
        }
        return this.jParent.getRootClass();
    }

    @Override
    public String getName() {
        return this.cls.getName();
    }

    public String getFullName() {
        return this.cls.getFullName();
    }

    public int hashCode() {
        return this.cls.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof JClass && this.cls.equals((Object)((JClass)obj).cls);
    }

    @Override
    public String makeString() {
        return this.cls.getName();
    }

    @Override
    public String makeLongString() {
        return this.cls.getFullName();
    }

    public int compareToCls(@NotNull JClass otherCls) {
        return this.getCls().getRawName().compareTo(otherCls.getCls().getRawName());
    }

    @Override
    public int compareTo(@NotNull JNode other) {
        if (other instanceof JClass) {
            return this.compareToCls((JClass)other);
        }
        if (other instanceof JMethod) {
            int cmp = this.compareToCls(other.getJParent());
            if (cmp != 0) {
                return cmp;
            }
            return -1;
        }
        return super.compareTo(other);
    }
}

