/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.logging;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.logging.TextFormatter;
import net.sf.freecol.common.util.OSUtils;

public final class DefaultHandler
extends Handler {
    private final Object writerLock = new Object();
    private Writer writer = null;
    private final boolean consoleLogging;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultHandler(boolean consoleLogging, Writer writer) {
        this.consoleLogging = consoleLogging;
        this.writer = writer;
        this.setFormatter(new TextFormatter());
        try {
            StringBuilder sb = new StringBuilder(512);
            sb.append("FreeCol game version: ").append(FreeCol.getRevision()).append("\nFreeCol protocol version: ").append(FreeCol.getFreeColProtocolVersion()).append("\n\nJava vendor: ").append(System.getProperty("java.vendor")).append("\nJava version: ").append(System.getProperty("java.version")).append("\nJava WM name: ").append(System.getProperty("java.vm.name")).append("\nJava WM vendor: ").append(System.getProperty("java.vm.vendor")).append("\nJava WM version: ").append(System.getProperty("java.vm.version")).append("\n\nOS name: ").append(OSUtils.getOperatingSystem()).append("\nOS architecture: ").append(System.getProperty("os.arch")).append("\nOS version: ").append(System.getProperty("os.version")).append("\n\n");
            Object object = this.writerLock;
            synchronized (object) {
                this.writer.write(sb.toString());
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.writerLock;
        synchronized (object) {
            if (this.writer != null) {
                try {
                    this.writer.close();
                    this.writer = null;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(System.err);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.writerLock;
        synchronized (object) {
            if (this.writer != null) {
                try {
                    this.writer.flush();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(System.err);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        if (record.getLevel().intValue() < this.getLevel().intValue() && record.getThrown() == null) {
            return;
        }
        String str = this.getFormatter().format(record);
        if (this.consoleLogging && record.getLevel().intValue() >= Level.WARNING.intValue()) {
            System.err.println(str);
        }
        Object object = this.writerLock;
        synchronized (object) {
            if (this.writer != null) {
                try {
                    this.writer.write(str, 0, str.length());
                    this.flush();
                }
                catch (IOException ioe) {
                    System.err.println("Failed to write log record: " + str);
                    ioe.printStackTrace(System.err);
                }
            }
        }
        Throwable t = record.getThrown();
        if (!(t == null || t instanceof FreeColException && ((FreeColException)t).debugAllowed())) {
            FreeColDebugger.handleCrash();
        }
    }
}

