/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser;

import java.util.ArrayList;
import java.util.Iterator;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.helper.Validate;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.internal.StringUtil;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Attribute;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Attributes;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Document;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.DocumentType;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Element;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.FormElement;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Node;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.HtmlTreeBuilder;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.ParseSettings;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.Tag;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.Token;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.TokeniserState;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.TreeBuilder;

abstract class HtmlTreeBuilderState
extends Enum<HtmlTreeBuilderState> {
    public static final /* enum */ HtmlTreeBuilderState Initial = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            void var1_1;
            if (HtmlTreeBuilderState.isWhitespace(t)) {
                return true;
            }
            if (t.isComment()) {
                tb.insertCommentNode(t.asComment());
            } else if (t.isDoctype()) {
                void var3_3;
                Token.Doctype d = t.asDoctype();
                DocumentType doctype = new DocumentType(tb.settings.normalizeTag(d.getName()), d.getPublicIdentifier(), d.getSystemIdentifier());
                doctype.setPubSysKey(d.getPubSysKey());
                tb.getDocument().appendChild(doctype);
                tb.onNodeInserted((Node)var3_3);
                if (var1_1.isForceQuirks()) {
                    tb.getDocument().quirksMode(Document.QuirksMode.quirks);
                }
                tb.transition(BeforeHtml);
            } else {
                void var2_2;
                tb.transition(BeforeHtml);
                return var2_2.process((Token)var1_1);
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState BeforeHtml = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (t.isDoctype()) {
                tb.error(this);
                return false;
            }
            if (t.isComment()) {
                tb.insertCommentNode(t.asComment());
            } else if (HtmlTreeBuilderState.isWhitespace(t)) {
                tb.insertCharacterNode(t.asCharacter());
            } else if (t.isStartTag() && t.asStartTag().normalName().equals("html")) {
                tb.insertElementFor(t.asStartTag());
                tb.transition(BeforeHead);
            } else {
                void var2_2;
                void var1_1;
                if (t.isEndTag() && StringUtil.inSorted(t.asEndTag().normalName(), Constants.BeforeHtmlToHead)) {
                    return this.anythingElse(t, tb);
                }
                if (t.isEndTag()) {
                    tb.error(this);
                    return false;
                }
                return this.anythingElse((Token)var1_1, (HtmlTreeBuilder)var2_2);
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private boolean anythingElse(Token t, HtmlTreeBuilder tb) {
            void var1_1;
            void var2_2;
            tb.processStartTag("html");
            tb.transition(BeforeHead);
            return var2_2.process((Token)var1_1);
        }
    };
    public static final /* enum */ HtmlTreeBuilderState BeforeHead = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (HtmlTreeBuilderState.isWhitespace(t)) {
                tb.insertCharacterNode(t.asCharacter());
            } else if (t.isComment()) {
                tb.insertCommentNode(t.asComment());
            } else {
                void var1_1;
                if (t.isDoctype()) {
                    tb.error(this);
                    return false;
                }
                if (t.isStartTag() && t.asStartTag().normalName().equals("html")) {
                    return InBody.process(t, tb);
                }
                if (t.isStartTag() && t.asStartTag().normalName().equals("head")) {
                    Element head = tb.insertElementFor(t.asStartTag());
                    tb.setHeadElement((Element)var1_1);
                    tb.transition(InHead);
                } else {
                    void var2_2;
                    if (var1_1.isEndTag() && StringUtil.inSorted(var1_1.asEndTag().normalName(), Constants.BeforeHtmlToHead)) {
                        tb.processStartTag("head");
                        return tb.process((Token)var1_1);
                    }
                    if (var1_1.isEndTag()) {
                        tb.error(this);
                        return false;
                    }
                    tb.processStartTag("head");
                    return var2_2.process((Token)var1_1);
                }
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InHead = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (HtmlTreeBuilderState.isWhitespace(t)) {
                tb.insertCharacterNode(t.asCharacter());
                return true;
            }
            switch (t.type) {
                case Comment: {
                    tb.insertCommentNode(t.asComment());
                    break;
                }
                case Doctype: {
                    tb.error(this);
                    return false;
                }
                case StartTag: {
                    void var3_3;
                    Token.StartTag start = t.asStartTag();
                    String name = start.normalName();
                    if (name.equals("html")) {
                        return InBody.process(t, tb);
                    }
                    if (StringUtil.inSorted(name, Constants.InHeadEmpty)) {
                        Element el = tb.insertEmptyElementFor(start);
                        if (!name.equals("base") || !el.hasAttr("href")) break;
                        tb.maybeSetBaseUri((Element)var3_3);
                        break;
                    }
                    if (name.equals("meta")) {
                        tb.insertEmptyElementFor((Token.StartTag)var3_3);
                        break;
                    }
                    if (name.equals("title")) {
                        HtmlTreeBuilderState.access$200((Token.StartTag)var3_3, tb);
                        break;
                    }
                    if (StringUtil.inSorted(name, Constants.InHeadRaw)) {
                        HtmlTreeBuilderState.access$300((Token.StartTag)var3_3, tb);
                        break;
                    }
                    if (name.equals("noscript")) {
                        tb.insertElementFor((Token.StartTag)var3_3);
                        tb.transition(InHeadNoscript);
                        break;
                    }
                    if (name.equals("script")) {
                        tb.tokeniser.transition(TokeniserState.ScriptData);
                        tb.markInsertionMode();
                        tb.transition(Text);
                        tb.insertElementFor((Token.StartTag)var3_3);
                        break;
                    }
                    if (name.equals("head")) {
                        tb.error(this);
                        return false;
                    }
                    if (name.equals("template")) {
                        tb.insertElementFor((Token.StartTag)var3_3);
                        tb.insertMarkerToFormattingElements();
                        tb.framesetOk(false);
                        tb.transition(InTemplate);
                        tb.pushTemplateMode(InTemplate);
                        break;
                    }
                    return this.anythingElse(t, tb);
                }
                case EndTag: {
                    Token.EndTag endTag = t.asEndTag();
                    String name = endTag.normalName();
                    if (name.equals("head")) {
                        tb.pop();
                        tb.transition(AfterHead);
                        break;
                    }
                    if (StringUtil.inSorted(name, Constants.InHeadEnd)) {
                        return this.anythingElse(t, tb);
                    }
                    if (name.equals("template")) {
                        if (!tb.onStack(name)) {
                            tb.error(this);
                            break;
                        }
                        tb.generateImpliedEndTags(true);
                        if (!tb.currentElementIs(name)) {
                            tb.error(this);
                        }
                        tb.popStackToClose(name);
                        tb.clearFormattingElementsToLastMarker();
                        tb.popTemplateMode();
                        tb.resetInsertionMode();
                        break;
                    }
                    tb.error(this);
                    return false;
                }
                default: {
                    void var2_2;
                    void var1_1;
                    return this.anythingElse((Token)var1_1, (TreeBuilder)var2_2);
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private boolean anythingElse(Token t, TreeBuilder tb) {
            void var1_1;
            void var2_2;
            tb.processEndTag("head");
            return var2_2.process((Token)var1_1);
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InHeadNoscript = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (t.isDoctype()) {
                tb.error(this);
            } else {
                if (t.isStartTag() && t.asStartTag().normalName().equals("html")) {
                    return tb.process(t, InBody);
                }
                if (t.isEndTag() && t.asEndTag().normalName().equals("noscript")) {
                    tb.pop();
                    tb.transition(InHead);
                } else {
                    void var2_2;
                    void var1_1;
                    if (HtmlTreeBuilderState.isWhitespace(t) || t.isComment() || t.isStartTag() && StringUtil.inSorted(t.asStartTag().normalName(), Constants.InHeadNoScriptHead)) {
                        return tb.process(t, InHead);
                    }
                    if (t.isEndTag() && t.asEndTag().normalName().equals("br")) {
                        return this.anythingElse(t, tb);
                    }
                    if (t.isStartTag() && StringUtil.inSorted(t.asStartTag().normalName(), Constants.InHeadNoscriptIgnore) || t.isEndTag()) {
                        tb.error(this);
                        return false;
                    }
                    return this.anythingElse((Token)var1_1, (HtmlTreeBuilder)var2_2);
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private boolean anythingElse(Token t, HtmlTreeBuilder tb) {
            void var1_1;
            void var2_2;
            tb.error(this);
            var2_2.insertCharacterNode(new Token.Character().data(var1_1.toString()));
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState AfterHead = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            void var3_4;
            if (HtmlTreeBuilderState.isWhitespace(t)) {
                tb.insertCharacterNode(t.asCharacter());
                return true;
            }
            if (t.isComment()) {
                tb.insertCommentNode(t.asComment());
                return true;
            }
            if (t.isDoctype()) {
                tb.error(this);
                return true;
            }
            if (t.isStartTag()) {
                Token.StartTag startTag = t.asStartTag();
                String name = startTag.normalName();
                if (name.equals("html")) {
                    return tb.process(t, InBody);
                }
                if (name.equals("body")) {
                    tb.insertElementFor(startTag);
                    tb.framesetOk(false);
                    tb.transition(InBody);
                    return true;
                }
                if (name.equals("frameset")) {
                    tb.insertElementFor(startTag);
                    tb.transition(InFrameset);
                    return true;
                }
                if (StringUtil.inSorted(name, Constants.InBodyStartToHead)) {
                    tb.error(this);
                    Element head = tb.getHeadElement();
                    tb.push(head);
                    tb.process(t, InHead);
                    tb.removeFromStack(head);
                    return true;
                }
                if (name.equals("head")) {
                    tb.error(this);
                    return false;
                }
                this.anythingElse(t, tb);
                return true;
            }
            if (!t.isEndTag()) {
                void var2_2;
                void var1_1;
                this.anythingElse((Token)var1_1, (HtmlTreeBuilder)var2_2);
                return true;
            }
            String name = t.asEndTag().normalName();
            if (StringUtil.inSorted(name, Constants.AfterHeadBody)) {
                this.anythingElse(t, tb);
                return true;
            }
            if (var3_4.equals("template")) {
                tb.process(t, InHead);
                return true;
            }
            tb.error(this);
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private boolean anythingElse(Token t, HtmlTreeBuilder tb) {
            void var1_1;
            void var2_2;
            tb.processStartTag("body");
            tb.framesetOk(true);
            return var2_2.process((Token)var1_1);
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InBody = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            switch (t.type) {
                case Character: {
                    void var1_1;
                    Token.Character c = t.asCharacter();
                    if (c.getData().equals(nullString)) {
                        tb.error(this);
                        return false;
                    }
                    if (tb.framesetOk() && HtmlTreeBuilderState.isWhitespace(c)) {
                        tb.reconstructFormattingElements();
                        tb.insertCharacterNode(c);
                        break;
                    }
                    tb.reconstructFormattingElements();
                    tb.insertCharacterNode((Token.Character)var1_1);
                    tb.framesetOk(false);
                    break;
                }
                case Comment: {
                    void var1_1;
                    tb.insertCommentNode(var1_1.asComment());
                    break;
                }
                case Doctype: {
                    tb.error(this);
                    return false;
                }
                case StartTag: {
                    void var1_1;
                    return this.inBodyStartTag((Token)var1_1, tb);
                }
                case EndTag: {
                    void var1_1;
                    return this.inBodyEndTag((Token)var1_1, tb);
                }
                case EOF: {
                    void var2_2;
                    void var1_1;
                    if (tb.templateModeSize() > 0) {
                        return tb.process((Token)var1_1, InTemplate);
                    }
                    if (!tb.onStackNot(Constants.InBodyEndOtherErrors)) break;
                    var2_2.error(this);
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private boolean inBodyStartTag(Token t, HtmlTreeBuilder tb) {
            String name;
            Token.StartTag startTag = t.asStartTag();
            switch (name = startTag.normalName()) {
                case "a": {
                    if (tb.getActiveFormattingElement("a") != null) {
                        tb.error(this);
                        tb.processEndTag("a");
                        Element remainingA = tb.getFromStack("a");
                        if (remainingA != null) {
                            tb.removeFromActiveFormattingElements(remainingA);
                            tb.removeFromStack(remainingA);
                        }
                    }
                    tb.reconstructFormattingElements();
                    Element el = tb.insertElementFor(startTag);
                    tb.pushActiveFormattingElements(el);
                    break;
                }
                case "span": {
                    tb.reconstructFormattingElements();
                    tb.insertElementFor(startTag);
                    break;
                }
                case "li": {
                    Element el;
                    tb.framesetOk(false);
                    Object stack = tb.getStack();
                    for (int i = ((ArrayList)stack).size() - 1; i > 0; --i) {
                        el = ((ArrayList)stack).get(i);
                        if (el.nameIs("li")) {
                            tb.processEndTag("li");
                            break;
                        }
                        if (HtmlTreeBuilder.isSpecial(el) && !StringUtil.inSorted(el.normalName(), Constants.InBodyStartLiBreakers)) break;
                    }
                    if (tb.inButtonScope("p")) {
                        tb.processEndTag("p");
                    }
                    tb.insertElementFor(startTag);
                    break;
                }
                case "html": {
                    Object attribute22;
                    tb.error(this);
                    if (tb.onStack("template")) {
                        return false;
                    }
                    Object stack = tb.getStack();
                    if (((ArrayList)stack).size() <= 0) break;
                    Element html = tb.getStack().get(0);
                    if (!startTag.hasAttributes()) break;
                    for (Object attribute22 : startTag.attributes) {
                        if (html.hasAttr(((Attribute)attribute22).getKey())) continue;
                        html.attributes().put((Attribute)attribute22);
                    }
                    break;
                }
                case "body": {
                    Element body;
                    Object attribute22;
                    tb.error(this);
                    Object stack = tb.getStack();
                    if (((ArrayList)stack).size() == 1 || ((ArrayList)stack).size() > 2 && !((ArrayList)stack).get(1).nameIs("body") || tb.onStack("template")) {
                        return false;
                    }
                    tb.framesetOk(false);
                    if (!((Token.Tag)attribute22).hasAttributes() || (body = tb.getFromStack("body")) == null) break;
                    for (Object attribute22 : ((Token.StartTag)attribute22).attributes) {
                        if (body.hasAttr(((Attribute)attribute22).getKey())) continue;
                        body.attributes().put((Attribute)attribute22);
                    }
                    break;
                }
                case "frameset": {
                    Object attribute22;
                    tb.error(this);
                    Object stack = tb.getStack();
                    if (((ArrayList)stack).size() == 1 || ((ArrayList)stack).size() > 2 && !((ArrayList)stack).get(1).nameIs("body")) {
                        return false;
                    }
                    if (!tb.framesetOk()) {
                        return false;
                    }
                    Element second = ((ArrayList)stack).get(1);
                    if (second.parent() != null) {
                        second.remove();
                    }
                    while (((ArrayList)stack).size() > 1) {
                        Iterator<Attribute> iterator = stack;
                        ((ArrayList)((Object)iterator)).remove(((ArrayList)((Object)iterator)).size() - 1);
                    }
                    tb.insertElementFor((Token.StartTag)attribute22);
                    tb.transition(InFrameset);
                    break;
                }
                case "form": {
                    Object attribute22;
                    if (tb.getFormElement() != null && !tb.onStack("template")) {
                        tb.error(this);
                        return false;
                    }
                    if (tb.inButtonScope("p")) {
                        tb.closeElement("p");
                    }
                    tb.insertFormElement((Token.StartTag)attribute22, true, true);
                    break;
                }
                case "plaintext": {
                    Object attribute22;
                    if (tb.inButtonScope("p")) {
                        tb.processEndTag("p");
                    }
                    tb.insertElementFor((Token.StartTag)attribute22);
                    tb.tokeniser.transition(TokeniserState.PLAINTEXT);
                    break;
                }
                case "button": {
                    Object attribute22;
                    if (tb.inButtonScope("button")) {
                        tb.error(this);
                        tb.processEndTag("button");
                        tb.process((Token)attribute22);
                        break;
                    }
                    tb.reconstructFormattingElements();
                    tb.insertElementFor((Token.StartTag)attribute22);
                    tb.framesetOk(false);
                    break;
                }
                case "nobr": {
                    Object attribute22;
                    tb.reconstructFormattingElements();
                    if (tb.inScope("nobr")) {
                        tb.error(this);
                        tb.processEndTag("nobr");
                        tb.reconstructFormattingElements();
                    }
                    Element el = tb.insertElementFor((Token.StartTag)attribute22);
                    tb.pushActiveFormattingElements(el);
                    break;
                }
                case "table": {
                    Object attribute22;
                    if (tb.getDocument().quirksMode() != Document.QuirksMode.quirks && tb.inButtonScope("p")) {
                        tb.processEndTag("p");
                    }
                    tb.insertElementFor((Token.StartTag)attribute22);
                    tb.framesetOk(false);
                    tb.transition(InTable);
                    break;
                }
                case "input": {
                    Object attribute22;
                    tb.reconstructFormattingElements();
                    Element el = tb.insertEmptyElementFor((Token.StartTag)attribute22);
                    if (el.attr("type").equalsIgnoreCase("hidden")) break;
                    tb.framesetOk(false);
                    break;
                }
                case "hr": {
                    Object attribute22;
                    if (tb.inButtonScope("p")) {
                        tb.processEndTag("p");
                    }
                    tb.insertEmptyElementFor((Token.StartTag)attribute22);
                    tb.framesetOk(false);
                    break;
                }
                case "image": {
                    Object attribute22;
                    if (tb.getFromStack("svg") == null) {
                        return tb.process(((Token.Tag)attribute22).name("img"));
                    }
                    tb.insertElementFor((Token.StartTag)attribute22);
                    break;
                }
                case "isindex": {
                    FormElement form;
                    Object attribute22;
                    tb.error(this);
                    if (tb.getFormElement() != null) {
                        return false;
                    }
                    tb.processStartTag("form");
                    if (((Token.Tag)attribute22).hasAttribute("action") && (form = tb.getFormElement()) != null && ((Token.Tag)attribute22).hasAttribute("action")) {
                        String action = ((Token.StartTag)attribute22).attributes.get("action");
                        form.attributes().put("action", action);
                    }
                    tb.processStartTag("hr");
                    tb.processStartTag("label");
                    String prompt = ((Token.Tag)attribute22).hasAttribute("prompt") ? ((Token.StartTag)attribute22).attributes.get("prompt") : "This is a searchable index. Enter search keywords: ";
                    tb.process(new Token.Character().data(prompt));
                    Attributes inputAttribs = new Attributes();
                    if (((Token.Tag)attribute22).hasAttributes()) {
                        for (Attribute attr : ((Token.StartTag)attribute22).attributes) {
                            if (StringUtil.inSorted(attr.getKey(), Constants.InBodyStartInputAttribs)) continue;
                            inputAttribs.put(attr);
                        }
                    }
                    inputAttribs.put("name", "isindex");
                    tb.processStartTag("input", inputAttribs);
                    tb.processEndTag("label");
                    tb.processStartTag("hr");
                    tb.processEndTag("form");
                    break;
                }
                case "textarea": {
                    Object attribute22;
                    tb.insertElementFor((Token.StartTag)attribute22);
                    if (((Token.Tag)attribute22).isSelfClosing()) break;
                    tb.tokeniser.transition(TokeniserState.Rcdata);
                    tb.markInsertionMode();
                    tb.framesetOk(false);
                    tb.transition(Text);
                    break;
                }
                case "xmp": {
                    Object attribute22;
                    if (tb.inButtonScope("p")) {
                        tb.processEndTag("p");
                    }
                    tb.reconstructFormattingElements();
                    tb.framesetOk(false);
                    HtmlTreeBuilderState.access$300((Token.StartTag)attribute22, tb);
                    break;
                }
                case "iframe": {
                    Object attribute22;
                    tb.framesetOk(false);
                    HtmlTreeBuilderState.access$300((Token.StartTag)attribute22, tb);
                    break;
                }
                case "noembed": {
                    Object attribute22;
                    HtmlTreeBuilderState.access$300((Token.StartTag)attribute22, tb);
                    break;
                }
                case "select": {
                    void var3_3;
                    Object attribute22;
                    tb.reconstructFormattingElements();
                    tb.insertElementFor((Token.StartTag)attribute22);
                    tb.framesetOk(false);
                    if (((Token.StartTag)attribute22).selfClosing) break;
                    HtmlTreeBuilderState state = tb.state();
                    if (state.equals((Object)InTable) || state.equals((Object)InCaption) || state.equals((Object)InTableBody) || state.equals((Object)InRow) || var3_3.equals((Object)InCell)) {
                        tb.transition(InSelectInTable);
                        break;
                    }
                    tb.transition(InSelect);
                    break;
                }
                case "math": {
                    void var3_3;
                    tb.reconstructFormattingElements();
                    tb.insertForeignElementFor((Token.StartTag)var3_3, "http://www.w3.org/1998/Math/MathML");
                    break;
                }
                case "svg": {
                    void var3_3;
                    tb.reconstructFormattingElements();
                    tb.insertForeignElementFor((Token.StartTag)var3_3, "http://www.w3.org/2000/svg");
                    break;
                }
                case "h1": 
                case "h2": 
                case "h3": 
                case "h4": 
                case "h5": 
                case "h6": {
                    void var3_3;
                    if (tb.inButtonScope("p")) {
                        tb.processEndTag("p");
                    }
                    if (StringUtil.inSorted(tb.currentElement().normalName(), Constants.Headings)) {
                        tb.error(this);
                        tb.pop();
                    }
                    tb.insertElementFor((Token.StartTag)var3_3);
                    break;
                }
                case "pre": 
                case "listing": {
                    void var3_3;
                    if (tb.inButtonScope("p")) {
                        tb.processEndTag("p");
                    }
                    tb.insertElementFor((Token.StartTag)var3_3);
                    tb.reader.matchConsume("\n");
                    tb.framesetOk(false);
                    break;
                }
                case "dd": 
                case "dt": {
                    void var3_3;
                    tb.framesetOk(false);
                    Object stack = tb.getStack();
                    int bottom = ((ArrayList)stack).size() - 1;
                    int upper = bottom >= 24 ? bottom - 24 : 0;
                    for (int i = bottom; i >= upper; --i) {
                        Element el = ((ArrayList)stack).get(i);
                        if (StringUtil.inSorted(el.normalName(), Constants.DdDt)) {
                            tb.processEndTag(el.normalName());
                            break;
                        }
                        if (HtmlTreeBuilder.isSpecial(el) && !StringUtil.inSorted(el.normalName(), Constants.InBodyStartLiBreakers)) break;
                    }
                    if (tb.inButtonScope("p")) {
                        tb.processEndTag("p");
                    }
                    tb.insertElementFor((Token.StartTag)var3_3);
                    break;
                }
                case "optgroup": 
                case "option": {
                    void var3_3;
                    if (tb.currentElementIs("option")) {
                        tb.processEndTag("option");
                    }
                    tb.reconstructFormattingElements();
                    tb.insertElementFor((Token.StartTag)var3_3);
                    break;
                }
                case "rb": 
                case "rtc": {
                    void var3_3;
                    if (tb.inScope("ruby")) {
                        tb.generateImpliedEndTags();
                        if (!tb.currentElementIs("ruby")) {
                            tb.error(this);
                        }
                    }
                    tb.insertElementFor((Token.StartTag)var3_3);
                    break;
                }
                case "rp": 
                case "rt": {
                    void var3_3;
                    if (tb.inScope("ruby")) {
                        tb.generateImpliedEndTags("rtc");
                        if (!tb.currentElementIs("rtc") && !tb.currentElementIs("ruby")) {
                            tb.error(this);
                        }
                    }
                    tb.insertElementFor((Token.StartTag)var3_3);
                    break;
                }
                case "area": 
                case "br": 
                case "embed": 
                case "img": 
                case "keygen": 
                case "wbr": {
                    void var3_3;
                    tb.reconstructFormattingElements();
                    tb.insertEmptyElementFor((Token.StartTag)var3_3);
                    tb.framesetOk(false);
                    break;
                }
                case "b": 
                case "big": 
                case "code": 
                case "em": 
                case "font": 
                case "i": 
                case "s": 
                case "small": 
                case "strike": 
                case "strong": 
                case "tt": 
                case "u": {
                    void var3_3;
                    tb.reconstructFormattingElements();
                    Element el = tb.insertElementFor((Token.StartTag)var3_3);
                    tb.pushActiveFormattingElements(el);
                    break;
                }
                default: {
                    void var2_2;
                    void var4_4;
                    void var3_3;
                    if (!Tag.isKnownTag((String)var4_4)) {
                        tb.insertElementFor((Token.StartTag)var3_3);
                        break;
                    }
                    if (StringUtil.inSorted((String)var4_4, Constants.InBodyStartPClosers)) {
                        if (tb.inButtonScope("p")) {
                            tb.processEndTag("p");
                        }
                        tb.insertElementFor((Token.StartTag)var3_3);
                        break;
                    }
                    if (StringUtil.inSorted((String)var4_4, Constants.InBodyStartToHead)) {
                        void var1_1;
                        return tb.process((Token)var1_1, InHead);
                    }
                    if (StringUtil.inSorted((String)var4_4, Constants.InBodyStartApplets)) {
                        tb.reconstructFormattingElements();
                        tb.insertElementFor((Token.StartTag)var3_3);
                        tb.insertMarkerToFormattingElements();
                        tb.framesetOk(false);
                        break;
                    }
                    if (StringUtil.inSorted((String)var4_4, Constants.InBodyStartMedia)) {
                        tb.insertEmptyElementFor((Token.StartTag)var3_3);
                        break;
                    }
                    if (StringUtil.inSorted((String)var4_4, Constants.InBodyStartDrop)) {
                        tb.error(this);
                        return false;
                    }
                    tb.reconstructFormattingElements();
                    var2_2.insertElementFor((Token.StartTag)var3_3);
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private boolean inBodyEndTag(Token t, HtmlTreeBuilder tb) {
            String name;
            Token.EndTag endTag = t.asEndTag();
            switch (name = endTag.normalName()) {
                case "template": {
                    tb.process(t, InHead);
                    break;
                }
                case "sarcasm": 
                case "span": {
                    return this.anyOtherEndTag(t, tb);
                }
                case "li": {
                    if (!tb.inListItemScope(name)) {
                        tb.error(this);
                        return false;
                    }
                    tb.generateImpliedEndTags(name);
                    if (!tb.currentElementIs(name)) {
                        tb.error(this);
                    }
                    tb.popStackToClose(name);
                    break;
                }
                case "body": {
                    if (!tb.inScope("body")) {
                        tb.error(this);
                        return false;
                    }
                    if (tb.onStackNot(Constants.InBodyEndOtherErrors)) {
                        tb.error(this);
                    }
                    HtmlTreeBuilder htmlTreeBuilder = tb;
                    htmlTreeBuilder.onNodeClosed(htmlTreeBuilder.getFromStack("body"));
                    tb.transition(AfterBody);
                    break;
                }
                case "html": {
                    if (!tb.onStack("body")) {
                        tb.error(this);
                        return false;
                    }
                    if (tb.onStackNot(Constants.InBodyEndOtherErrors)) {
                        tb.error(this);
                    }
                    tb.transition(AfterBody);
                    return tb.process(t);
                }
                case "form": {
                    void var1_1;
                    if (!tb.onStack("template")) {
                        FormElement currentForm = tb.getFormElement();
                        tb.setFormElement(null);
                        if (currentForm == null || !tb.inScope(name)) {
                            tb.error(this);
                            return false;
                        }
                        tb.generateImpliedEndTags();
                        if (!tb.currentElementIs(name)) {
                            tb.error(this);
                        }
                        tb.removeFromStack((Element)var1_1);
                        break;
                    }
                    if (!tb.inScope(name)) {
                        tb.error(this);
                        return false;
                    }
                    tb.generateImpliedEndTags();
                    if (!tb.currentElementIs(name)) {
                        tb.error(this);
                    }
                    tb.popStackToClose(name);
                    break;
                }
                case "p": {
                    if (!tb.inButtonScope(name)) {
                        void var3_3;
                        tb.error(this);
                        tb.processStartTag(name);
                        return tb.process((Token)var3_3);
                    }
                    tb.generateImpliedEndTags(name);
                    if (!tb.currentElementIs(name)) {
                        tb.error(this);
                    }
                    tb.popStackToClose(name);
                    break;
                }
                case "dd": 
                case "dt": {
                    if (!tb.inScope(name)) {
                        tb.error(this);
                        return false;
                    }
                    tb.generateImpliedEndTags(name);
                    if (!tb.currentElementIs(name)) {
                        tb.error(this);
                    }
                    tb.popStackToClose(name);
                    break;
                }
                case "h1": 
                case "h2": 
                case "h3": 
                case "h4": 
                case "h5": 
                case "h6": {
                    if (!tb.inScope(Constants.Headings)) {
                        tb.error(this);
                        return false;
                    }
                    tb.generateImpliedEndTags(name);
                    if (!tb.currentElementIs(name)) {
                        tb.error(this);
                    }
                    tb.popStackToClose(Constants.Headings);
                    break;
                }
                case "br": {
                    tb.error(this);
                    tb.processStartTag("br");
                    return false;
                }
                default: {
                    void var2_2;
                    void var1_1;
                    if (StringUtil.inSorted(name, Constants.InBodyEndAdoptionFormatters)) {
                        return this.inBodyEndTagAdoption((Token)var1_1, tb);
                    }
                    if (StringUtil.inSorted(name, Constants.InBodyEndClosers)) {
                        if (!tb.inScope(name)) {
                            tb.error(this);
                            return false;
                        }
                        tb.generateImpliedEndTags();
                        if (!tb.currentElementIs(name)) {
                            tb.error(this);
                        }
                        tb.popStackToClose(name);
                        break;
                    }
                    if (StringUtil.inSorted(name, Constants.InBodyStartApplets)) {
                        if (tb.inScope("name")) break;
                        if (!tb.inScope(name)) {
                            tb.error(this);
                            return false;
                        }
                        tb.generateImpliedEndTags();
                        if (!tb.currentElementIs(name)) {
                            tb.error(this);
                        }
                        tb.popStackToClose(name);
                        tb.clearFormattingElementsToLastMarker();
                        break;
                    }
                    return this.anyOtherEndTag((Token)var1_1, (HtmlTreeBuilder)var2_2);
                }
            }
            return true;
        }

        final boolean anyOtherEndTag(Token t, HtmlTreeBuilder tb) {
            String name = t.asEndTag().normalName;
            ArrayList<Element> stack = tb.getStack();
            Element element = tb.getFromStack(name);
            if (element == null) {
                tb.error(this);
                return false;
            }
            for (int pos = stack.size() - 1; pos >= 0; --pos) {
                Element node = stack.get(pos);
                if (node.nameIs(name)) {
                    tb.generateImpliedEndTags(name);
                    if (!tb.currentElementIs(name)) {
                        tb.error(this);
                    }
                    tb.popStackToClose(name);
                    break;
                }
                if (!HtmlTreeBuilder.isSpecial(node)) continue;
                tb.error(this);
                return false;
            }
            return true;
        }

        private boolean inBodyEndTagAdoption(Token t, HtmlTreeBuilder tb) {
            Token.EndTag endTag = t.asEndTag();
            String name = endTag.normalName();
            ArrayList<Element> stack = tb.getStack();
            for (int i = 0; i < 8; ++i) {
                Element formatEl = tb.getActiveFormattingElement(name);
                if (formatEl == null) {
                    return this.anyOtherEndTag(t, tb);
                }
                if (!tb.onStack(formatEl)) {
                    tb.error(this);
                    tb.removeFromActiveFormattingElements(formatEl);
                    return true;
                }
                if (!tb.inScope(formatEl.normalName())) {
                    tb.error(this);
                    return false;
                }
                if (tb.currentElement() != formatEl) {
                    tb.error(this);
                }
                Element furthestBlock = null;
                Element commonAncestor = null;
                boolean seenFormattingElement = false;
                int stackSize = stack.size();
                int bookmark = -1;
                for (int si = 1; si < stackSize && si < 64; ++si) {
                    Element el = stack.get(si);
                    if (el == formatEl) {
                        commonAncestor = stack.get(si - 1);
                        seenFormattingElement = true;
                        bookmark = tb.positionOfElement(el);
                        continue;
                    }
                    if (!seenFormattingElement || !HtmlTreeBuilder.isSpecial(el)) continue;
                    furthestBlock = el;
                    break;
                }
                if (furthestBlock == null) {
                    tb.popStackToClose(formatEl.normalName());
                    tb.removeFromActiveFormattingElements(formatEl);
                    return true;
                }
                Element node = furthestBlock;
                Element lastNode = furthestBlock;
                for (int j = 0; j < 3; ++j) {
                    if (tb.onStack(node)) {
                        node = tb.aboveOnStack(node);
                    }
                    if (!tb.isInActiveFormattingElements(node)) {
                        tb.removeFromStack(node);
                        continue;
                    }
                    if (node == formatEl) break;
                    Element replacement = new Element(tb.tagFor(node.nodeName(), ParseSettings.preserveCase), tb.getBaseUri());
                    tb.replaceActiveFormattingElement(node, replacement);
                    tb.replaceOnStack(node, replacement);
                    node = replacement;
                    if (lastNode == furthestBlock) {
                        bookmark = tb.positionOfElement(node) + 1;
                    }
                    if (lastNode.parent() != null) {
                        lastNode.remove();
                    }
                    node.appendChild(lastNode);
                    lastNode = node;
                }
                if (commonAncestor != null) {
                    if (StringUtil.inSorted(commonAncestor.normalName(), Constants.InBodyEndTableFosters)) {
                        if (lastNode.parent() != null) {
                            lastNode.remove();
                        }
                        tb.insertInFosterParent(lastNode);
                    } else {
                        if (lastNode.parent() != null) {
                            lastNode.remove();
                        }
                        commonAncestor.appendChild(lastNode);
                    }
                }
                Element adopter = new Element(formatEl.tag(), tb.getBaseUri());
                adopter.attributes().addAll(formatEl.attributes());
                adopter.appendChildren(furthestBlock.childNodes());
                furthestBlock.appendChild(adopter);
                tb.removeFromActiveFormattingElements(formatEl);
                tb.pushWithBookmark(adopter, bookmark);
                tb.removeFromStack(formatEl);
                tb.insertOnStackAfter(furthestBlock, adopter);
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState Text = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (t.isCharacter()) {
                tb.insertCharacterNode(t.asCharacter());
            } else {
                void var1_1;
                if (t.isEOF()) {
                    tb.error(this);
                    tb.pop();
                    HtmlTreeBuilder htmlTreeBuilder = tb;
                    htmlTreeBuilder.transition(htmlTreeBuilder.originalState());
                    return tb.process(t);
                }
                if (var1_1.isEndTag()) {
                    void var2_2;
                    tb.pop();
                    void v1 = var2_2;
                    v1.transition(v1.originalState());
                }
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InTable = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            void var2_2;
            void var1_1;
            if (t.isCharacter() && StringUtil.inSorted(tb.currentElement().normalName(), Constants.InTableFoster)) {
                tb.resetPendingTableCharacters();
                tb.markInsertionMode();
                tb.transition(InTableText);
                return tb.process(t);
            }
            if (t.isComment()) {
                tb.insertCommentNode(t.asComment());
                return true;
            }
            if (t.isDoctype()) {
                tb.error(this);
                return false;
            }
            if (t.isStartTag()) {
                Token.StartTag startTag = t.asStartTag();
                String name = startTag.normalName();
                if (name.equals("caption")) {
                    tb.clearStackToTableContext();
                    tb.insertMarkerToFormattingElements();
                    tb.insertElementFor(startTag);
                    tb.transition(InCaption);
                } else if (name.equals("colgroup")) {
                    tb.clearStackToTableContext();
                    tb.insertElementFor(startTag);
                    tb.transition(InColumnGroup);
                } else {
                    if (name.equals("col")) {
                        tb.clearStackToTableContext();
                        tb.processStartTag("colgroup");
                        return tb.process(t);
                    }
                    if (StringUtil.inSorted(name, Constants.InTableToBody)) {
                        tb.clearStackToTableContext();
                        tb.insertElementFor(startTag);
                        tb.transition(InTableBody);
                    } else {
                        if (StringUtil.inSorted(name, Constants.InTableAddBody)) {
                            tb.clearStackToTableContext();
                            tb.processStartTag("tbody");
                            return tb.process(t);
                        }
                        if (name.equals("table")) {
                            tb.error(this);
                            if (!tb.inTableScope(name)) {
                                return false;
                            }
                            tb.popStackToClose(name);
                            if (!tb.resetInsertionMode()) {
                                tb.insertElementFor(startTag);
                                return true;
                            }
                            return tb.process(t);
                        }
                        if (StringUtil.inSorted(name, Constants.InTableToHead)) {
                            return tb.process(t, InHead);
                        }
                        if (name.equals("input")) {
                            if (!startTag.hasAttributes() || !startTag.attributes.get("type").equalsIgnoreCase("hidden")) {
                                return this.anythingElse(t, tb);
                            }
                            tb.insertEmptyElementFor(startTag);
                        } else if (name.equals("form")) {
                            void var3_3;
                            tb.error(this);
                            if (tb.getFormElement() != null || tb.onStack("template")) {
                                return false;
                            }
                            tb.insertFormElement((Token.StartTag)var3_3, false, false);
                        } else {
                            return this.anythingElse(t, tb);
                        }
                    }
                }
                return true;
            }
            if (t.isEndTag()) {
                Token.EndTag endTag = t.asEndTag();
                String name = endTag.normalName();
                if (name.equals("table")) {
                    if (!tb.inTableScope(name)) {
                        tb.error(this);
                        return false;
                    }
                    tb.popStackToClose("table");
                    tb.resetInsertionMode();
                } else {
                    if (StringUtil.inSorted(name, Constants.InTableEndErr)) {
                        tb.error(this);
                        return false;
                    }
                    if (name.equals("template")) {
                        tb.process(t, InHead);
                    } else {
                        return this.anythingElse(t, tb);
                    }
                }
                return true;
            }
            if (t.isEOF()) {
                if (tb.currentElementIs("html")) {
                    tb.error(this);
                }
                return true;
            }
            return this.anythingElse((Token)var1_1, (HtmlTreeBuilder)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        final boolean anythingElse(Token t, HtmlTreeBuilder tb) {
            void var2_2;
            void var1_1;
            tb.error(this);
            tb.setFosterInserts(true);
            tb.process((Token)var1_1, InBody);
            var2_2.setFosterInserts(false);
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InTableText = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            Token.Character c;
            if (t.type == Token.TokenType.Character) {
                c = t.asCharacter();
                if (c.getData().equals(nullString)) {
                    tb.error(this);
                    return false;
                }
            } else {
                void var1_1;
                void var2_2;
                if (tb.getPendingTableCharacters().size() > 0) {
                    void var3_4;
                    Token og = tb.currentToken;
                    for (Token.Character c2 : tb.getPendingTableCharacters()) {
                        tb.currentToken = c2;
                        if (!HtmlTreeBuilderState.isWhitespace(c2)) {
                            tb.error(this);
                            if (StringUtil.inSorted(tb.currentElement().normalName(), Constants.InTableFoster)) {
                                tb.setFosterInserts(true);
                                tb.process(c2, InBody);
                                tb.setFosterInserts(false);
                                continue;
                            }
                            tb.process(c2, InBody);
                            continue;
                        }
                        tb.insertCharacterNode(c2);
                    }
                    tb.currentToken = var3_4;
                    tb.resetPendingTableCharacters();
                }
                HtmlTreeBuilder htmlTreeBuilder = tb;
                htmlTreeBuilder.transition(htmlTreeBuilder.originalState());
                return var2_2.process((Token)var1_1);
            }
            tb.addPendingTableCharacters(c);
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InCaption = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (t.isEndTag() && t.asEndTag().normalName().equals("caption")) {
                if (!tb.inTableScope("caption")) {
                    tb.error(this);
                    return false;
                }
                tb.generateImpliedEndTags();
                if (!tb.currentElementIs("caption")) {
                    tb.error(this);
                }
                tb.popStackToClose("caption");
                tb.clearFormattingElementsToLastMarker();
                tb.transition(InTable);
            } else if (t.isStartTag() && StringUtil.inSorted(t.asStartTag().normalName(), Constants.InCellCol) || t.isEndTag() && t.asEndTag().normalName().equals("table")) {
                if (!tb.inTableScope("caption")) {
                    tb.error(this);
                    return false;
                }
                tb.generateImpliedEndTags(false);
                if (!tb.currentElementIs("caption")) {
                    tb.error(this);
                }
                tb.popStackToClose("caption");
                tb.clearFormattingElementsToLastMarker();
                tb.transition(InTable);
                InTable.process(t, tb);
            } else {
                void var1_1;
                void var2_2;
                if (t.isEndTag() && StringUtil.inSorted(t.asEndTag().normalName(), Constants.InCaptionIgnore)) {
                    tb.error(this);
                    return false;
                }
                return var2_2.process((Token)var1_1, InBody);
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InColumnGroup = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (HtmlTreeBuilderState.isWhitespace(t)) {
                tb.insertCharacterNode(t.asCharacter());
                return true;
            }
            block0 : switch (t.type) {
                case Comment: {
                    tb.insertCommentNode(t.asComment());
                    break;
                }
                case Doctype: {
                    tb.error(this);
                    break;
                }
                case StartTag: {
                    Token.StartTag startTag = t.asStartTag();
                    switch (startTag.normalName()) {
                        case "html": {
                            return tb.process(t, InBody);
                        }
                        case "col": {
                            void var3_3;
                            tb.insertEmptyElementFor((Token.StartTag)var3_3);
                            break block0;
                        }
                        case "template": {
                            tb.process(t, InHead);
                            break block0;
                        }
                    }
                    return this.anythingElse(t, tb);
                }
                case EndTag: {
                    String name;
                    Token.EndTag endTag = t.asEndTag();
                    switch (name = endTag.normalName()) {
                        case "colgroup": {
                            if (!tb.currentElementIs(name)) {
                                tb.error(this);
                                return false;
                            }
                            tb.pop();
                            tb.transition(InTable);
                            break block0;
                        }
                        case "template": {
                            tb.process(t, InHead);
                            break block0;
                        }
                    }
                    return this.anythingElse(t, tb);
                }
                case EOF: {
                    if (tb.currentElementIs("html")) {
                        return true;
                    }
                    return this.anythingElse(t, tb);
                }
                default: {
                    void var2_2;
                    void var1_1;
                    return this.anythingElse((Token)var1_1, (HtmlTreeBuilder)var2_2);
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private boolean anythingElse(Token t, HtmlTreeBuilder tb) {
            void var1_1;
            void var2_2;
            if (!tb.currentElementIs("colgroup")) {
                tb.error(this);
                return false;
            }
            tb.pop();
            tb.transition(InTable);
            var2_2.process((Token)var1_1);
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InTableBody = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            switch (t.type) {
                case StartTag: {
                    Token.StartTag startTag = t.asStartTag();
                    String name = startTag.normalName();
                    if (name.equals("tr")) {
                        tb.clearStackToTableBodyContext();
                        tb.insertElementFor(startTag);
                        tb.transition(InRow);
                        break;
                    }
                    if (StringUtil.inSorted(name, Constants.InCellNames)) {
                        void var3_3;
                        tb.error(this);
                        tb.processStartTag("tr");
                        return tb.process((Token)var3_3);
                    }
                    if (StringUtil.inSorted(name, Constants.InTableBodyExit)) {
                        return this.exitTableBody(t, tb);
                    }
                    return this.anythingElse(t, tb);
                }
                case EndTag: {
                    Token.EndTag endTag = t.asEndTag();
                    String name = endTag.normalName();
                    if (StringUtil.inSorted(name, Constants.InTableEndIgnore)) {
                        if (!tb.inTableScope(name)) {
                            tb.error(this);
                            return false;
                        }
                        tb.clearStackToTableBodyContext();
                        tb.pop();
                        tb.transition(InTable);
                        break;
                    }
                    if (name.equals("table")) {
                        return this.exitTableBody(t, tb);
                    }
                    if (StringUtil.inSorted(name, Constants.InTableBodyEndIgnore)) {
                        tb.error(this);
                        return false;
                    }
                    return this.anythingElse(t, tb);
                }
                default: {
                    void var2_2;
                    void var1_1;
                    return this.anythingElse((Token)var1_1, (HtmlTreeBuilder)var2_2);
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private boolean exitTableBody(Token t, HtmlTreeBuilder tb) {
            void var1_1;
            void var2_2;
            if (!(tb.inTableScope("tbody") || tb.inTableScope("thead") || tb.inScope("tfoot"))) {
                tb.error(this);
                return false;
            }
            tb.clearStackToTableBodyContext();
            HtmlTreeBuilder htmlTreeBuilder = tb;
            htmlTreeBuilder.processEndTag(htmlTreeBuilder.currentElement().normalName());
            return var2_2.process((Token)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private boolean anythingElse(Token t, HtmlTreeBuilder tb) {
            void var1_1;
            return tb.process((Token)var1_1, InTable);
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InRow = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (t.isStartTag()) {
                Token.StartTag startTag = t.asStartTag();
                String name = startTag.normalName();
                if (StringUtil.inSorted(name, Constants.InCellNames)) {
                    void var3_3;
                    tb.clearStackToTableRowContext();
                    tb.insertElementFor((Token.StartTag)var3_3);
                    tb.transition(InCell);
                    tb.insertMarkerToFormattingElements();
                    return true;
                }
                if (!StringUtil.inSorted(name, Constants.InRowMissing)) return this.anythingElse(t, tb);
                if (!tb.inTableScope("tr")) {
                    tb.error(this);
                    return false;
                }
                tb.clearStackToTableRowContext();
                tb.pop();
                tb.transition(InTableBody);
                return tb.process(t);
            }
            if (!t.isEndTag()) void var2_2;
            void var1_1;
            return this.anythingElse((Token)var1_1, (HtmlTreeBuilder)var2_2);
            Token.EndTag endTag = t.asEndTag();
            String name = endTag.normalName();
            if (name.equals("tr")) {
                if (!tb.inTableScope(name)) {
                    tb.error(this);
                    return false;
                }
                tb.clearStackToTableRowContext();
                tb.pop();
                tb.transition(InTableBody);
                return true;
            }
            if (name.equals("table")) {
                if (!tb.inTableScope("tr")) {
                    tb.error(this);
                    return false;
                }
                tb.clearStackToTableRowContext();
                tb.pop();
                tb.transition(InTableBody);
                return tb.process(t);
            }
            if (!StringUtil.inSorted(name, Constants.InTableToBody)) {
                if (!StringUtil.inSorted(name, Constants.InRowIgnore)) return this.anythingElse(t, tb);
                tb.error(this);
                return false;
            }
            if (!tb.inTableScope(name)) {
                tb.error(this);
                return false;
            }
            if (!tb.inTableScope("tr")) {
                return false;
            }
            tb.clearStackToTableRowContext();
            tb.pop();
            tb.transition(InTableBody);
            return tb.process(t);
        }

        /*
         * WARNING - void declaration
         */
        private boolean anythingElse(Token t, HtmlTreeBuilder tb) {
            void var1_1;
            return tb.process((Token)var1_1, InTable);
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InCell = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            void var2_2;
            void var1_1;
            if (t.isEndTag()) {
                Token.EndTag endTag = t.asEndTag();
                String name = endTag.normalName();
                if (StringUtil.inSorted(name, Constants.InCellNames)) {
                    if (!tb.inTableScope(name)) {
                        tb.error(this);
                        tb.transition(InRow);
                        return false;
                    }
                    tb.generateImpliedEndTags();
                    if (!tb.currentElementIs(name)) {
                        tb.error(this);
                    }
                    tb.popStackToClose(name);
                    tb.clearFormattingElementsToLastMarker();
                    tb.transition(InRow);
                    return true;
                }
                if (StringUtil.inSorted(name, Constants.InCellBody)) {
                    tb.error(this);
                    return false;
                }
                if (!StringUtil.inSorted(name, Constants.InCellTable)) return this.anythingElse(t, tb);
                if (!tb.inTableScope((String)((Object)endTag))) {
                    tb.error(this);
                    return false;
                }
                this.closeCell(tb);
                return tb.process(t);
            }
            if (!t.isStartTag()) return this.anythingElse((Token)var1_1, (HtmlTreeBuilder)var2_2);
            if (!StringUtil.inSorted(t.asStartTag().normalName(), Constants.InCellCol)) return this.anythingElse((Token)var1_1, (HtmlTreeBuilder)var2_2);
            if (!tb.inTableScope("td") && !tb.inTableScope("th")) {
                tb.error(this);
                return false;
            }
            this.closeCell(tb);
            return tb.process(t);
        }

        /*
         * WARNING - void declaration
         */
        private boolean anythingElse(Token t, HtmlTreeBuilder tb) {
            void var1_1;
            return tb.process((Token)var1_1, InBody);
        }

        /*
         * WARNING - void declaration
         */
        private void closeCell(HtmlTreeBuilder tb) {
            void var1_1;
            if (tb.inTableScope("td")) {
                tb.processEndTag("td");
                return;
            }
            var1_1.processEndTag("th");
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InSelect = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            block0 : switch (t.type) {
                case Character: {
                    void var1_1;
                    Token.Character c = t.asCharacter();
                    if (c.getData().equals(nullString)) {
                        tb.error(this);
                        return false;
                    }
                    tb.insertCharacterNode((Token.Character)var1_1);
                    break;
                }
                case Comment: {
                    void var1_1;
                    tb.insertCommentNode(var1_1.asComment());
                    break;
                }
                case Doctype: {
                    tb.error(this);
                    return false;
                }
                case StartTag: {
                    void var1_1;
                    Token.StartTag start = var1_1.asStartTag();
                    String name = start.normalName();
                    if (name.equals("html")) {
                        return tb.process(start, InBody);
                    }
                    if (name.equals("option")) {
                        if (tb.currentElementIs("option")) {
                            tb.processEndTag("option");
                        }
                        tb.insertElementFor(start);
                        break;
                    }
                    if (name.equals("optgroup")) {
                        if (tb.currentElementIs("option")) {
                            tb.processEndTag("option");
                        }
                        if (tb.currentElementIs("optgroup")) {
                            tb.processEndTag("optgroup");
                        }
                        tb.insertElementFor(start);
                        break;
                    }
                    if (name.equals("select")) {
                        tb.error(this);
                        return tb.processEndTag("select");
                    }
                    if (StringUtil.inSorted(name, Constants.InSelectEnd)) {
                        void var3_3;
                        tb.error(this);
                        if (!tb.inSelectScope("select")) {
                            return false;
                        }
                        tb.processEndTag("select");
                        return tb.process((Token)var3_3);
                    }
                    if (name.equals("script") || name.equals("template")) {
                        return tb.process((Token)var1_1, InHead);
                    }
                    return this.anythingElse((Token)var1_1, tb);
                }
                case EndTag: {
                    void var1_1;
                    Object object = var1_1.asEndTag();
                    String name = ((Token.Tag)object).normalName();
                    switch (name) {
                        case "optgroup": {
                            if (tb.currentElementIs("option")) {
                                HtmlTreeBuilder htmlTreeBuilder = tb;
                                if (htmlTreeBuilder.aboveOnStack(htmlTreeBuilder.currentElement()) != null) {
                                    HtmlTreeBuilder htmlTreeBuilder2 = tb;
                                    if (htmlTreeBuilder2.aboveOnStack(htmlTreeBuilder2.currentElement()).nameIs("optgroup")) {
                                        tb.processEndTag("option");
                                    }
                                }
                            }
                            if (tb.currentElementIs("optgroup")) {
                                tb.pop();
                                break block0;
                            }
                            tb.error(this);
                            break block0;
                        }
                        case "option": {
                            if (tb.currentElementIs("option")) {
                                tb.pop();
                                break block0;
                            }
                            tb.error(this);
                            break block0;
                        }
                        case "select": {
                            if (!tb.inSelectScope(name)) {
                                tb.error(this);
                                return false;
                            }
                            tb.popStackToClose(name);
                            tb.resetInsertionMode();
                            break block0;
                        }
                        case "template": {
                            return tb.process((Token)var1_1, InHead);
                        }
                    }
                    return this.anythingElse((Token)var1_1, tb);
                }
                case EOF: {
                    if (tb.currentElementIs("html")) break;
                    tb.error(this);
                    break;
                }
                default: {
                    void var2_2;
                    void var1_1;
                    return this.anythingElse((Token)var1_1, (HtmlTreeBuilder)var2_2);
                }
            }
            return true;
        }

        private boolean anythingElse(Token t, HtmlTreeBuilder tb) {
            tb.error(this);
            return false;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InSelectInTable = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            void var1_1;
            void var2_2;
            if (t.isStartTag() && StringUtil.inSorted(t.asStartTag().normalName(), Constants.InSelectTableEnd)) {
                tb.error(this);
                tb.popStackToClose("select");
                tb.resetInsertionMode();
                return tb.process(t);
            }
            if (t.isEndTag() && StringUtil.inSorted(t.asEndTag().normalName(), Constants.InSelectTableEnd)) {
                tb.error(this);
                if (tb.inTableScope(t.asEndTag().normalName())) {
                    tb.popStackToClose("select");
                    tb.resetInsertionMode();
                    return tb.process(t);
                }
                return false;
            }
            return var2_2.process((Token)var1_1, InSelect);
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InTemplate = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            switch (t.type) {
                case Comment: 
                case Doctype: 
                case Character: {
                    tb.process(t, InBody);
                    break;
                }
                case StartTag: {
                    void var3_3;
                    String name = t.asStartTag().normalName();
                    if (StringUtil.inSorted(name, Constants.InTemplateToHead)) {
                        tb.process(t, InHead);
                        break;
                    }
                    if (StringUtil.inSorted(name, Constants.InTemplateToTable)) {
                        tb.popTemplateMode();
                        tb.pushTemplateMode(InTable);
                        tb.transition(InTable);
                        return tb.process(t);
                    }
                    if (name.equals("col")) {
                        tb.popTemplateMode();
                        tb.pushTemplateMode(InColumnGroup);
                        tb.transition(InColumnGroup);
                        return tb.process(t);
                    }
                    if (name.equals("tr")) {
                        tb.popTemplateMode();
                        tb.pushTemplateMode(InTableBody);
                        tb.transition(InTableBody);
                        return tb.process(t);
                    }
                    if (name.equals("td") || var3_3.equals("th")) {
                        tb.popTemplateMode();
                        tb.pushTemplateMode(InRow);
                        tb.transition(InRow);
                        return tb.process(t);
                    }
                    tb.popTemplateMode();
                    tb.pushTemplateMode(InBody);
                    tb.transition(InBody);
                    return tb.process(t);
                }
                case EndTag: {
                    String string = t.asEndTag().normalName();
                    if (string.equals("template")) {
                        tb.process(t, InHead);
                        break;
                    }
                    tb.error(this);
                    return false;
                }
                case EOF: {
                    if (!tb.onStack("template")) {
                        return true;
                    }
                    tb.error(this);
                    tb.popStackToClose("template");
                    tb.clearFormattingElementsToLastMarker();
                    tb.popTemplateMode();
                    tb.resetInsertionMode();
                    if (tb.state() != InTemplate && tb.templateModeSize() < 12) {
                        void var1_1;
                        void var2_2;
                        return var2_2.process((Token)var1_1);
                    }
                    return true;
                }
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState AfterBody = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            Element html = tb.getFromStack("html");
            if (HtmlTreeBuilderState.isWhitespace(t)) {
                if (html != null) {
                    tb.insertCharacterToElement(t.asCharacter(), html);
                } else {
                    tb.process(t, InBody);
                }
            } else if (t.isComment()) {
                tb.insertCommentNode(t.asComment());
            } else {
                if (t.isDoctype()) {
                    tb.error(this);
                    return false;
                }
                if (t.isStartTag() && t.asStartTag().normalName().equals("html")) {
                    return tb.process(t, InBody);
                }
                if (t.isEndTag() && t.asEndTag().normalName().equals("html")) {
                    if (tb.isFragmentParsing()) {
                        tb.error(this);
                        return false;
                    }
                    if (html != null) {
                        void var3_3;
                        tb.onNodeClosed((Node)var3_3);
                    }
                    tb.transition(AfterAfterBody);
                } else if (!t.isEOF()) {
                    void var1_1;
                    void var2_2;
                    tb.error(this);
                    tb.resetBody();
                    return var2_2.process((Token)var1_1);
                }
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState InFrameset = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            block21: {
                void var1_1;
                block23: {
                    block22: {
                        block20: {
                            if (!HtmlTreeBuilderState.isWhitespace(t)) break block20;
                            tb.insertCharacterNode(t.asCharacter());
                            break block21;
                        }
                        if (!t.isComment()) break block22;
                        tb.insertCommentNode(t.asComment());
                        break block21;
                    }
                    if (t.isDoctype()) {
                        tb.error(this);
                        return false;
                    }
                    if (!t.isStartTag()) break block23;
                    Token.StartTag start = t.asStartTag();
                    switch (start.normalName()) {
                        case "html": {
                            return tb.process(start, InBody);
                        }
                        case "frameset": {
                            tb.insertElementFor(start);
                            break block21;
                        }
                        case "frame": {
                            tb.insertEmptyElementFor(start);
                            break block21;
                        }
                        case "noframes": {
                            return tb.process((Token)var1_1, InHead);
                        }
                        default: {
                            tb.error(this);
                            return false;
                        }
                    }
                }
                if (var1_1.isEndTag() && var1_1.asEndTag().normalName().equals("frameset")) {
                    if (tb.currentElementIs("html")) {
                        tb.error(this);
                        return false;
                    }
                    tb.pop();
                    if (!tb.isFragmentParsing() && !tb.currentElementIs("frameset")) {
                        tb.transition(AfterFrameset);
                    }
                } else if (var1_1.isEOF()) {
                    if (!tb.currentElementIs("html")) {
                        tb.error(this);
                        return true;
                    }
                } else {
                    void var2_2;
                    var2_2.error(this);
                    return false;
                }
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState AfterFrameset = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (HtmlTreeBuilderState.isWhitespace(t)) {
                tb.insertCharacterNode(t.asCharacter());
            } else if (t.isComment()) {
                tb.insertCommentNode(t.asComment());
            } else {
                if (t.isDoctype()) {
                    tb.error(this);
                    return false;
                }
                if (t.isStartTag() && t.asStartTag().normalName().equals("html")) {
                    return tb.process(t, InBody);
                }
                if (t.isEndTag() && t.asEndTag().normalName().equals("html")) {
                    tb.transition(AfterAfterFrameset);
                } else {
                    void var1_1;
                    if (t.isStartTag() && t.asStartTag().normalName().equals("noframes")) {
                        return tb.process(t, InHead);
                    }
                    if (!var1_1.isEOF()) {
                        void var2_2;
                        var2_2.error(this);
                        return false;
                    }
                }
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState AfterAfterBody = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (t.isComment()) {
                tb.insertCommentNode(t.asComment());
            } else {
                if (t.isDoctype() || t.isStartTag() && t.asStartTag().normalName().equals("html")) {
                    return tb.process(t, InBody);
                }
                if (HtmlTreeBuilderState.isWhitespace(t)) {
                    void var3_3;
                    Document doc = tb.getDocument();
                    tb.insertCharacterToElement(t.asCharacter(), (Element)var3_3);
                } else if (!t.isEOF()) {
                    void var1_1;
                    void var2_2;
                    tb.error(this);
                    tb.resetBody();
                    return var2_2.process((Token)var1_1);
                }
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState AfterAfterFrameset = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            if (t.isComment()) {
                tb.insertCommentNode(t.asComment());
            } else {
                if (t.isDoctype() || HtmlTreeBuilderState.isWhitespace(t) || t.isStartTag() && t.asStartTag().normalName().equals("html")) {
                    return tb.process(t, InBody);
                }
                if (!t.isEOF()) {
                    void var2_2;
                    if (t.isStartTag() && t.asStartTag().normalName().equals("noframes")) {
                        void var1_1;
                        return tb.process((Token)var1_1, InHead);
                    }
                    var2_2.error(this);
                    return false;
                }
            }
            return true;
        }
    };
    public static final /* enum */ HtmlTreeBuilderState ForeignContent = new HtmlTreeBuilderState(){

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean process(Token t, HtmlTreeBuilder tb) {
            switch (t.type) {
                case Character: {
                    void var1_1;
                    Token.Character c = t.asCharacter();
                    if (c.getData().equals(nullString)) {
                        tb.error(this);
                        break;
                    }
                    if (HtmlTreeBuilderState.isWhitespace(c)) {
                        tb.insertCharacterNode(c);
                        break;
                    }
                    tb.insertCharacterNode((Token.Character)var1_1);
                    tb.framesetOk(false);
                    break;
                }
                case Comment: {
                    void var1_1;
                    tb.insertCommentNode(var1_1.asComment());
                    break;
                }
                case Doctype: {
                    tb.error(this);
                    break;
                }
                case StartTag: {
                    void var1_1;
                    Token.StartTag start = var1_1.asStartTag();
                    if (StringUtil.in(start.normalName, Constants.InForeignToHtml)) {
                        return this.processAsHtml((Token)var1_1, tb);
                    }
                    if (start.normalName.equals("font") && (start.hasAttributeIgnoreCase("color") || start.hasAttributeIgnoreCase("face") || start.hasAttributeIgnoreCase("size"))) {
                        return this.processAsHtml((Token)var1_1, tb);
                    }
                    tb.insertForeignElementFor(start, tb.currentElement().tag().namespace());
                    break;
                }
                case EndTag: {
                    int i;
                    Element el;
                    void var1_1;
                    Token.EndTag end = var1_1.asEndTag();
                    if (end.normalName.equals("br") || end.normalName.equals("p")) {
                        return this.processAsHtml((Token)var1_1, tb);
                    }
                    if (end.normalName.equals("script") && tb.currentElementIs("script", "http://www.w3.org/2000/svg")) {
                        tb.pop();
                        return true;
                    }
                    ArrayList<Element> stack = tb.getStack();
                    if (stack.isEmpty()) {
                        Validate.wtf("Stack unexpectedly empty");
                    }
                    if (!(el = stack.get(i = stack.size() - 1)).nameIs(end.normalName)) {
                        tb.error(this);
                    }
                    while (i != 0) {
                        void var2_2;
                        if (el.nameIs(end.normalName)) {
                            tb.popStackToCloseAnyNamespace(el.normalName());
                            return true;
                        }
                        if (!(el = stack.get(--i)).tag().namespace().equals("http://www.w3.org/1999/xhtml")) continue;
                        return this.processAsHtml((Token)var1_1, (HtmlTreeBuilder)var2_2);
                    }
                    break;
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        final boolean processAsHtml(Token t, HtmlTreeBuilder tb) {
            void var2_2;
            void var1_1;
            return tb.state().process((Token)var1_1, (HtmlTreeBuilder)var2_2);
        }
    };
    private static final String nullString;
    private static final /* synthetic */ HtmlTreeBuilderState[] $VALUES;

    abstract boolean process(Token var1, HtmlTreeBuilder var2);

    private static boolean isWhitespace(Token t) {
        if (t.isCharacter()) {
            String string;
            string = ((Token)((Object)string)).asCharacter().getData();
            return StringUtil.isBlank(string);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static void handleRcData(Token.StartTag startTag, HtmlTreeBuilder tb) {
        Token.StartTag startTag2;
        void var1_1;
        tb.tokeniser.transition(TokeniserState.Rcdata);
        tb.markInsertionMode();
        tb.transition(Text);
        var1_1.insertElementFor(startTag2);
    }

    /*
     * WARNING - void declaration
     */
    private static void handleRawtext(Token.StartTag startTag, HtmlTreeBuilder tb) {
        Token.StartTag startTag2;
        void var1_1;
        tb.tokeniser.transition(TokeniserState.Rawtext);
        tb.markInsertionMode();
        tb.transition(Text);
        var1_1.insertElementFor(startTag2);
    }

    private static /* synthetic */ HtmlTreeBuilderState[] $values() {
        return new HtmlTreeBuilderState[]{Initial, BeforeHtml, BeforeHead, InHead, InHeadNoscript, AfterHead, InBody, Text, InTable, InTableText, InCaption, InColumnGroup, InTableBody, InRow, InCell, InSelect, InSelectInTable, InTemplate, AfterBody, InFrameset, AfterFrameset, AfterAfterBody, AfterAfterFrameset, ForeignContent};
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(Token.StartTag x0, HtmlTreeBuilder x1) {
        void var1_1;
        HtmlTreeBuilderState.handleRcData(x0, (HtmlTreeBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(Token.StartTag x0, HtmlTreeBuilder x1) {
        void var1_1;
        HtmlTreeBuilderState.handleRawtext(x0, (HtmlTreeBuilder)var1_1);
    }

    static {
        $VALUES = HtmlTreeBuilderState.$values();
        nullString = "\u0000";
    }

    static final class Constants {
        static final String[] InHeadEmpty = new String[]{"base", "basefont", "bgsound", "command", "link"};
        static final String[] InHeadRaw = new String[]{"noframes", "style"};
        static final String[] InHeadEnd = new String[]{"body", "br", "html"};
        static final String[] AfterHeadBody = new String[]{"body", "br", "html"};
        static final String[] BeforeHtmlToHead = new String[]{"body", "br", "head", "html"};
        static final String[] InHeadNoScriptHead = new String[]{"basefont", "bgsound", "link", "meta", "noframes", "style"};
        static final String[] InBodyStartToHead = new String[]{"base", "basefont", "bgsound", "command", "link", "meta", "noframes", "script", "style", "template", "title"};
        static final String[] InBodyStartPClosers = new String[]{"address", "article", "aside", "blockquote", "center", "details", "dir", "div", "dl", "fieldset", "figcaption", "figure", "footer", "header", "hgroup", "menu", "nav", "ol", "p", "section", "summary", "ul"};
        static final String[] Headings = new String[]{"h1", "h2", "h3", "h4", "h5", "h6"};
        static final String[] InBodyStartLiBreakers = new String[]{"address", "div", "p"};
        static final String[] DdDt = new String[]{"dd", "dt"};
        static final String[] InBodyStartApplets = new String[]{"applet", "marquee", "object"};
        static final String[] InBodyStartMedia = new String[]{"param", "source", "track"};
        static final String[] InBodyStartInputAttribs = new String[]{"action", "name", "prompt"};
        static final String[] InBodyStartDrop = new String[]{"caption", "col", "colgroup", "frame", "head", "tbody", "td", "tfoot", "th", "thead", "tr"};
        static final String[] InBodyEndClosers = new String[]{"address", "article", "aside", "blockquote", "button", "center", "details", "dir", "div", "dl", "fieldset", "figcaption", "figure", "footer", "header", "hgroup", "listing", "menu", "nav", "ol", "pre", "section", "summary", "ul"};
        static final String[] InBodyEndOtherErrors = new String[]{"body", "dd", "dt", "html", "li", "optgroup", "option", "p", "rb", "rp", "rt", "rtc", "tbody", "td", "tfoot", "th", "thead", "tr"};
        static final String[] InBodyEndAdoptionFormatters = new String[]{"a", "b", "big", "code", "em", "font", "i", "nobr", "s", "small", "strike", "strong", "tt", "u"};
        static final String[] InBodyEndTableFosters = new String[]{"table", "tbody", "tfoot", "thead", "tr"};
        static final String[] InTableToBody = new String[]{"tbody", "tfoot", "thead"};
        static final String[] InTableAddBody = new String[]{"td", "th", "tr"};
        static final String[] InTableToHead = new String[]{"script", "style", "template"};
        static final String[] InCellNames = new String[]{"td", "th"};
        static final String[] InCellBody = new String[]{"body", "caption", "col", "colgroup", "html"};
        static final String[] InCellTable = new String[]{"table", "tbody", "tfoot", "thead", "tr"};
        static final String[] InCellCol = new String[]{"caption", "col", "colgroup", "tbody", "td", "tfoot", "th", "thead", "tr"};
        static final String[] InTableEndErr = new String[]{"body", "caption", "col", "colgroup", "html", "tbody", "td", "tfoot", "th", "thead", "tr"};
        static final String[] InTableFoster = new String[]{"table", "tbody", "tfoot", "thead", "tr"};
        static final String[] InTableBodyExit = new String[]{"caption", "col", "colgroup", "tbody", "tfoot", "thead"};
        static final String[] InTableBodyEndIgnore = new String[]{"body", "caption", "col", "colgroup", "html", "td", "th", "tr"};
        static final String[] InRowMissing = new String[]{"caption", "col", "colgroup", "tbody", "tfoot", "thead", "tr"};
        static final String[] InRowIgnore = new String[]{"body", "caption", "col", "colgroup", "html", "td", "th"};
        static final String[] InSelectEnd = new String[]{"input", "keygen", "textarea"};
        static final String[] InSelectTableEnd = new String[]{"caption", "table", "tbody", "td", "tfoot", "th", "thead", "tr"};
        static final String[] InTableEndIgnore = new String[]{"tbody", "tfoot", "thead"};
        static final String[] InHeadNoscriptIgnore = new String[]{"head", "noscript"};
        static final String[] InCaptionIgnore = new String[]{"body", "col", "colgroup", "html", "tbody", "td", "tfoot", "th", "thead", "tr"};
        static final String[] InTemplateToHead = new String[]{"base", "basefont", "bgsound", "link", "meta", "noframes", "script", "style", "template", "title"};
        static final String[] InTemplateToTable = new String[]{"caption", "colgroup", "tbody", "tfoot", "thead"};
        static final String[] InForeignToHtml = new String[]{"b", "big", "blockquote", "body", "br", "center", "code", "dd", "div", "dl", "dt", "em", "embed", "h1", "h2", "h3", "h4", "h5", "h6", "head", "hr", "i", "img", "li", "listing", "menu", "meta", "nobr", "ol", "p", "pre", "ruby", "s", "small", "span", "strike", "strong", "sub", "sup", "table", "tt", "u", "ul", "var"};
    }
}

