/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.mvn;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.xml.stream.XMLStreamException;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.CliErrors;

@CommandDefinition(name="set-local-repository", description="Set the path to the local maven repository path")
public class MavenSetLocalRepository
extends PmSessionCommand {
    @Argument(description="Path to local maven repository", required=true)
    private File path;

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        Path p = this.path.toPath();
        try {
            if (!Files.exists(p, new LinkOption[0])) {
                throw new CommandExecutionException("Local repository directory " + p + " doesn't exist.");
            }
            session.getPmSession().getPmConfiguration().getMavenConfig().setLocalRepository(p);
        }
        catch (IOException | XMLStreamException ex) {
            throw new CommandExecutionException(session.getPmSession(), CliErrors.setLocalRepositoryFailed(), ex);
        }
    }
}

