/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JScrollBar;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.driver.HorizontalJScrollBarLocation;
import org.fest.swing.driver.JScrollBarLocationStrategy;
import org.fest.swing.driver.VerticalJScrollBarLocation;

public final class JScrollBarLocation {
    private static final int BLOCK_OFFSET = 4;
    private static final Map<Integer, JScrollBarLocationStrategy> LOCATIONS = new HashMap<Integer, JScrollBarLocationStrategy>();

    @RunsInCurrentThread
    public Point thumbLocation(JScrollBar scrollBar, int position) {
        double fraction = (double)position / (double)this.maximumMinusMinimum(scrollBar);
        return this.locationStrategyFor(scrollBar).thumbLocation(scrollBar, fraction);
    }

    @RunsInCurrentThread
    private int maximumMinusMinimum(JScrollBar scrollBar) {
        return scrollBar.getMaximum() - scrollBar.getMinimum();
    }

    @RunsInCurrentThread
    public Point blockLocationToScrollUp(JScrollBar scrollBar) {
        Point p = this.unitLocationToScrollUp(scrollBar);
        int offset = 4;
        return this.blockLocation(scrollBar, p, offset);
    }

    @RunsInCurrentThread
    public Point blockLocationToScrollDown(JScrollBar scrollBar) {
        Point p = this.unitLocationToScrollDown(scrollBar);
        int offset = -4;
        return this.blockLocation(scrollBar, p, offset);
    }

    @RunsInCurrentThread
    private Point blockLocation(JScrollBar scrollBar, Point unitLocation, int offset) {
        return this.locationStrategyFor(scrollBar).blockLocation(scrollBar, unitLocation, offset);
    }

    @RunsInCurrentThread
    public Point unitLocationToScrollUp(JScrollBar scrollBar) {
        int arrow = this.locationStrategyFor(scrollBar).arrow(scrollBar);
        return new Point(arrow / 2, arrow / 2);
    }

    @RunsInCurrentThread
    public Point unitLocationToScrollDown(JScrollBar scrollBar) {
        return this.locationStrategyFor(scrollBar).unitLocationToScrollDown(scrollBar);
    }

    @RunsInCurrentThread
    private JScrollBarLocationStrategy locationStrategyFor(JScrollBar scrollBar) {
        return LOCATIONS.get(scrollBar.getOrientation());
    }

    static {
        LOCATIONS.put(0, new HorizontalJScrollBarLocation());
        LOCATIONS.put(1, new VerticalJScrollBarLocation());
    }
}

