/*
 *----------------------------------------------------------------------
 *
 * PROGRAM  : gksmc
 *
 * FILE     : translate.c
 *
 * CONTENTS : Main iterative loop of translation process, item header
 *	      is read in and appropriate translation routine is called.
 *
 * GLOBALS USED : MF_infile, MF_outfile, GKSM_string, GKSM_bytes,
 *		  item_field_width, data_length_field_width,
 *
 * DATE     : 24th April 1988
 *
 *---------------------------------------------------------------------
 */
#include <stdio.h>
#include "annexe.h"
#include "defns.h"
#include "tables.h"

extern char GKSM_string[5];
extern int GKSM_bytes;
extern int item_field_width;
extern int data_length_field_width;

extern FILE *MF_infile,
       *MF_outfile;

int     item_no;

/*
 *-------------------------------------------------------------------------
 * create_cgm:
 *	Handles translation of main body of the Annex E metafile. GKSM
 * chars are read, item number and data size, then translate_item called
 * to select the correct translation procedure.
 *-------------------------------------------------------------------------
 */
create_cgm()
{
	int     record_length;

	do
	{
		read_GKSM_chars(MF_infile, GKSM_bytes);
		read_string_int(MF_infile, &item_no, item_field_width);
		read_string_int(MF_infile, &record_length, data_length_field_width);
		translate_item();
		write_separator(MF_outfile, TERMINATOR);
	} while (item_no != 0);
}


/*
 *-------------------------------------------------------------------------
 * read_GKSM_chars:
 *	Reads the expected number of characters at the start of each
 * metafile item and compares it with the string expected.
 *-------------------------------------------------------------------------
 */
read_GKSM_chars(infile, count)
	FILE   *infile;
	int     count;	/* How many chars of 'GKSM' expected : 0 - 4 */
{
	char    str[5];

	read_string(infile, str, count);
	if (strcmp(GKSM_string, str))
		write_error(20);
}


/*
 *-------------------------------------------------------------------------
 * translate_item:
 *	Takes the Annex E metafile item number and calls the corresponding
 * routine to read in the paramters and write the CGM equivalent.
 *-------------------------------------------------------------------------
 */
translate_item()
{
	switch (item_no)
	{
		case END_ITEM:
			AEend_item();
			break;
		case CLEAR_WKS:
			AEclear_wks();
			break;
		case REDRAW_SEGS:
			AEredraw_segs();
			break;
		case UPDATE_WKS:
			AEset_enum_param(E_UPDATE);
			break;
		case DEF_STATE:
			AEdef_state();
			break;
		case MESSAGE:
			AEmessage();
			break;
		case ESCAPE:
			AEescape();
			break;
		case POLYLINE:
		case POLYMARKER:
		case FILL_AREA:
			AEpolypoint();
			break;
		case TEXT:
			AEtext();
			break;
		case CELL_ARRAY:
			AEcell_array();
			break;
		case GDP:
			AEgdp();
			break;
		case LINE_INDEX:
		case MARKER_INDEX:
		case FILL_INDEX:
		case TEXT_INDEX:
			AEset_int_param(POSITIVE);
			break;
		case LINE_COLOUR:
		case MARKER_COLOUR:
		case FILL_COLOUR:
		case TEXT_COLOUR:
			AEset_int_param(NON_NEGATIVE);
			break;
		case LINE_TYPE:
		case MARKER_TYPE:
		case PICK_ID:
		case CREATE_SEG:
		case DELETE_SEG:
			AEset_int_param(ANY);
			break;
		case FILL_STYLE_IND:
			AEfill_style_ind();
			break;
		case LINE_WIDTH:
		case MARKER_SIZE:
			AEset_real_param(NON_NEGATIVE);
			break;
		case CHAR_EXP:
		case CHAR_SPACING:
			AEset_real_param(ANY);
			break;
		case TEXT_FONT_PREC:
			AEtext_font_prec();
			break;
		case CHAR_VECTORS:
			AEchar_vectors();
			break;
		case TEXT_PATH:
			AEset_enum_param(E_TEXTPATH);
			break;
		case TEXT_ALIGN:
			AEtext_align();
			break;
		case FILL_INT_STYLE:
			AEset_enum_param(E_INTERIOR);
			break;
		case PATT_VECTORS:
			AEpatt_vectors();
			break;
		case PATT_REF_POINT:
			AEpatt_ref_point();
			break;
		case ASF:
			AEasf();
			break;
		case POLYLINE_REP:
			AEpolyline_rep();
			break;
		case MARKER_REP:
			AEmarker_rep();
			break;
		case TEXT_REP:
			AEtext_rep();
			break;
		case FILL_AREA_REP:
			AEfill_area_rep();
			break;
		case PATT_REP:
			AEpatt_rep();
			break;
		case COLOUR_REP:
			AEcolour_rep();
			break;
		case CLIP_RECT:
			AEclip_rect();
			break;
		case WKS_WINDOW:
			AEwks_window();
			break;
		case WKS_VIEWPORT:
			AEwks_viewport();
			break;
		case CLOSE_SEG:
			AEclose_seg();
			break;
		case RENAME_SEG:
			AErename_seg();
			break;
		case SET_SEG_TRANS:
			AEset_seg_trans();
			break;
		case SET_VISIBILITY:
			AEset_seg_attribute(E_SEGVIS);
			break;
		case SET_HIGHLIGHT:
			AEset_seg_attribute(E_SEGHL);
			break;
		case SET_SEG_PRI:
			AEset_seg_pri();
			break;
		case SET_DETECT:
			AEset_seg_attribute(E_SEGDET);
			break;
		default:
			write_error(21);
	}
}
