// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_ASSEMBLER_COND_RD_RN_REV16_A32_H_
#define VIXL_ASSEMBLER_COND_RD_RN_REV16_A32_H_

const byte kInstruction_rev16_cs_r12_r1[] = {
  0xb1, 0xcf, 0xbf, 0x26 // rev16 cs r12 r1
};
const byte kInstruction_rev16_hi_r6_r12[] = {
  0xbc, 0x6f, 0xbf, 0x86 // rev16 hi r6 r12
};
const byte kInstruction_rev16_lt_r11_r10[] = {
  0xba, 0xbf, 0xbf, 0xb6 // rev16 lt r11 r10
};
const byte kInstruction_rev16_vs_r10_r8[] = {
  0xb8, 0xaf, 0xbf, 0x66 // rev16 vs r10 r8
};
const byte kInstruction_rev16_pl_r5_r8[] = {
  0xb8, 0x5f, 0xbf, 0x56 // rev16 pl r5 r8
};
const byte kInstruction_rev16_ls_r14_r14[] = {
  0xbe, 0xef, 0xbf, 0x96 // rev16 ls r14 r14
};
const byte kInstruction_rev16_gt_r8_r6[] = {
  0xb6, 0x8f, 0xbf, 0xc6 // rev16 gt r8 r6
};
const byte kInstruction_rev16_vc_r7_r11[] = {
  0xbb, 0x7f, 0xbf, 0x76 // rev16 vc r7 r11
};
const byte kInstruction_rev16_pl_r4_r12[] = {
  0xbc, 0x4f, 0xbf, 0x56 // rev16 pl r4 r12
};
const byte kInstruction_rev16_gt_r12_r12[] = {
  0xbc, 0xcf, 0xbf, 0xc6 // rev16 gt r12 r12
};
const byte kInstruction_rev16_ne_r8_r4[] = {
  0xb4, 0x8f, 0xbf, 0x16 // rev16 ne r8 r4
};
const byte kInstruction_rev16_le_r1_r11[] = {
  0xbb, 0x1f, 0xbf, 0xd6 // rev16 le r1 r11
};
const byte kInstruction_rev16_cc_r4_r10[] = {
  0xba, 0x4f, 0xbf, 0x36 // rev16 cc r4 r10
};
const byte kInstruction_rev16_gt_r14_r0[] = {
  0xb0, 0xef, 0xbf, 0xc6 // rev16 gt r14 r0
};
const byte kInstruction_rev16_cs_r2_r11[] = {
  0xbb, 0x2f, 0xbf, 0x26 // rev16 cs r2 r11
};
const byte kInstruction_rev16_al_r3_r12[] = {
  0xbc, 0x3f, 0xbf, 0xe6 // rev16 al r3 r12
};
const byte kInstruction_rev16_hi_r6_r0[] = {
  0xb0, 0x6f, 0xbf, 0x86 // rev16 hi r6 r0
};
const byte kInstruction_rev16_ls_r10_r10[] = {
  0xba, 0xaf, 0xbf, 0x96 // rev16 ls r10 r10
};
const byte kInstruction_rev16_ls_r4_r8[] = {
  0xb8, 0x4f, 0xbf, 0x96 // rev16 ls r4 r8
};
const byte kInstruction_rev16_le_r8_r0[] = {
  0xb0, 0x8f, 0xbf, 0xd6 // rev16 le r8 r0
};
const byte kInstruction_rev16_pl_r5_r3[] = {
  0xb3, 0x5f, 0xbf, 0x56 // rev16 pl r5 r3
};
const byte kInstruction_rev16_ls_r8_r5[] = {
  0xb5, 0x8f, 0xbf, 0x96 // rev16 ls r8 r5
};
const byte kInstruction_rev16_ge_r0_r10[] = {
  0xba, 0x0f, 0xbf, 0xa6 // rev16 ge r0 r10
};
const byte kInstruction_rev16_lt_r10_r6[] = {
  0xb6, 0xaf, 0xbf, 0xb6 // rev16 lt r10 r6
};
const byte kInstruction_rev16_ne_r9_r9[] = {
  0xb9, 0x9f, 0xbf, 0x16 // rev16 ne r9 r9
};
const byte kInstruction_rev16_hi_r5_r0[] = {
  0xb0, 0x5f, 0xbf, 0x86 // rev16 hi r5 r0
};
const byte kInstruction_rev16_pl_r10_r6[] = {
  0xb6, 0xaf, 0xbf, 0x56 // rev16 pl r10 r6
};
const byte kInstruction_rev16_vs_r1_r3[] = {
  0xb3, 0x1f, 0xbf, 0x66 // rev16 vs r1 r3
};
const byte kInstruction_rev16_vs_r9_r8[] = {
  0xb8, 0x9f, 0xbf, 0x66 // rev16 vs r9 r8
};
const byte kInstruction_rev16_cc_r2_r10[] = {
  0xba, 0x2f, 0xbf, 0x36 // rev16 cc r2 r10
};
const byte kInstruction_rev16_cs_r11_r3[] = {
  0xb3, 0xbf, 0xbf, 0x26 // rev16 cs r11 r3
};
const byte kInstruction_rev16_hi_r8_r2[] = {
  0xb2, 0x8f, 0xbf, 0x86 // rev16 hi r8 r2
};
const byte kInstruction_rev16_pl_r6_r0[] = {
  0xb0, 0x6f, 0xbf, 0x56 // rev16 pl r6 r0
};
const byte kInstruction_rev16_hi_r9_r2[] = {
  0xb2, 0x9f, 0xbf, 0x86 // rev16 hi r9 r2
};
const byte kInstruction_rev16_al_r14_r11[] = {
  0xbb, 0xef, 0xbf, 0xe6 // rev16 al r14 r11
};
const byte kInstruction_rev16_eq_r8_r13[] = {
  0xbd, 0x8f, 0xbf, 0x06 // rev16 eq r8 r13
};
const byte kInstruction_rev16_ge_r12_r2[] = {
  0xb2, 0xcf, 0xbf, 0xa6 // rev16 ge r12 r2
};
const byte kInstruction_rev16_cc_r2_r6[] = {
  0xb6, 0x2f, 0xbf, 0x36 // rev16 cc r2 r6
};
const byte kInstruction_rev16_ne_r13_r9[] = {
  0xb9, 0xdf, 0xbf, 0x16 // rev16 ne r13 r9
};
const byte kInstruction_rev16_ne_r13_r10[] = {
  0xba, 0xdf, 0xbf, 0x16 // rev16 ne r13 r10
};
const byte kInstruction_rev16_mi_r10_r9[] = {
  0xb9, 0xaf, 0xbf, 0x46 // rev16 mi r10 r9
};
const byte kInstruction_rev16_lt_r13_r12[] = {
  0xbc, 0xdf, 0xbf, 0xb6 // rev16 lt r13 r12
};
const byte kInstruction_rev16_lt_r14_r3[] = {
  0xb3, 0xef, 0xbf, 0xb6 // rev16 lt r14 r3
};
const byte kInstruction_rev16_mi_r12_r14[] = {
  0xbe, 0xcf, 0xbf, 0x46 // rev16 mi r12 r14
};
const byte kInstruction_rev16_vs_r11_r2[] = {
  0xb2, 0xbf, 0xbf, 0x66 // rev16 vs r11 r2
};
const byte kInstruction_rev16_ls_r11_r0[] = {
  0xb0, 0xbf, 0xbf, 0x96 // rev16 ls r11 r0
};
const byte kInstruction_rev16_gt_r10_r9[] = {
  0xb9, 0xaf, 0xbf, 0xc6 // rev16 gt r10 r9
};
const byte kInstruction_rev16_le_r10_r12[] = {
  0xbc, 0xaf, 0xbf, 0xd6 // rev16 le r10 r12
};
const byte kInstruction_rev16_ge_r0_r14[] = {
  0xbe, 0x0f, 0xbf, 0xa6 // rev16 ge r0 r14
};
const byte kInstruction_rev16_mi_r5_r8[] = {
  0xb8, 0x5f, 0xbf, 0x46 // rev16 mi r5 r8
};
const byte kInstruction_rev16_vs_r4_r11[] = {
  0xbb, 0x4f, 0xbf, 0x66 // rev16 vs r4 r11
};
const byte kInstruction_rev16_lt_r7_r12[] = {
  0xbc, 0x7f, 0xbf, 0xb6 // rev16 lt r7 r12
};
const byte kInstruction_rev16_gt_r2_r8[] = {
  0xb8, 0x2f, 0xbf, 0xc6 // rev16 gt r2 r8
};
const byte kInstruction_rev16_gt_r5_r7[] = {
  0xb7, 0x5f, 0xbf, 0xc6 // rev16 gt r5 r7
};
const byte kInstruction_rev16_pl_r6_r3[] = {
  0xb3, 0x6f, 0xbf, 0x56 // rev16 pl r6 r3
};
const byte kInstruction_rev16_ne_r2_r12[] = {
  0xbc, 0x2f, 0xbf, 0x16 // rev16 ne r2 r12
};
const byte kInstruction_rev16_hi_r11_r11[] = {
  0xbb, 0xbf, 0xbf, 0x86 // rev16 hi r11 r11
};
const byte kInstruction_rev16_vs_r4_r14[] = {
  0xbe, 0x4f, 0xbf, 0x66 // rev16 vs r4 r14
};
const byte kInstruction_rev16_vs_r13_r1[] = {
  0xb1, 0xdf, 0xbf, 0x66 // rev16 vs r13 r1
};
const byte kInstruction_rev16_cs_r4_r3[] = {
  0xb3, 0x4f, 0xbf, 0x26 // rev16 cs r4 r3
};
const byte kInstruction_rev16_eq_r13_r6[] = {
  0xb6, 0xdf, 0xbf, 0x06 // rev16 eq r13 r6
};
const byte kInstruction_rev16_gt_r11_r14[] = {
  0xbe, 0xbf, 0xbf, 0xc6 // rev16 gt r11 r14
};
const byte kInstruction_rev16_vc_r14_r4[] = {
  0xb4, 0xef, 0xbf, 0x76 // rev16 vc r14 r4
};
const byte kInstruction_rev16_vc_r1_r10[] = {
  0xba, 0x1f, 0xbf, 0x76 // rev16 vc r1 r10
};
const byte kInstruction_rev16_mi_r10_r3[] = {
  0xb3, 0xaf, 0xbf, 0x46 // rev16 mi r10 r3
};
const byte kInstruction_rev16_vs_r9_r3[] = {
  0xb3, 0x9f, 0xbf, 0x66 // rev16 vs r9 r3
};
const byte kInstruction_rev16_vc_r14_r5[] = {
  0xb5, 0xef, 0xbf, 0x76 // rev16 vc r14 r5
};
const byte kInstruction_rev16_ne_r9_r1[] = {
  0xb1, 0x9f, 0xbf, 0x16 // rev16 ne r9 r1
};
const byte kInstruction_rev16_al_r9_r6[] = {
  0xb6, 0x9f, 0xbf, 0xe6 // rev16 al r9 r6
};
const byte kInstruction_rev16_vc_r7_r8[] = {
  0xb8, 0x7f, 0xbf, 0x76 // rev16 vc r7 r8
};
const byte kInstruction_rev16_ls_r6_r9[] = {
  0xb9, 0x6f, 0xbf, 0x96 // rev16 ls r6 r9
};
const byte kInstruction_rev16_le_r14_r2[] = {
  0xb2, 0xef, 0xbf, 0xd6 // rev16 le r14 r2
};
const byte kInstruction_rev16_ls_r9_r13[] = {
  0xbd, 0x9f, 0xbf, 0x96 // rev16 ls r9 r13
};
const byte kInstruction_rev16_eq_r1_r5[] = {
  0xb5, 0x1f, 0xbf, 0x06 // rev16 eq r1 r5
};
const byte kInstruction_rev16_le_r9_r2[] = {
  0xb2, 0x9f, 0xbf, 0xd6 // rev16 le r9 r2
};
const byte kInstruction_rev16_eq_r2_r1[] = {
  0xb1, 0x2f, 0xbf, 0x06 // rev16 eq r2 r1
};
const byte kInstruction_rev16_ls_r9_r11[] = {
  0xbb, 0x9f, 0xbf, 0x96 // rev16 ls r9 r11
};
const byte kInstruction_rev16_lt_r7_r13[] = {
  0xbd, 0x7f, 0xbf, 0xb6 // rev16 lt r7 r13
};
const byte kInstruction_rev16_cc_r8_r7[] = {
  0xb7, 0x8f, 0xbf, 0x36 // rev16 cc r8 r7
};
const byte kInstruction_rev16_ls_r5_r1[] = {
  0xb1, 0x5f, 0xbf, 0x96 // rev16 ls r5 r1
};
const byte kInstruction_rev16_le_r1_r9[] = {
  0xb9, 0x1f, 0xbf, 0xd6 // rev16 le r1 r9
};
const byte kInstruction_rev16_ls_r8_r14[] = {
  0xbe, 0x8f, 0xbf, 0x96 // rev16 ls r8 r14
};
const byte kInstruction_rev16_le_r9_r1[] = {
  0xb1, 0x9f, 0xbf, 0xd6 // rev16 le r9 r1
};
const byte kInstruction_rev16_gt_r1_r6[] = {
  0xb6, 0x1f, 0xbf, 0xc6 // rev16 gt r1 r6
};
const byte kInstruction_rev16_gt_r11_r10[] = {
  0xba, 0xbf, 0xbf, 0xc6 // rev16 gt r11 r10
};
const byte kInstruction_rev16_hi_r0_r12[] = {
  0xbc, 0x0f, 0xbf, 0x86 // rev16 hi r0 r12
};
const byte kInstruction_rev16_gt_r1_r7[] = {
  0xb7, 0x1f, 0xbf, 0xc6 // rev16 gt r1 r7
};
const byte kInstruction_rev16_mi_r7_r1[] = {
  0xb1, 0x7f, 0xbf, 0x46 // rev16 mi r7 r1
};
const byte kInstruction_rev16_mi_r7_r0[] = {
  0xb0, 0x7f, 0xbf, 0x46 // rev16 mi r7 r0
};
const byte kInstruction_rev16_ls_r1_r3[] = {
  0xb3, 0x1f, 0xbf, 0x96 // rev16 ls r1 r3
};
const byte kInstruction_rev16_mi_r13_r3[] = {
  0xb3, 0xdf, 0xbf, 0x46 // rev16 mi r13 r3
};
const byte kInstruction_rev16_eq_r4_r3[] = {
  0xb3, 0x4f, 0xbf, 0x06 // rev16 eq r4 r3
};
const byte kInstruction_rev16_vc_r14_r9[] = {
  0xb9, 0xef, 0xbf, 0x76 // rev16 vc r14 r9
};
const byte kInstruction_rev16_pl_r3_r1[] = {
  0xb1, 0x3f, 0xbf, 0x56 // rev16 pl r3 r1
};
const byte kInstruction_rev16_mi_r0_r2[] = {
  0xb2, 0x0f, 0xbf, 0x46 // rev16 mi r0 r2
};
const byte kInstruction_rev16_hi_r2_r7[] = {
  0xb7, 0x2f, 0xbf, 0x86 // rev16 hi r2 r7
};
const byte kInstruction_rev16_hi_r13_r12[] = {
  0xbc, 0xdf, 0xbf, 0x86 // rev16 hi r13 r12
};
const byte kInstruction_rev16_ls_r12_r8[] = {
  0xb8, 0xcf, 0xbf, 0x96 // rev16 ls r12 r8
};
const byte kInstruction_rev16_ne_r5_r6[] = {
  0xb6, 0x5f, 0xbf, 0x16 // rev16 ne r5 r6
};
const byte kInstruction_rev16_pl_r5_r4[] = {
  0xb4, 0x5f, 0xbf, 0x56 // rev16 pl r5 r4
};
const byte kInstruction_rev16_ge_r1_r6[] = {
  0xb6, 0x1f, 0xbf, 0xa6 // rev16 ge r1 r6
};
const byte kInstruction_rev16_eq_r8_r10[] = {
  0xba, 0x8f, 0xbf, 0x06 // rev16 eq r8 r10
};
const byte kInstruction_rev16_cs_r5_r4[] = {
  0xb4, 0x5f, 0xbf, 0x26 // rev16 cs r5 r4
};
const byte kInstruction_rev16_eq_r11_r6[] = {
  0xb6, 0xbf, 0xbf, 0x06 // rev16 eq r11 r6
};
const byte kInstruction_rev16_cs_r13_r3[] = {
  0xb3, 0xdf, 0xbf, 0x26 // rev16 cs r13 r3
};
const byte kInstruction_rev16_pl_r2_r8[] = {
  0xb8, 0x2f, 0xbf, 0x56 // rev16 pl r2 r8
};
const byte kInstruction_rev16_gt_r10_r0[] = {
  0xb0, 0xaf, 0xbf, 0xc6 // rev16 gt r10 r0
};
const byte kInstruction_rev16_lt_r4_r10[] = {
  0xba, 0x4f, 0xbf, 0xb6 // rev16 lt r4 r10
};
const byte kInstruction_rev16_vs_r14_r14[] = {
  0xbe, 0xef, 0xbf, 0x66 // rev16 vs r14 r14
};
const byte kInstruction_rev16_hi_r0_r7[] = {
  0xb7, 0x0f, 0xbf, 0x86 // rev16 hi r0 r7
};
const byte kInstruction_rev16_cc_r9_r6[] = {
  0xb6, 0x9f, 0xbf, 0x36 // rev16 cc r9 r6
};
const byte kInstruction_rev16_ne_r7_r13[] = {
  0xbd, 0x7f, 0xbf, 0x16 // rev16 ne r7 r13
};
const byte kInstruction_rev16_eq_r2_r6[] = {
  0xb6, 0x2f, 0xbf, 0x06 // rev16 eq r2 r6
};
const byte kInstruction_rev16_cs_r12_r12[] = {
  0xbc, 0xcf, 0xbf, 0x26 // rev16 cs r12 r12
};
const byte kInstruction_rev16_mi_r3_r10[] = {
  0xba, 0x3f, 0xbf, 0x46 // rev16 mi r3 r10
};
const byte kInstruction_rev16_le_r6_r13[] = {
  0xbd, 0x6f, 0xbf, 0xd6 // rev16 le r6 r13
};
const byte kInstruction_rev16_al_r2_r1[] = {
  0xb1, 0x2f, 0xbf, 0xe6 // rev16 al r2 r1
};
const byte kInstruction_rev16_le_r3_r4[] = {
  0xb4, 0x3f, 0xbf, 0xd6 // rev16 le r3 r4
};
const byte kInstruction_rev16_pl_r4_r4[] = {
  0xb4, 0x4f, 0xbf, 0x56 // rev16 pl r4 r4
};
const byte kInstruction_rev16_lt_r12_r3[] = {
  0xb3, 0xcf, 0xbf, 0xb6 // rev16 lt r12 r3
};
const byte kInstruction_rev16_ls_r7_r4[] = {
  0xb4, 0x7f, 0xbf, 0x96 // rev16 ls r7 r4
};
const byte kInstruction_rev16_le_r9_r4[] = {
  0xb4, 0x9f, 0xbf, 0xd6 // rev16 le r9 r4
};
const byte kInstruction_rev16_vc_r13_r3[] = {
  0xb3, 0xdf, 0xbf, 0x76 // rev16 vc r13 r3
};
const byte kInstruction_rev16_vc_r8_r8[] = {
  0xb8, 0x8f, 0xbf, 0x76 // rev16 vc r8 r8
};
const byte kInstruction_rev16_ge_r2_r8[] = {
  0xb8, 0x2f, 0xbf, 0xa6 // rev16 ge r2 r8
};
const byte kInstruction_rev16_le_r11_r13[] = {
  0xbd, 0xbf, 0xbf, 0xd6 // rev16 le r11 r13
};
const byte kInstruction_rev16_le_r1_r5[] = {
  0xb5, 0x1f, 0xbf, 0xd6 // rev16 le r1 r5
};
const byte kInstruction_rev16_ge_r9_r12[] = {
  0xbc, 0x9f, 0xbf, 0xa6 // rev16 ge r9 r12
};
const byte kInstruction_rev16_cs_r14_r14[] = {
  0xbe, 0xef, 0xbf, 0x26 // rev16 cs r14 r14
};
const byte kInstruction_rev16_cc_r1_r0[] = {
  0xb0, 0x1f, 0xbf, 0x36 // rev16 cc r1 r0
};
const byte kInstruction_rev16_ge_r3_r0[] = {
  0xb0, 0x3f, 0xbf, 0xa6 // rev16 ge r3 r0
};
const byte kInstruction_rev16_al_r10_r0[] = {
  0xb0, 0xaf, 0xbf, 0xe6 // rev16 al r10 r0
};
const byte kInstruction_rev16_cc_r11_r10[] = {
  0xba, 0xbf, 0xbf, 0x36 // rev16 cc r11 r10
};
const byte kInstruction_rev16_mi_r11_r11[] = {
  0xbb, 0xbf, 0xbf, 0x46 // rev16 mi r11 r11
};
const byte kInstruction_rev16_ne_r12_r7[] = {
  0xb7, 0xcf, 0xbf, 0x16 // rev16 ne r12 r7
};
const byte kInstruction_rev16_lt_r4_r12[] = {
  0xbc, 0x4f, 0xbf, 0xb6 // rev16 lt r4 r12
};
const byte kInstruction_rev16_gt_r14_r5[] = {
  0xb5, 0xef, 0xbf, 0xc6 // rev16 gt r14 r5
};
const byte kInstruction_rev16_ge_r1_r7[] = {
  0xb7, 0x1f, 0xbf, 0xa6 // rev16 ge r1 r7
};
const byte kInstruction_rev16_al_r7_r0[] = {
  0xb0, 0x7f, 0xbf, 0xe6 // rev16 al r7 r0
};
const byte kInstruction_rev16_ls_r2_r0[] = {
  0xb0, 0x2f, 0xbf, 0x96 // rev16 ls r2 r0
};
const byte kInstruction_rev16_pl_r6_r11[] = {
  0xbb, 0x6f, 0xbf, 0x56 // rev16 pl r6 r11
};
const byte kInstruction_rev16_vc_r0_r6[] = {
  0xb6, 0x0f, 0xbf, 0x76 // rev16 vc r0 r6
};
const byte kInstruction_rev16_pl_r6_r9[] = {
  0xb9, 0x6f, 0xbf, 0x56 // rev16 pl r6 r9
};
const byte kInstruction_rev16_vs_r8_r1[] = {
  0xb1, 0x8f, 0xbf, 0x66 // rev16 vs r8 r1
};
const byte kInstruction_rev16_cs_r1_r6[] = {
  0xb6, 0x1f, 0xbf, 0x26 // rev16 cs r1 r6
};
const byte kInstruction_rev16_hi_r4_r11[] = {
  0xbb, 0x4f, 0xbf, 0x86 // rev16 hi r4 r11
};
const byte kInstruction_rev16_gt_r5_r5[] = {
  0xb5, 0x5f, 0xbf, 0xc6 // rev16 gt r5 r5
};
const byte kInstruction_rev16_al_r3_r4[] = {
  0xb4, 0x3f, 0xbf, 0xe6 // rev16 al r3 r4
};
const byte kInstruction_rev16_ge_r11_r12[] = {
  0xbc, 0xbf, 0xbf, 0xa6 // rev16 ge r11 r12
};
const byte kInstruction_rev16_cc_r14_r2[] = {
  0xb2, 0xef, 0xbf, 0x36 // rev16 cc r14 r2
};
const byte kInstruction_rev16_ge_r2_r4[] = {
  0xb4, 0x2f, 0xbf, 0xa6 // rev16 ge r2 r4
};
const byte kInstruction_rev16_lt_r5_r11[] = {
  0xbb, 0x5f, 0xbf, 0xb6 // rev16 lt r5 r11
};
const byte kInstruction_rev16_mi_r11_r14[] = {
  0xbe, 0xbf, 0xbf, 0x46 // rev16 mi r11 r14
};
const byte kInstruction_rev16_ne_r3_r3[] = {
  0xb3, 0x3f, 0xbf, 0x16 // rev16 ne r3 r3
};
const byte kInstruction_rev16_pl_r14_r0[] = {
  0xb0, 0xef, 0xbf, 0x56 // rev16 pl r14 r0
};
const byte kInstruction_rev16_vc_r4_r10[] = {
  0xba, 0x4f, 0xbf, 0x76 // rev16 vc r4 r10
};
const byte kInstruction_rev16_vs_r6_r8[] = {
  0xb8, 0x6f, 0xbf, 0x66 // rev16 vs r6 r8
};
const byte kInstruction_rev16_vc_r4_r7[] = {
  0xb7, 0x4f, 0xbf, 0x76 // rev16 vc r4 r7
};
const byte kInstruction_rev16_cs_r11_r10[] = {
  0xba, 0xbf, 0xbf, 0x26 // rev16 cs r11 r10
};
const byte kInstruction_rev16_eq_r11_r8[] = {
  0xb8, 0xbf, 0xbf, 0x06 // rev16 eq r11 r8
};
const byte kInstruction_rev16_ne_r9_r2[] = {
  0xb2, 0x9f, 0xbf, 0x16 // rev16 ne r9 r2
};
const byte kInstruction_rev16_hi_r9_r7[] = {
  0xb7, 0x9f, 0xbf, 0x86 // rev16 hi r9 r7
};
const byte kInstruction_rev16_lt_r0_r6[] = {
  0xb6, 0x0f, 0xbf, 0xb6 // rev16 lt r0 r6
};
const byte kInstruction_rev16_vc_r5_r8[] = {
  0xb8, 0x5f, 0xbf, 0x76 // rev16 vc r5 r8
};
const byte kInstruction_rev16_gt_r3_r1[] = {
  0xb1, 0x3f, 0xbf, 0xc6 // rev16 gt r3 r1
};
const byte kInstruction_rev16_pl_r3_r5[] = {
  0xb5, 0x3f, 0xbf, 0x56 // rev16 pl r3 r5
};
const byte kInstruction_rev16_al_r11_r5[] = {
  0xb5, 0xbf, 0xbf, 0xe6 // rev16 al r11 r5
};
const byte kInstruction_rev16_hi_r8_r14[] = {
  0xbe, 0x8f, 0xbf, 0x86 // rev16 hi r8 r14
};
const byte kInstruction_rev16_le_r5_r4[] = {
  0xb4, 0x5f, 0xbf, 0xd6 // rev16 le r5 r4
};
const byte kInstruction_rev16_ge_r13_r3[] = {
  0xb3, 0xdf, 0xbf, 0xa6 // rev16 ge r13 r3
};
const byte kInstruction_rev16_pl_r7_r14[] = {
  0xbe, 0x7f, 0xbf, 0x56 // rev16 pl r7 r14
};
const byte kInstruction_rev16_cs_r6_r9[] = {
  0xb9, 0x6f, 0xbf, 0x26 // rev16 cs r6 r9
};
const byte kInstruction_rev16_lt_r8_r12[] = {
  0xbc, 0x8f, 0xbf, 0xb6 // rev16 lt r8 r12
};
const byte kInstruction_rev16_cc_r12_r0[] = {
  0xb0, 0xcf, 0xbf, 0x36 // rev16 cc r12 r0
};
const byte kInstruction_rev16_mi_r14_r13[] = {
  0xbd, 0xef, 0xbf, 0x46 // rev16 mi r14 r13
};
const byte kInstruction_rev16_pl_r12_r13[] = {
  0xbd, 0xcf, 0xbf, 0x56 // rev16 pl r12 r13
};
const byte kInstruction_rev16_al_r4_r8[] = {
  0xb8, 0x4f, 0xbf, 0xe6 // rev16 al r4 r8
};
const byte kInstruction_rev16_ls_r5_r11[] = {
  0xbb, 0x5f, 0xbf, 0x96 // rev16 ls r5 r11
};
const byte kInstruction_rev16_ge_r11_r3[] = {
  0xb3, 0xbf, 0xbf, 0xa6 // rev16 ge r11 r3
};
const byte kInstruction_rev16_le_r1_r0[] = {
  0xb0, 0x1f, 0xbf, 0xd6 // rev16 le r1 r0
};
const byte kInstruction_rev16_gt_r14_r4[] = {
  0xb4, 0xef, 0xbf, 0xc6 // rev16 gt r14 r4
};
const byte kInstruction_rev16_ne_r3_r14[] = {
  0xbe, 0x3f, 0xbf, 0x16 // rev16 ne r3 r14
};
const byte kInstruction_rev16_cc_r3_r8[] = {
  0xb8, 0x3f, 0xbf, 0x36 // rev16 cc r3 r8
};
const byte kInstruction_rev16_eq_r7_r10[] = {
  0xba, 0x7f, 0xbf, 0x06 // rev16 eq r7 r10
};
const byte kInstruction_rev16_pl_r0_r10[] = {
  0xba, 0x0f, 0xbf, 0x56 // rev16 pl r0 r10
};
const byte kInstruction_rev16_mi_r6_r13[] = {
  0xbd, 0x6f, 0xbf, 0x46 // rev16 mi r6 r13
};
const byte kInstruction_rev16_gt_r10_r5[] = {
  0xb5, 0xaf, 0xbf, 0xc6 // rev16 gt r10 r5
};
const byte kInstruction_rev16_ne_r0_r1[] = {
  0xb1, 0x0f, 0xbf, 0x16 // rev16 ne r0 r1
};
const byte kInstruction_rev16_ge_r4_r8[] = {
  0xb8, 0x4f, 0xbf, 0xa6 // rev16 ge r4 r8
};
const byte kInstruction_rev16_cs_r3_r7[] = {
  0xb7, 0x3f, 0xbf, 0x26 // rev16 cs r3 r7
};
const byte kInstruction_rev16_pl_r2_r12[] = {
  0xbc, 0x2f, 0xbf, 0x56 // rev16 pl r2 r12
};
const byte kInstruction_rev16_ls_r9_r12[] = {
  0xbc, 0x9f, 0xbf, 0x96 // rev16 ls r9 r12
};
const byte kInstruction_rev16_ge_r4_r9[] = {
  0xb9, 0x4f, 0xbf, 0xa6 // rev16 ge r4 r9
};
const byte kInstruction_rev16_lt_r7_r2[] = {
  0xb2, 0x7f, 0xbf, 0xb6 // rev16 lt r7 r2
};
const byte kInstruction_rev16_hi_r10_r10[] = {
  0xba, 0xaf, 0xbf, 0x86 // rev16 hi r10 r10
};
const byte kInstruction_rev16_ls_r1_r7[] = {
  0xb7, 0x1f, 0xbf, 0x96 // rev16 ls r1 r7
};
const byte kInstruction_rev16_vs_r1_r12[] = {
  0xbc, 0x1f, 0xbf, 0x66 // rev16 vs r1 r12
};
const byte kInstruction_rev16_ge_r9_r14[] = {
  0xbe, 0x9f, 0xbf, 0xa6 // rev16 ge r9 r14
};
const byte kInstruction_rev16_pl_r6_r4[] = {
  0xb4, 0x6f, 0xbf, 0x56 // rev16 pl r6 r4
};
const byte kInstruction_rev16_ls_r3_r2[] = {
  0xb2, 0x3f, 0xbf, 0x96 // rev16 ls r3 r2
};
const byte kInstruction_rev16_cs_r4_r4[] = {
  0xb4, 0x4f, 0xbf, 0x26 // rev16 cs r4 r4
};
const byte kInstruction_rev16_eq_r6_r2[] = {
  0xb2, 0x6f, 0xbf, 0x06 // rev16 eq r6 r2
};
const byte kInstruction_rev16_ge_r14_r0[] = {
  0xb0, 0xef, 0xbf, 0xa6 // rev16 ge r14 r0
};
const byte kInstruction_rev16_le_r11_r6[] = {
  0xb6, 0xbf, 0xbf, 0xd6 // rev16 le r11 r6
};
const byte kInstruction_rev16_vs_r0_r0[] = {
  0xb0, 0x0f, 0xbf, 0x66 // rev16 vs r0 r0
};
const byte kInstruction_rev16_vs_r4_r6[] = {
  0xb6, 0x4f, 0xbf, 0x66 // rev16 vs r4 r6
};
const byte kInstruction_rev16_gt_r6_r10[] = {
  0xba, 0x6f, 0xbf, 0xc6 // rev16 gt r6 r10
};
const byte kInstruction_rev16_vc_r12_r7[] = {
  0xb7, 0xcf, 0xbf, 0x76 // rev16 vc r12 r7
};
const byte kInstruction_rev16_gt_r8_r3[] = {
  0xb3, 0x8f, 0xbf, 0xc6 // rev16 gt r8 r3
};
const byte kInstruction_rev16_hi_r14_r4[] = {
  0xb4, 0xef, 0xbf, 0x86 // rev16 hi r14 r4
};
const byte kInstruction_rev16_hi_r9_r14[] = {
  0xbe, 0x9f, 0xbf, 0x86 // rev16 hi r9 r14
};
const byte kInstruction_rev16_vs_r6_r1[] = {
  0xb1, 0x6f, 0xbf, 0x66 // rev16 vs r6 r1
};
const byte kInstruction_rev16_hi_r5_r4[] = {
  0xb4, 0x5f, 0xbf, 0x86 // rev16 hi r5 r4
};
const byte kInstruction_rev16_lt_r10_r14[] = {
  0xbe, 0xaf, 0xbf, 0xb6 // rev16 lt r10 r14
};
const byte kInstruction_rev16_cc_r8_r10[] = {
  0xba, 0x8f, 0xbf, 0x36 // rev16 cc r8 r10
};
const byte kInstruction_rev16_lt_r11_r0[] = {
  0xb0, 0xbf, 0xbf, 0xb6 // rev16 lt r11 r0
};
const byte kInstruction_rev16_ge_r4_r12[] = {
  0xbc, 0x4f, 0xbf, 0xa6 // rev16 ge r4 r12
};
const byte kInstruction_rev16_cc_r5_r7[] = {
  0xb7, 0x5f, 0xbf, 0x36 // rev16 cc r5 r7
};
const byte kInstruction_rev16_gt_r3_r9[] = {
  0xb9, 0x3f, 0xbf, 0xc6 // rev16 gt r3 r9
};
const byte kInstruction_rev16_vc_r11_r5[] = {
  0xb5, 0xbf, 0xbf, 0x76 // rev16 vc r11 r5
};
const byte kInstruction_rev16_lt_r7_r1[] = {
  0xb1, 0x7f, 0xbf, 0xb6 // rev16 lt r7 r1
};
const byte kInstruction_rev16_lt_r1_r8[] = {
  0xb8, 0x1f, 0xbf, 0xb6 // rev16 lt r1 r8
};
const byte kInstruction_rev16_hi_r11_r13[] = {
  0xbd, 0xbf, 0xbf, 0x86 // rev16 hi r11 r13
};
const byte kInstruction_rev16_vs_r10_r2[] = {
  0xb2, 0xaf, 0xbf, 0x66 // rev16 vs r10 r2
};
const byte kInstruction_rev16_ne_r1_r10[] = {
  0xba, 0x1f, 0xbf, 0x16 // rev16 ne r1 r10
};
const byte kInstruction_rev16_vc_r10_r0[] = {
  0xb0, 0xaf, 0xbf, 0x76 // rev16 vc r10 r0
};
const byte kInstruction_rev16_al_r2_r2[] = {
  0xb2, 0x2f, 0xbf, 0xe6 // rev16 al r2 r2
};
const byte kInstruction_rev16_ne_r7_r8[] = {
  0xb8, 0x7f, 0xbf, 0x16 // rev16 ne r7 r8
};
const byte kInstruction_rev16_hi_r11_r14[] = {
  0xbe, 0xbf, 0xbf, 0x86 // rev16 hi r11 r14
};
const byte kInstruction_rev16_ne_r6_r14[] = {
  0xbe, 0x6f, 0xbf, 0x16 // rev16 ne r6 r14
};
const byte kInstruction_rev16_ge_r8_r5[] = {
  0xb5, 0x8f, 0xbf, 0xa6 // rev16 ge r8 r5
};
const byte kInstruction_rev16_vs_r7_r3[] = {
  0xb3, 0x7f, 0xbf, 0x66 // rev16 vs r7 r3
};
const byte kInstruction_rev16_ne_r14_r13[] = {
  0xbd, 0xef, 0xbf, 0x16 // rev16 ne r14 r13
};
const byte kInstruction_rev16_hi_r12_r11[] = {
  0xbb, 0xcf, 0xbf, 0x86 // rev16 hi r12 r11
};
const byte kInstruction_rev16_ls_r11_r9[] = {
  0xb9, 0xbf, 0xbf, 0x96 // rev16 ls r11 r9
};
const byte kInstruction_rev16_mi_r12_r7[] = {
  0xb7, 0xcf, 0xbf, 0x46 // rev16 mi r12 r7
};
const byte kInstruction_rev16_cc_r8_r8[] = {
  0xb8, 0x8f, 0xbf, 0x36 // rev16 cc r8 r8
};
const byte kInstruction_rev16_ls_r14_r12[] = {
  0xbc, 0xef, 0xbf, 0x96 // rev16 ls r14 r12
};
const byte kInstruction_rev16_ls_r3_r6[] = {
  0xb6, 0x3f, 0xbf, 0x96 // rev16 ls r3 r6
};
const byte kInstruction_rev16_hi_r7_r8[] = {
  0xb8, 0x7f, 0xbf, 0x86 // rev16 hi r7 r8
};
const byte kInstruction_rev16_vs_r4_r10[] = {
  0xba, 0x4f, 0xbf, 0x66 // rev16 vs r4 r10
};
const byte kInstruction_rev16_ne_r12_r1[] = {
  0xb1, 0xcf, 0xbf, 0x16 // rev16 ne r12 r1
};
const byte kInstruction_rev16_vs_r12_r4[] = {
  0xb4, 0xcf, 0xbf, 0x66 // rev16 vs r12 r4
};
const byte kInstruction_rev16_hi_r5_r5[] = {
  0xb5, 0x5f, 0xbf, 0x86 // rev16 hi r5 r5
};
const byte kInstruction_rev16_gt_r8_r8[] = {
  0xb8, 0x8f, 0xbf, 0xc6 // rev16 gt r8 r8
};
const byte kInstruction_rev16_lt_r10_r10[] = {
  0xba, 0xaf, 0xbf, 0xb6 // rev16 lt r10 r10
};
const byte kInstruction_rev16_vs_r13_r4[] = {
  0xb4, 0xdf, 0xbf, 0x66 // rev16 vs r13 r4
};
const byte kInstruction_rev16_mi_r8_r3[] = {
  0xb3, 0x8f, 0xbf, 0x46 // rev16 mi r8 r3
};
const byte kInstruction_rev16_eq_r6_r13[] = {
  0xbd, 0x6f, 0xbf, 0x06 // rev16 eq r6 r13
};
const byte kInstruction_rev16_al_r2_r0[] = {
  0xb0, 0x2f, 0xbf, 0xe6 // rev16 al r2 r0
};
const byte kInstruction_rev16_ls_r6_r12[] = {
  0xbc, 0x6f, 0xbf, 0x96 // rev16 ls r6 r12
};
const byte kInstruction_rev16_vs_r1_r4[] = {
  0xb4, 0x1f, 0xbf, 0x66 // rev16 vs r1 r4
};
const byte kInstruction_rev16_vc_r11_r1[] = {
  0xb1, 0xbf, 0xbf, 0x76 // rev16 vc r11 r1
};
const byte kInstruction_rev16_ne_r9_r10[] = {
  0xba, 0x9f, 0xbf, 0x16 // rev16 ne r9 r10
};
const byte kInstruction_rev16_ne_r3_r10[] = {
  0xba, 0x3f, 0xbf, 0x16 // rev16 ne r3 r10
};
const byte kInstruction_rev16_hi_r7_r10[] = {
  0xba, 0x7f, 0xbf, 0x86 // rev16 hi r7 r10
};
const byte kInstruction_rev16_pl_r4_r10[] = {
  0xba, 0x4f, 0xbf, 0x56 // rev16 pl r4 r10
};
const byte kInstruction_rev16_le_r7_r1[] = {
  0xb1, 0x7f, 0xbf, 0xd6 // rev16 le r7 r1
};
const byte kInstruction_rev16_gt_r13_r10[] = {
  0xba, 0xdf, 0xbf, 0xc6 // rev16 gt r13 r10
};
const byte kInstruction_rev16_lt_r4_r14[] = {
  0xbe, 0x4f, 0xbf, 0xb6 // rev16 lt r4 r14
};
const byte kInstruction_rev16_al_r10_r1[] = {
  0xb1, 0xaf, 0xbf, 0xe6 // rev16 al r10 r1
};
const byte kInstruction_rev16_mi_r6_r12[] = {
  0xbc, 0x6f, 0xbf, 0x46 // rev16 mi r6 r12
};
const byte kInstruction_rev16_eq_r13_r9[] = {
  0xb9, 0xdf, 0xbf, 0x06 // rev16 eq r13 r9
};
const byte kInstruction_rev16_ge_r11_r4[] = {
  0xb4, 0xbf, 0xbf, 0xa6 // rev16 ge r11 r4
};
const byte kInstruction_rev16_hi_r1_r12[] = {
  0xbc, 0x1f, 0xbf, 0x86 // rev16 hi r1 r12
};
const byte kInstruction_rev16_ge_r0_r1[] = {
  0xb1, 0x0f, 0xbf, 0xa6 // rev16 ge r0 r1
};
const byte kInstruction_rev16_lt_r2_r3[] = {
  0xb3, 0x2f, 0xbf, 0xb6 // rev16 lt r2 r3
};
const byte kInstruction_rev16_al_r12_r9[] = {
  0xb9, 0xcf, 0xbf, 0xe6 // rev16 al r12 r9
};
const byte kInstruction_rev16_hi_r2_r10[] = {
  0xba, 0x2f, 0xbf, 0x86 // rev16 hi r2 r10
};
const byte kInstruction_rev16_mi_r14_r11[] = {
  0xbb, 0xef, 0xbf, 0x46 // rev16 mi r14 r11
};
const byte kInstruction_rev16_pl_r3_r10[] = {
  0xba, 0x3f, 0xbf, 0x56 // rev16 pl r3 r10
};
const byte kInstruction_rev16_vs_r1_r6[] = {
  0xb6, 0x1f, 0xbf, 0x66 // rev16 vs r1 r6
};
const byte kInstruction_rev16_al_r7_r6[] = {
  0xb6, 0x7f, 0xbf, 0xe6 // rev16 al r7 r6
};
const byte kInstruction_rev16_ge_r6_r8[] = {
  0xb8, 0x6f, 0xbf, 0xa6 // rev16 ge r6 r8
};
const byte kInstruction_rev16_eq_r3_r3[] = {
  0xb3, 0x3f, 0xbf, 0x06 // rev16 eq r3 r3
};
const byte kInstruction_rev16_ne_r14_r4[] = {
  0xb4, 0xef, 0xbf, 0x16 // rev16 ne r14 r4
};
const byte kInstruction_rev16_vc_r13_r10[] = {
  0xba, 0xdf, 0xbf, 0x76 // rev16 vc r13 r10
};
const byte kInstruction_rev16_mi_r3_r12[] = {
  0xbc, 0x3f, 0xbf, 0x46 // rev16 mi r3 r12
};
const byte kInstruction_rev16_pl_r9_r1[] = {
  0xb1, 0x9f, 0xbf, 0x56 // rev16 pl r9 r1
};
const byte kInstruction_rev16_hi_r14_r14[] = {
  0xbe, 0xef, 0xbf, 0x86 // rev16 hi r14 r14
};
const byte kInstruction_rev16_ne_r0_r9[] = {
  0xb9, 0x0f, 0xbf, 0x16 // rev16 ne r0 r9
};
const byte kInstruction_rev16_mi_r1_r1[] = {
  0xb1, 0x1f, 0xbf, 0x46 // rev16 mi r1 r1
};
const byte kInstruction_rev16_hi_r7_r2[] = {
  0xb2, 0x7f, 0xbf, 0x86 // rev16 hi r7 r2
};
const byte kInstruction_rev16_gt_r2_r3[] = {
  0xb3, 0x2f, 0xbf, 0xc6 // rev16 gt r2 r3
};
const byte kInstruction_rev16_eq_r2_r0[] = {
  0xb0, 0x2f, 0xbf, 0x06 // rev16 eq r2 r0
};
const byte kInstruction_rev16_vs_r10_r12[] = {
  0xbc, 0xaf, 0xbf, 0x66 // rev16 vs r10 r12
};
const byte kInstruction_rev16_gt_r11_r7[] = {
  0xb7, 0xbf, 0xbf, 0xc6 // rev16 gt r11 r7
};
const byte kInstruction_rev16_vs_r13_r2[] = {
  0xb2, 0xdf, 0xbf, 0x66 // rev16 vs r13 r2
};
const byte kInstruction_rev16_ls_r11_r12[] = {
  0xbc, 0xbf, 0xbf, 0x96 // rev16 ls r11 r12
};
const byte kInstruction_rev16_al_r8_r8[] = {
  0xb8, 0x8f, 0xbf, 0xe6 // rev16 al r8 r8
};
const byte kInstruction_rev16_hi_r6_r10[] = {
  0xba, 0x6f, 0xbf, 0x86 // rev16 hi r6 r10
};
const byte kInstruction_rev16_vs_r5_r1[] = {
  0xb1, 0x5f, 0xbf, 0x66 // rev16 vs r5 r1
};
const byte kInstruction_rev16_ls_r0_r10[] = {
  0xba, 0x0f, 0xbf, 0x96 // rev16 ls r0 r10
};
const byte kInstruction_rev16_gt_r0_r1[] = {
  0xb1, 0x0f, 0xbf, 0xc6 // rev16 gt r0 r1
};
const byte kInstruction_rev16_ne_r11_r12[] = {
  0xbc, 0xbf, 0xbf, 0x16 // rev16 ne r11 r12
};
const byte kInstruction_rev16_ne_r13_r5[] = {
  0xb5, 0xdf, 0xbf, 0x16 // rev16 ne r13 r5
};
const byte kInstruction_rev16_mi_r0_r12[] = {
  0xbc, 0x0f, 0xbf, 0x46 // rev16 mi r0 r12
};
const byte kInstruction_rev16_lt_r11_r6[] = {
  0xb6, 0xbf, 0xbf, 0xb6 // rev16 lt r11 r6
};
const byte kInstruction_rev16_eq_r11_r14[] = {
  0xbe, 0xbf, 0xbf, 0x06 // rev16 eq r11 r14
};
const byte kInstruction_rev16_vc_r11_r10[] = {
  0xba, 0xbf, 0xbf, 0x76 // rev16 vc r11 r10
};
const byte kInstruction_rev16_cs_r3_r3[] = {
  0xb3, 0x3f, 0xbf, 0x26 // rev16 cs r3 r3
};
const byte kInstruction_rev16_le_r12_r2[] = {
  0xb2, 0xcf, 0xbf, 0xd6 // rev16 le r12 r2
};
const byte kInstruction_rev16_hi_r13_r8[] = {
  0xb8, 0xdf, 0xbf, 0x86 // rev16 hi r13 r8
};
const byte kInstruction_rev16_pl_r6_r6[] = {
  0xb6, 0x6f, 0xbf, 0x56 // rev16 pl r6 r6
};
const byte kInstruction_rev16_al_r4_r5[] = {
  0xb5, 0x4f, 0xbf, 0xe6 // rev16 al r4 r5
};
const byte kInstruction_rev16_hi_r1_r0[] = {
  0xb0, 0x1f, 0xbf, 0x86 // rev16 hi r1 r0
};
const byte kInstruction_rev16_ls_r10_r11[] = {
  0xbb, 0xaf, 0xbf, 0x96 // rev16 ls r10 r11
};
const byte kInstruction_rev16_al_r8_r7[] = {
  0xb7, 0x8f, 0xbf, 0xe6 // rev16 al r8 r7
};
const byte kInstruction_rev16_vc_r7_r1[] = {
  0xb1, 0x7f, 0xbf, 0x76 // rev16 vc r7 r1
};
const byte kInstruction_rev16_ne_r7_r14[] = {
  0xbe, 0x7f, 0xbf, 0x16 // rev16 ne r7 r14
};
const byte kInstruction_rev16_lt_r5_r9[] = {
  0xb9, 0x5f, 0xbf, 0xb6 // rev16 lt r5 r9
};
const byte kInstruction_rev16_al_r13_r8[] = {
  0xb8, 0xdf, 0xbf, 0xe6 // rev16 al r13 r8
};
const byte kInstruction_rev16_ls_r6_r14[] = {
  0xbe, 0x6f, 0xbf, 0x96 // rev16 ls r6 r14
};
const byte kInstruction_rev16_eq_r12_r0[] = {
  0xb0, 0xcf, 0xbf, 0x06 // rev16 eq r12 r0
};
const byte kInstruction_rev16_mi_r8_r14[] = {
  0xbe, 0x8f, 0xbf, 0x46 // rev16 mi r8 r14
};
const byte kInstruction_rev16_hi_r13_r2[] = {
  0xb2, 0xdf, 0xbf, 0x86 // rev16 hi r13 r2
};
const byte kInstruction_rev16_al_r13_r2[] = {
  0xb2, 0xdf, 0xbf, 0xe6 // rev16 al r13 r2
};
const byte kInstruction_rev16_vs_r8_r9[] = {
  0xb9, 0x8f, 0xbf, 0x66 // rev16 vs r8 r9
};
const byte kInstruction_rev16_cc_r6_r2[] = {
  0xb2, 0x6f, 0xbf, 0x36 // rev16 cc r6 r2
};
const byte kInstruction_rev16_lt_r8_r0[] = {
  0xb0, 0x8f, 0xbf, 0xb6 // rev16 lt r8 r0
};
const byte kInstruction_rev16_ls_r3_r13[] = {
  0xbd, 0x3f, 0xbf, 0x96 // rev16 ls r3 r13
};
const byte kInstruction_rev16_gt_r10_r14[] = {
  0xbe, 0xaf, 0xbf, 0xc6 // rev16 gt r10 r14
};
const byte kInstruction_rev16_pl_r9_r8[] = {
  0xb8, 0x9f, 0xbf, 0x56 // rev16 pl r9 r8
};
const byte kInstruction_rev16_pl_r14_r11[] = {
  0xbb, 0xef, 0xbf, 0x56 // rev16 pl r14 r11
};
const byte kInstruction_rev16_lt_r9_r3[] = {
  0xb3, 0x9f, 0xbf, 0xb6 // rev16 lt r9 r3
};
const byte kInstruction_rev16_hi_r9_r0[] = {
  0xb0, 0x9f, 0xbf, 0x86 // rev16 hi r9 r0
};
const byte kInstruction_rev16_cc_r9_r3[] = {
  0xb3, 0x9f, 0xbf, 0x36 // rev16 cc r9 r3
};
const byte kInstruction_rev16_ge_r10_r14[] = {
  0xbe, 0xaf, 0xbf, 0xa6 // rev16 ge r10 r14
};
const byte kInstruction_rev16_vs_r2_r1[] = {
  0xb1, 0x2f, 0xbf, 0x66 // rev16 vs r2 r1
};
const byte kInstruction_rev16_vc_r4_r13[] = {
  0xbd, 0x4f, 0xbf, 0x76 // rev16 vc r4 r13
};
const byte kInstruction_rev16_ls_r1_r9[] = {
  0xb9, 0x1f, 0xbf, 0x96 // rev16 ls r1 r9
};
const byte kInstruction_rev16_lt_r13_r11[] = {
  0xbb, 0xdf, 0xbf, 0xb6 // rev16 lt r13 r11
};
const byte kInstruction_rev16_cs_r2_r10[] = {
  0xba, 0x2f, 0xbf, 0x26 // rev16 cs r2 r10
};
const byte kInstruction_rev16_le_r0_r13[] = {
  0xbd, 0x0f, 0xbf, 0xd6 // rev16 le r0 r13
};
const byte kInstruction_rev16_al_r13_r11[] = {
  0xbb, 0xdf, 0xbf, 0xe6 // rev16 al r13 r11
};
const byte kInstruction_rev16_eq_r5_r2[] = {
  0xb2, 0x5f, 0xbf, 0x06 // rev16 eq r5 r2
};
const byte kInstruction_rev16_vs_r5_r12[] = {
  0xbc, 0x5f, 0xbf, 0x66 // rev16 vs r5 r12
};
const byte kInstruction_rev16_al_r12_r0[] = {
  0xb0, 0xcf, 0xbf, 0xe6 // rev16 al r12 r0
};
const byte kInstruction_rev16_le_r13_r9[] = {
  0xb9, 0xdf, 0xbf, 0xd6 // rev16 le r13 r9
};
const byte kInstruction_rev16_cs_r14_r4[] = {
  0xb4, 0xef, 0xbf, 0x26 // rev16 cs r14 r4
};
const byte kInstruction_rev16_ne_r5_r7[] = {
  0xb7, 0x5f, 0xbf, 0x16 // rev16 ne r5 r7
};
const byte kInstruction_rev16_al_r6_r6[] = {
  0xb6, 0x6f, 0xbf, 0xe6 // rev16 al r6 r6
};
const byte kInstruction_rev16_gt_r4_r8[] = {
  0xb8, 0x4f, 0xbf, 0xc6 // rev16 gt r4 r8
};
const byte kInstruction_rev16_gt_r12_r8[] = {
  0xb8, 0xcf, 0xbf, 0xc6 // rev16 gt r12 r8
};
const byte kInstruction_rev16_eq_r4_r12[] = {
  0xbc, 0x4f, 0xbf, 0x06 // rev16 eq r4 r12
};
const byte kInstruction_rev16_cs_r7_r13[] = {
  0xbd, 0x7f, 0xbf, 0x26 // rev16 cs r7 r13
};
const byte kInstruction_rev16_cs_r2_r4[] = {
  0xb4, 0x2f, 0xbf, 0x26 // rev16 cs r2 r4
};
const byte kInstruction_rev16_al_r10_r3[] = {
  0xb3, 0xaf, 0xbf, 0xe6 // rev16 al r10 r3
};
const byte kInstruction_rev16_cs_r8_r9[] = {
  0xb9, 0x8f, 0xbf, 0x26 // rev16 cs r8 r9
};
const byte kInstruction_rev16_cs_r1_r12[] = {
  0xbc, 0x1f, 0xbf, 0x26 // rev16 cs r1 r12
};
const byte kInstruction_rev16_gt_r13_r0[] = {
  0xb0, 0xdf, 0xbf, 0xc6 // rev16 gt r13 r0
};
const byte kInstruction_rev16_vc_r13_r12[] = {
  0xbc, 0xdf, 0xbf, 0x76 // rev16 vc r13 r12
};
const byte kInstruction_rev16_lt_r12_r14[] = {
  0xbe, 0xcf, 0xbf, 0xb6 // rev16 lt r12 r14
};
const byte kInstruction_rev16_lt_r0_r1[] = {
  0xb1, 0x0f, 0xbf, 0xb6 // rev16 lt r0 r1
};
const byte kInstruction_rev16_cc_r10_r2[] = {
  0xb2, 0xaf, 0xbf, 0x36 // rev16 cc r10 r2
};
const byte kInstruction_rev16_le_r3_r5[] = {
  0xb5, 0x3f, 0xbf, 0xd6 // rev16 le r3 r5
};
const byte kInstruction_rev16_eq_r2_r11[] = {
  0xbb, 0x2f, 0xbf, 0x06 // rev16 eq r2 r11
};
const byte kInstruction_rev16_al_r12_r4[] = {
  0xb4, 0xcf, 0xbf, 0xe6 // rev16 al r12 r4
};
const byte kInstruction_rev16_cs_r6_r5[] = {
  0xb5, 0x6f, 0xbf, 0x26 // rev16 cs r6 r5
};
const byte kInstruction_rev16_hi_r13_r10[] = {
  0xba, 0xdf, 0xbf, 0x86 // rev16 hi r13 r10
};
const byte kInstruction_rev16_vs_r4_r3[] = {
  0xb3, 0x4f, 0xbf, 0x66 // rev16 vs r4 r3
};
const byte kInstruction_rev16_ls_r7_r9[] = {
  0xb9, 0x7f, 0xbf, 0x96 // rev16 ls r7 r9
};
const byte kInstruction_rev16_vs_r14_r8[] = {
  0xb8, 0xef, 0xbf, 0x66 // rev16 vs r14 r8
};
const byte kInstruction_rev16_cs_r1_r0[] = {
  0xb0, 0x1f, 0xbf, 0x26 // rev16 cs r1 r0
};
const byte kInstruction_rev16_mi_r10_r8[] = {
  0xb8, 0xaf, 0xbf, 0x46 // rev16 mi r10 r8
};
const byte kInstruction_rev16_ge_r10_r4[] = {
  0xb4, 0xaf, 0xbf, 0xa6 // rev16 ge r10 r4
};
const byte kInstruction_rev16_cc_r5_r4[] = {
  0xb4, 0x5f, 0xbf, 0x36 // rev16 cc r5 r4
};
const byte kInstruction_rev16_lt_r0_r7[] = {
  0xb7, 0x0f, 0xbf, 0xb6 // rev16 lt r0 r7
};
const byte kInstruction_rev16_mi_r14_r10[] = {
  0xba, 0xef, 0xbf, 0x46 // rev16 mi r14 r10
};
const byte kInstruction_rev16_mi_r0_r14[] = {
  0xbe, 0x0f, 0xbf, 0x46 // rev16 mi r0 r14
};
const byte kInstruction_rev16_eq_r14_r10[] = {
  0xba, 0xef, 0xbf, 0x06 // rev16 eq r14 r10
};
const byte kInstruction_rev16_ls_r4_r4[] = {
  0xb4, 0x4f, 0xbf, 0x96 // rev16 ls r4 r4
};
const byte kInstruction_rev16_pl_r14_r1[] = {
  0xb1, 0xef, 0xbf, 0x56 // rev16 pl r14 r1
};
const byte kInstruction_rev16_eq_r10_r8[] = {
  0xb8, 0xaf, 0xbf, 0x06 // rev16 eq r10 r8
};
const byte kInstruction_rev16_cs_r10_r6[] = {
  0xb6, 0xaf, 0xbf, 0x26 // rev16 cs r10 r6
};
const byte kInstruction_rev16_al_r12_r2[] = {
  0xb2, 0xcf, 0xbf, 0xe6 // rev16 al r12 r2
};
const byte kInstruction_rev16_ls_r12_r1[] = {
  0xb1, 0xcf, 0xbf, 0x96 // rev16 ls r12 r1
};
const byte kInstruction_rev16_eq_r12_r11[] = {
  0xbb, 0xcf, 0xbf, 0x06 // rev16 eq r12 r11
};
const byte kInstruction_rev16_vc_r4_r1[] = {
  0xb1, 0x4f, 0xbf, 0x76 // rev16 vc r4 r1
};
const byte kInstruction_rev16_vs_r12_r2[] = {
  0xb2, 0xcf, 0xbf, 0x66 // rev16 vs r12 r2
};
const byte kInstruction_rev16_al_r11_r8[] = {
  0xb8, 0xbf, 0xbf, 0xe6 // rev16 al r11 r8
};
const byte kInstruction_rev16_hi_r6_r13[] = {
  0xbd, 0x6f, 0xbf, 0x86 // rev16 hi r6 r13
};
const byte kInstruction_rev16_eq_r2_r8[] = {
  0xb8, 0x2f, 0xbf, 0x06 // rev16 eq r2 r8
};
const byte kInstruction_rev16_cc_r9_r5[] = {
  0xb5, 0x9f, 0xbf, 0x36 // rev16 cc r9 r5
};
const byte kInstruction_rev16_cc_r9_r7[] = {
  0xb7, 0x9f, 0xbf, 0x36 // rev16 cc r9 r7
};
const byte kInstruction_rev16_lt_r4_r6[] = {
  0xb6, 0x4f, 0xbf, 0xb6 // rev16 lt r4 r6
};
const byte kInstruction_rev16_cc_r14_r13[] = {
  0xbd, 0xef, 0xbf, 0x36 // rev16 cc r14 r13
};
const byte kInstruction_rev16_vc_r3_r2[] = {
  0xb2, 0x3f, 0xbf, 0x76 // rev16 vc r3 r2
};
const byte kInstruction_rev16_al_r6_r13[] = {
  0xbd, 0x6f, 0xbf, 0xe6 // rev16 al r6 r13
};
const byte kInstruction_rev16_vs_r10_r10[] = {
  0xba, 0xaf, 0xbf, 0x66 // rev16 vs r10 r10
};
const byte kInstruction_rev16_cs_r6_r10[] = {
  0xba, 0x6f, 0xbf, 0x26 // rev16 cs r6 r10
};
const byte kInstruction_rev16_cc_r8_r12[] = {
  0xbc, 0x8f, 0xbf, 0x36 // rev16 cc r8 r12
};
const byte kInstruction_rev16_vs_r7_r5[] = {
  0xb5, 0x7f, 0xbf, 0x66 // rev16 vs r7 r5
};
const byte kInstruction_rev16_pl_r14_r10[] = {
  0xba, 0xef, 0xbf, 0x56 // rev16 pl r14 r10
};
const byte kInstruction_rev16_hi_r1_r14[] = {
  0xbe, 0x1f, 0xbf, 0x86 // rev16 hi r1 r14
};
const byte kInstruction_rev16_vc_r8_r12[] = {
  0xbc, 0x8f, 0xbf, 0x76 // rev16 vc r8 r12
};
const byte kInstruction_rev16_ls_r2_r4[] = {
  0xb4, 0x2f, 0xbf, 0x96 // rev16 ls r2 r4
};
const byte kInstruction_rev16_mi_r5_r12[] = {
  0xbc, 0x5f, 0xbf, 0x46 // rev16 mi r5 r12
};
const byte kInstruction_rev16_eq_r6_r12[] = {
  0xbc, 0x6f, 0xbf, 0x06 // rev16 eq r6 r12
};
const byte kInstruction_rev16_lt_r14_r9[] = {
  0xb9, 0xef, 0xbf, 0xb6 // rev16 lt r14 r9
};
const byte kInstruction_rev16_lt_r11_r9[] = {
  0xb9, 0xbf, 0xbf, 0xb6 // rev16 lt r11 r9
};
const byte kInstruction_rev16_ne_r1_r9[] = {
  0xb9, 0x1f, 0xbf, 0x16 // rev16 ne r1 r9
};
const byte kInstruction_rev16_pl_r11_r8[] = {
  0xb8, 0xbf, 0xbf, 0x56 // rev16 pl r11 r8
};
const byte kInstruction_rev16_ne_r0_r6[] = {
  0xb6, 0x0f, 0xbf, 0x16 // rev16 ne r0 r6
};
const byte kInstruction_rev16_vs_r4_r4[] = {
  0xb4, 0x4f, 0xbf, 0x66 // rev16 vs r4 r4
};
const byte kInstruction_rev16_ls_r12_r9[] = {
  0xb9, 0xcf, 0xbf, 0x96 // rev16 ls r12 r9
};
const byte kInstruction_rev16_cs_r9_r7[] = {
  0xb7, 0x9f, 0xbf, 0x26 // rev16 cs r9 r7
};
const byte kInstruction_rev16_ne_r7_r2[] = {
  0xb2, 0x7f, 0xbf, 0x16 // rev16 ne r7 r2
};
const byte kInstruction_rev16_hi_r9_r10[] = {
  0xba, 0x9f, 0xbf, 0x86 // rev16 hi r9 r10
};
const byte kInstruction_rev16_gt_r5_r2[] = {
  0xb2, 0x5f, 0xbf, 0xc6 // rev16 gt r5 r2
};
const byte kInstruction_rev16_pl_r4_r6[] = {
  0xb6, 0x4f, 0xbf, 0x56 // rev16 pl r4 r6
};
const byte kInstruction_rev16_lt_r11_r8[] = {
  0xb8, 0xbf, 0xbf, 0xb6 // rev16 lt r11 r8
};
const byte kInstruction_rev16_hi_r13_r4[] = {
  0xb4, 0xdf, 0xbf, 0x86 // rev16 hi r13 r4
};
const byte kInstruction_rev16_le_r1_r10[] = {
  0xba, 0x1f, 0xbf, 0xd6 // rev16 le r1 r10
};
const byte kInstruction_rev16_le_r11_r3[] = {
  0xb3, 0xbf, 0xbf, 0xd6 // rev16 le r11 r3
};
const byte kInstruction_rev16_pl_r0_r11[] = {
  0xbb, 0x0f, 0xbf, 0x56 // rev16 pl r0 r11
};
const byte kInstruction_rev16_le_r7_r4[] = {
  0xb4, 0x7f, 0xbf, 0xd6 // rev16 le r7 r4
};
const byte kInstruction_rev16_le_r2_r11[] = {
  0xbb, 0x2f, 0xbf, 0xd6 // rev16 le r2 r11
};
const byte kInstruction_rev16_cc_r1_r10[] = {
  0xba, 0x1f, 0xbf, 0x36 // rev16 cc r1 r10
};
const byte kInstruction_rev16_gt_r13_r14[] = {
  0xbe, 0xdf, 0xbf, 0xc6 // rev16 gt r13 r14
};
const byte kInstruction_rev16_ls_r10_r6[] = {
  0xb6, 0xaf, 0xbf, 0x96 // rev16 ls r10 r6
};
const byte kInstruction_rev16_ls_r13_r4[] = {
  0xb4, 0xdf, 0xbf, 0x96 // rev16 ls r13 r4
};
const byte kInstruction_rev16_gt_r12_r13[] = {
  0xbd, 0xcf, 0xbf, 0xc6 // rev16 gt r12 r13
};
const byte kInstruction_rev16_pl_r13_r7[] = {
  0xb7, 0xdf, 0xbf, 0x56 // rev16 pl r13 r7
};
const byte kInstruction_rev16_le_r14_r0[] = {
  0xb0, 0xef, 0xbf, 0xd6 // rev16 le r14 r0
};
const byte kInstruction_rev16_gt_r1_r4[] = {
  0xb4, 0x1f, 0xbf, 0xc6 // rev16 gt r1 r4
};
const byte kInstruction_rev16_mi_r3_r5[] = {
  0xb5, 0x3f, 0xbf, 0x46 // rev16 mi r3 r5
};
const byte kInstruction_rev16_vc_r4_r0[] = {
  0xb0, 0x4f, 0xbf, 0x76 // rev16 vc r4 r0
};
const byte kInstruction_rev16_gt_r4_r11[] = {
  0xbb, 0x4f, 0xbf, 0xc6 // rev16 gt r4 r11
};
const byte kInstruction_rev16_vc_r5_r3[] = {
  0xb3, 0x5f, 0xbf, 0x76 // rev16 vc r5 r3
};
const byte kInstruction_rev16_pl_r4_r7[] = {
  0xb7, 0x4f, 0xbf, 0x56 // rev16 pl r4 r7
};
const byte kInstruction_rev16_al_r12_r6[] = {
  0xb6, 0xcf, 0xbf, 0xe6 // rev16 al r12 r6
};
const byte kInstruction_rev16_mi_r2_r3[] = {
  0xb3, 0x2f, 0xbf, 0x46 // rev16 mi r2 r3
};
const byte kInstruction_rev16_lt_r12_r4[] = {
  0xb4, 0xcf, 0xbf, 0xb6 // rev16 lt r12 r4
};
const byte kInstruction_rev16_lt_r10_r4[] = {
  0xb4, 0xaf, 0xbf, 0xb6 // rev16 lt r10 r4
};
const byte kInstruction_rev16_hi_r10_r8[] = {
  0xb8, 0xaf, 0xbf, 0x86 // rev16 hi r10 r8
};
const byte kInstruction_rev16_al_r0_r14[] = {
  0xbe, 0x0f, 0xbf, 0xe6 // rev16 al r0 r14
};
const byte kInstruction_rev16_cc_r3_r3[] = {
  0xb3, 0x3f, 0xbf, 0x36 // rev16 cc r3 r3
};
const byte kInstruction_rev16_pl_r10_r13[] = {
  0xbd, 0xaf, 0xbf, 0x56 // rev16 pl r10 r13
};
const byte kInstruction_rev16_lt_r7_r8[] = {
  0xb8, 0x7f, 0xbf, 0xb6 // rev16 lt r7 r8
};
const byte kInstruction_rev16_le_r12_r7[] = {
  0xb7, 0xcf, 0xbf, 0xd6 // rev16 le r12 r7
};
const byte kInstruction_rev16_ge_r11_r8[] = {
  0xb8, 0xbf, 0xbf, 0xa6 // rev16 ge r11 r8
};
const byte kInstruction_rev16_ls_r10_r8[] = {
  0xb8, 0xaf, 0xbf, 0x96 // rev16 ls r10 r8
};
const byte kInstruction_rev16_vs_r9_r1[] = {
  0xb1, 0x9f, 0xbf, 0x66 // rev16 vs r9 r1
};
const byte kInstruction_rev16_ne_r10_r10[] = {
  0xba, 0xaf, 0xbf, 0x16 // rev16 ne r10 r10
};
const byte kInstruction_rev16_al_r6_r4[] = {
  0xb4, 0x6f, 0xbf, 0xe6 // rev16 al r6 r4
};
const byte kInstruction_rev16_ls_r10_r0[] = {
  0xb0, 0xaf, 0xbf, 0x96 // rev16 ls r10 r0
};
const byte kInstruction_rev16_eq_r7_r1[] = {
  0xb1, 0x7f, 0xbf, 0x06 // rev16 eq r7 r1
};
const byte kInstruction_rev16_al_r11_r6[] = {
  0xb6, 0xbf, 0xbf, 0xe6 // rev16 al r11 r6
};
const byte kInstruction_rev16_ge_r5_r10[] = {
  0xba, 0x5f, 0xbf, 0xa6 // rev16 ge r5 r10
};
const byte kInstruction_rev16_vs_r0_r8[] = {
  0xb8, 0x0f, 0xbf, 0x66 // rev16 vs r0 r8
};
const byte kInstruction_rev16_lt_r2_r1[] = {
  0xb1, 0x2f, 0xbf, 0xb6 // rev16 lt r2 r1
};
const byte kInstruction_rev16_le_r13_r2[] = {
  0xb2, 0xdf, 0xbf, 0xd6 // rev16 le r13 r2
};
const byte kInstruction_rev16_al_r13_r6[] = {
  0xb6, 0xdf, 0xbf, 0xe6 // rev16 al r13 r6
};
const byte kInstruction_rev16_lt_r12_r10[] = {
  0xba, 0xcf, 0xbf, 0xb6 // rev16 lt r12 r10
};
const byte kInstruction_rev16_al_r13_r1[] = {
  0xb1, 0xdf, 0xbf, 0xe6 // rev16 al r13 r1
};
const byte kInstruction_rev16_ge_r8_r14[] = {
  0xbe, 0x8f, 0xbf, 0xa6 // rev16 ge r8 r14
};
const byte kInstruction_rev16_mi_r11_r6[] = {
  0xb6, 0xbf, 0xbf, 0x46 // rev16 mi r11 r6
};
const byte kInstruction_rev16_pl_r12_r14[] = {
  0xbe, 0xcf, 0xbf, 0x56 // rev16 pl r12 r14
};
const byte kInstruction_rev16_ne_r14_r9[] = {
  0xb9, 0xef, 0xbf, 0x16 // rev16 ne r14 r9
};
const byte kInstruction_rev16_cc_r3_r1[] = {
  0xb1, 0x3f, 0xbf, 0x36 // rev16 cc r3 r1
};
const byte kInstruction_rev16_ge_r0_r8[] = {
  0xb8, 0x0f, 0xbf, 0xa6 // rev16 ge r0 r8
};
const byte kInstruction_rev16_vc_r7_r9[] = {
  0xb9, 0x7f, 0xbf, 0x76 // rev16 vc r7 r9
};
const byte kInstruction_rev16_gt_r11_r4[] = {
  0xb4, 0xbf, 0xbf, 0xc6 // rev16 gt r11 r4
};
const byte kInstruction_rev16_mi_r4_r0[] = {
  0xb0, 0x4f, 0xbf, 0x46 // rev16 mi r4 r0
};
const byte kInstruction_rev16_ls_r3_r11[] = {
  0xbb, 0x3f, 0xbf, 0x96 // rev16 ls r3 r11
};
const byte kInstruction_rev16_le_r14_r5[] = {
  0xb5, 0xef, 0xbf, 0xd6 // rev16 le r14 r5
};
const byte kInstruction_rev16_ls_r6_r7[] = {
  0xb7, 0x6f, 0xbf, 0x96 // rev16 ls r6 r7
};
const byte kInstruction_rev16_ne_r4_r6[] = {
  0xb6, 0x4f, 0xbf, 0x16 // rev16 ne r4 r6
};
const byte kInstruction_rev16_cc_r1_r14[] = {
  0xbe, 0x1f, 0xbf, 0x36 // rev16 cc r1 r14
};
const byte kInstruction_rev16_pl_r11_r7[] = {
  0xb7, 0xbf, 0xbf, 0x56 // rev16 pl r11 r7
};
const byte kInstruction_rev16_vc_r6_r5[] = {
  0xb5, 0x6f, 0xbf, 0x76 // rev16 vc r6 r5
};
const byte kInstruction_rev16_al_r1_r11[] = {
  0xbb, 0x1f, 0xbf, 0xe6 // rev16 al r1 r11
};
const byte kInstruction_rev16_ne_r2_r13[] = {
  0xbd, 0x2f, 0xbf, 0x16 // rev16 ne r2 r13
};
const byte kInstruction_rev16_vc_r14_r6[] = {
  0xb6, 0xef, 0xbf, 0x76 // rev16 vc r14 r6
};
const byte kInstruction_rev16_gt_r3_r8[] = {
  0xb8, 0x3f, 0xbf, 0xc6 // rev16 gt r3 r8
};
const byte kInstruction_rev16_pl_r1_r8[] = {
  0xb8, 0x1f, 0xbf, 0x56 // rev16 pl r1 r8
};
const byte kInstruction_rev16_vc_r2_r14[] = {
  0xbe, 0x2f, 0xbf, 0x76 // rev16 vc r2 r14
};
const byte kInstruction_rev16_pl_r12_r3[] = {
  0xb3, 0xcf, 0xbf, 0x56 // rev16 pl r12 r3
};
const byte kInstruction_rev16_ls_r0_r12[] = {
  0xbc, 0x0f, 0xbf, 0x96 // rev16 ls r0 r12
};
const byte kInstruction_rev16_le_r2_r1[] = {
  0xb1, 0x2f, 0xbf, 0xd6 // rev16 le r2 r1
};
const byte kInstruction_rev16_eq_r13_r5[] = {
  0xb5, 0xdf, 0xbf, 0x06 // rev16 eq r13 r5
};
const byte kInstruction_rev16_al_r11_r11[] = {
  0xbb, 0xbf, 0xbf, 0xe6 // rev16 al r11 r11
};
const byte kInstruction_rev16_ls_r9_r3[] = {
  0xb3, 0x9f, 0xbf, 0x96 // rev16 ls r9 r3
};
const byte kInstruction_rev16_ne_r7_r12[] = {
  0xbc, 0x7f, 0xbf, 0x16 // rev16 ne r7 r12
};
const byte kInstruction_rev16_al_r6_r2[] = {
  0xb2, 0x6f, 0xbf, 0xe6 // rev16 al r6 r2
};
const byte kInstruction_rev16_ne_r7_r4[] = {
  0xb4, 0x7f, 0xbf, 0x16 // rev16 ne r7 r4
};
const byte kInstruction_rev16_vc_r7_r5[] = {
  0xb5, 0x7f, 0xbf, 0x76 // rev16 vc r7 r5
};
const byte kInstruction_rev16_ne_r7_r1[] = {
  0xb1, 0x7f, 0xbf, 0x16 // rev16 ne r7 r1
};
const byte kInstruction_rev16_eq_r5_r3[] = {
  0xb3, 0x5f, 0xbf, 0x06 // rev16 eq r5 r3
};
const byte kInstruction_rev16_cs_r3_r5[] = {
  0xb5, 0x3f, 0xbf, 0x26 // rev16 cs r3 r5
};
const byte kInstruction_rev16_lt_r7_r4[] = {
  0xb4, 0x7f, 0xbf, 0xb6 // rev16 lt r7 r4
};
const byte kInstruction_rev16_ls_r4_r5[] = {
  0xb5, 0x4f, 0xbf, 0x96 // rev16 ls r4 r5
};
const byte kInstruction_rev16_eq_r11_r2[] = {
  0xb2, 0xbf, 0xbf, 0x06 // rev16 eq r11 r2
};
const byte kInstruction_rev16_hi_r2_r6[] = {
  0xb6, 0x2f, 0xbf, 0x86 // rev16 hi r2 r6
};
const byte kInstruction_rev16_vc_r2_r3[] = {
  0xb3, 0x2f, 0xbf, 0x76 // rev16 vc r2 r3
};
const byte kInstruction_rev16_ls_r12_r12[] = {
  0xbc, 0xcf, 0xbf, 0x96 // rev16 ls r12 r12
};
const byte kInstruction_rev16_lt_r8_r2[] = {
  0xb2, 0x8f, 0xbf, 0xb6 // rev16 lt r8 r2
};
const byte kInstruction_rev16_cc_r14_r8[] = {
  0xb8, 0xef, 0xbf, 0x36 // rev16 cc r14 r8
};
const byte kInstruction_rev16_ge_r12_r8[] = {
  0xb8, 0xcf, 0xbf, 0xa6 // rev16 ge r12 r8
};
const TestResult kReferencerev16[] = {
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r12_r1),
    kInstruction_rev16_cs_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r6_r12),
    kInstruction_rev16_hi_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r11_r10),
    kInstruction_rev16_lt_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r10_r8),
    kInstruction_rev16_vs_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r5_r8),
    kInstruction_rev16_pl_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r14_r14),
    kInstruction_rev16_ls_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r8_r6),
    kInstruction_rev16_gt_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r7_r11),
    kInstruction_rev16_vc_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r4_r12),
    kInstruction_rev16_pl_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r12_r12),
    kInstruction_rev16_gt_r12_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r8_r4),
    kInstruction_rev16_ne_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r1_r11),
    kInstruction_rev16_le_r1_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r4_r10),
    kInstruction_rev16_cc_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r14_r0),
    kInstruction_rev16_gt_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r2_r11),
    kInstruction_rev16_cs_r2_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r3_r12),
    kInstruction_rev16_al_r3_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r6_r0),
    kInstruction_rev16_hi_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r10_r10),
    kInstruction_rev16_ls_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r4_r8),
    kInstruction_rev16_ls_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r8_r0),
    kInstruction_rev16_le_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r5_r3),
    kInstruction_rev16_pl_r5_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r8_r5),
    kInstruction_rev16_ls_r8_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r0_r10),
    kInstruction_rev16_ge_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r10_r6),
    kInstruction_rev16_lt_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r9_r9),
    kInstruction_rev16_ne_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r5_r0),
    kInstruction_rev16_hi_r5_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r10_r6),
    kInstruction_rev16_pl_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r1_r3),
    kInstruction_rev16_vs_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r9_r8),
    kInstruction_rev16_vs_r9_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r2_r10),
    kInstruction_rev16_cc_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r11_r3),
    kInstruction_rev16_cs_r11_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r8_r2),
    kInstruction_rev16_hi_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r6_r0),
    kInstruction_rev16_pl_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r9_r2),
    kInstruction_rev16_hi_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r14_r11),
    kInstruction_rev16_al_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r8_r13),
    kInstruction_rev16_eq_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r12_r2),
    kInstruction_rev16_ge_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r2_r6),
    kInstruction_rev16_cc_r2_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r13_r9),
    kInstruction_rev16_ne_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r13_r10),
    kInstruction_rev16_ne_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r10_r9),
    kInstruction_rev16_mi_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r13_r12),
    kInstruction_rev16_lt_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r14_r3),
    kInstruction_rev16_lt_r14_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r12_r14),
    kInstruction_rev16_mi_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r11_r2),
    kInstruction_rev16_vs_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r11_r0),
    kInstruction_rev16_ls_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r10_r9),
    kInstruction_rev16_gt_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r10_r12),
    kInstruction_rev16_le_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r0_r14),
    kInstruction_rev16_ge_r0_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r5_r8),
    kInstruction_rev16_mi_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r4_r11),
    kInstruction_rev16_vs_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r7_r12),
    kInstruction_rev16_lt_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r2_r8),
    kInstruction_rev16_gt_r2_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r5_r7),
    kInstruction_rev16_gt_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r6_r3),
    kInstruction_rev16_pl_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r2_r12),
    kInstruction_rev16_ne_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r11_r11),
    kInstruction_rev16_hi_r11_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r4_r14),
    kInstruction_rev16_vs_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r13_r1),
    kInstruction_rev16_vs_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r4_r3),
    kInstruction_rev16_cs_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r13_r6),
    kInstruction_rev16_eq_r13_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r11_r14),
    kInstruction_rev16_gt_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r14_r4),
    kInstruction_rev16_vc_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r1_r10),
    kInstruction_rev16_vc_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r10_r3),
    kInstruction_rev16_mi_r10_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r9_r3),
    kInstruction_rev16_vs_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r14_r5),
    kInstruction_rev16_vc_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r9_r1),
    kInstruction_rev16_ne_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r9_r6),
    kInstruction_rev16_al_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r7_r8),
    kInstruction_rev16_vc_r7_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r6_r9),
    kInstruction_rev16_ls_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r14_r2),
    kInstruction_rev16_le_r14_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r9_r13),
    kInstruction_rev16_ls_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r1_r5),
    kInstruction_rev16_eq_r1_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r9_r2),
    kInstruction_rev16_le_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r2_r1),
    kInstruction_rev16_eq_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r9_r11),
    kInstruction_rev16_ls_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r7_r13),
    kInstruction_rev16_lt_r7_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r8_r7),
    kInstruction_rev16_cc_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r5_r1),
    kInstruction_rev16_ls_r5_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r1_r9),
    kInstruction_rev16_le_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r8_r14),
    kInstruction_rev16_ls_r8_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r9_r1),
    kInstruction_rev16_le_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r1_r6),
    kInstruction_rev16_gt_r1_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r11_r10),
    kInstruction_rev16_gt_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r0_r12),
    kInstruction_rev16_hi_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r1_r7),
    kInstruction_rev16_gt_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r7_r1),
    kInstruction_rev16_mi_r7_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r7_r0),
    kInstruction_rev16_mi_r7_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r1_r3),
    kInstruction_rev16_ls_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r13_r3),
    kInstruction_rev16_mi_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r4_r3),
    kInstruction_rev16_eq_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r14_r9),
    kInstruction_rev16_vc_r14_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r3_r1),
    kInstruction_rev16_pl_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r0_r2),
    kInstruction_rev16_mi_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r2_r7),
    kInstruction_rev16_hi_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r13_r12),
    kInstruction_rev16_hi_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r12_r8),
    kInstruction_rev16_ls_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r5_r6),
    kInstruction_rev16_ne_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r5_r4),
    kInstruction_rev16_pl_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r1_r6),
    kInstruction_rev16_ge_r1_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r8_r10),
    kInstruction_rev16_eq_r8_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r5_r4),
    kInstruction_rev16_cs_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r11_r6),
    kInstruction_rev16_eq_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r13_r3),
    kInstruction_rev16_cs_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r2_r8),
    kInstruction_rev16_pl_r2_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r10_r0),
    kInstruction_rev16_gt_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r4_r10),
    kInstruction_rev16_lt_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r14_r14),
    kInstruction_rev16_vs_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r0_r7),
    kInstruction_rev16_hi_r0_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r9_r6),
    kInstruction_rev16_cc_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r7_r13),
    kInstruction_rev16_ne_r7_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r2_r6),
    kInstruction_rev16_eq_r2_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r12_r12),
    kInstruction_rev16_cs_r12_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r3_r10),
    kInstruction_rev16_mi_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r6_r13),
    kInstruction_rev16_le_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r2_r1),
    kInstruction_rev16_al_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r3_r4),
    kInstruction_rev16_le_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r4_r4),
    kInstruction_rev16_pl_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r12_r3),
    kInstruction_rev16_lt_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r7_r4),
    kInstruction_rev16_ls_r7_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r9_r4),
    kInstruction_rev16_le_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r13_r3),
    kInstruction_rev16_vc_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r8_r8),
    kInstruction_rev16_vc_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r2_r8),
    kInstruction_rev16_ge_r2_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r11_r13),
    kInstruction_rev16_le_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r1_r5),
    kInstruction_rev16_le_r1_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r9_r12),
    kInstruction_rev16_ge_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r14_r14),
    kInstruction_rev16_cs_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r1_r0),
    kInstruction_rev16_cc_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r3_r0),
    kInstruction_rev16_ge_r3_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r10_r0),
    kInstruction_rev16_al_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r11_r10),
    kInstruction_rev16_cc_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r11_r11),
    kInstruction_rev16_mi_r11_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r12_r7),
    kInstruction_rev16_ne_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r4_r12),
    kInstruction_rev16_lt_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r14_r5),
    kInstruction_rev16_gt_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r1_r7),
    kInstruction_rev16_ge_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r7_r0),
    kInstruction_rev16_al_r7_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r2_r0),
    kInstruction_rev16_ls_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r6_r11),
    kInstruction_rev16_pl_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r0_r6),
    kInstruction_rev16_vc_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r6_r9),
    kInstruction_rev16_pl_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r8_r1),
    kInstruction_rev16_vs_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r1_r6),
    kInstruction_rev16_cs_r1_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r4_r11),
    kInstruction_rev16_hi_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r5_r5),
    kInstruction_rev16_gt_r5_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r3_r4),
    kInstruction_rev16_al_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r11_r12),
    kInstruction_rev16_ge_r11_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r14_r2),
    kInstruction_rev16_cc_r14_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r2_r4),
    kInstruction_rev16_ge_r2_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r5_r11),
    kInstruction_rev16_lt_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r11_r14),
    kInstruction_rev16_mi_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r3_r3),
    kInstruction_rev16_ne_r3_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r14_r0),
    kInstruction_rev16_pl_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r4_r10),
    kInstruction_rev16_vc_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r6_r8),
    kInstruction_rev16_vs_r6_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r4_r7),
    kInstruction_rev16_vc_r4_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r11_r10),
    kInstruction_rev16_cs_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r11_r8),
    kInstruction_rev16_eq_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r9_r2),
    kInstruction_rev16_ne_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r9_r7),
    kInstruction_rev16_hi_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r0_r6),
    kInstruction_rev16_lt_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r5_r8),
    kInstruction_rev16_vc_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r3_r1),
    kInstruction_rev16_gt_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r3_r5),
    kInstruction_rev16_pl_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r11_r5),
    kInstruction_rev16_al_r11_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r8_r14),
    kInstruction_rev16_hi_r8_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r5_r4),
    kInstruction_rev16_le_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r13_r3),
    kInstruction_rev16_ge_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r7_r14),
    kInstruction_rev16_pl_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r6_r9),
    kInstruction_rev16_cs_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r8_r12),
    kInstruction_rev16_lt_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r12_r0),
    kInstruction_rev16_cc_r12_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r14_r13),
    kInstruction_rev16_mi_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r12_r13),
    kInstruction_rev16_pl_r12_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r4_r8),
    kInstruction_rev16_al_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r5_r11),
    kInstruction_rev16_ls_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r11_r3),
    kInstruction_rev16_ge_r11_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r1_r0),
    kInstruction_rev16_le_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r14_r4),
    kInstruction_rev16_gt_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r3_r14),
    kInstruction_rev16_ne_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r3_r8),
    kInstruction_rev16_cc_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r7_r10),
    kInstruction_rev16_eq_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r0_r10),
    kInstruction_rev16_pl_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r6_r13),
    kInstruction_rev16_mi_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r10_r5),
    kInstruction_rev16_gt_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r0_r1),
    kInstruction_rev16_ne_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r4_r8),
    kInstruction_rev16_ge_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r3_r7),
    kInstruction_rev16_cs_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r2_r12),
    kInstruction_rev16_pl_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r9_r12),
    kInstruction_rev16_ls_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r4_r9),
    kInstruction_rev16_ge_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r7_r2),
    kInstruction_rev16_lt_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r10_r10),
    kInstruction_rev16_hi_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r1_r7),
    kInstruction_rev16_ls_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r1_r12),
    kInstruction_rev16_vs_r1_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r9_r14),
    kInstruction_rev16_ge_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r6_r4),
    kInstruction_rev16_pl_r6_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r3_r2),
    kInstruction_rev16_ls_r3_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r4_r4),
    kInstruction_rev16_cs_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r6_r2),
    kInstruction_rev16_eq_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r14_r0),
    kInstruction_rev16_ge_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r11_r6),
    kInstruction_rev16_le_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r0_r0),
    kInstruction_rev16_vs_r0_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r4_r6),
    kInstruction_rev16_vs_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r6_r10),
    kInstruction_rev16_gt_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r12_r7),
    kInstruction_rev16_vc_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r8_r3),
    kInstruction_rev16_gt_r8_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r14_r4),
    kInstruction_rev16_hi_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r9_r14),
    kInstruction_rev16_hi_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r6_r1),
    kInstruction_rev16_vs_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r5_r4),
    kInstruction_rev16_hi_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r10_r14),
    kInstruction_rev16_lt_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r8_r10),
    kInstruction_rev16_cc_r8_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r11_r0),
    kInstruction_rev16_lt_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r4_r12),
    kInstruction_rev16_ge_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r5_r7),
    kInstruction_rev16_cc_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r3_r9),
    kInstruction_rev16_gt_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r11_r5),
    kInstruction_rev16_vc_r11_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r7_r1),
    kInstruction_rev16_lt_r7_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r1_r8),
    kInstruction_rev16_lt_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r11_r13),
    kInstruction_rev16_hi_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r10_r2),
    kInstruction_rev16_vs_r10_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r1_r10),
    kInstruction_rev16_ne_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r10_r0),
    kInstruction_rev16_vc_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r2_r2),
    kInstruction_rev16_al_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r7_r8),
    kInstruction_rev16_ne_r7_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r11_r14),
    kInstruction_rev16_hi_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r6_r14),
    kInstruction_rev16_ne_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r8_r5),
    kInstruction_rev16_ge_r8_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r7_r3),
    kInstruction_rev16_vs_r7_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r14_r13),
    kInstruction_rev16_ne_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r12_r11),
    kInstruction_rev16_hi_r12_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r11_r9),
    kInstruction_rev16_ls_r11_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r12_r7),
    kInstruction_rev16_mi_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r8_r8),
    kInstruction_rev16_cc_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r14_r12),
    kInstruction_rev16_ls_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r3_r6),
    kInstruction_rev16_ls_r3_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r7_r8),
    kInstruction_rev16_hi_r7_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r4_r10),
    kInstruction_rev16_vs_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r12_r1),
    kInstruction_rev16_ne_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r12_r4),
    kInstruction_rev16_vs_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r5_r5),
    kInstruction_rev16_hi_r5_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r8_r8),
    kInstruction_rev16_gt_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r10_r10),
    kInstruction_rev16_lt_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r13_r4),
    kInstruction_rev16_vs_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r8_r3),
    kInstruction_rev16_mi_r8_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r6_r13),
    kInstruction_rev16_eq_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r2_r0),
    kInstruction_rev16_al_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r6_r12),
    kInstruction_rev16_ls_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r1_r4),
    kInstruction_rev16_vs_r1_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r11_r1),
    kInstruction_rev16_vc_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r9_r10),
    kInstruction_rev16_ne_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r3_r10),
    kInstruction_rev16_ne_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r7_r10),
    kInstruction_rev16_hi_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r4_r10),
    kInstruction_rev16_pl_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r7_r1),
    kInstruction_rev16_le_r7_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r13_r10),
    kInstruction_rev16_gt_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r4_r14),
    kInstruction_rev16_lt_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r10_r1),
    kInstruction_rev16_al_r10_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r6_r12),
    kInstruction_rev16_mi_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r13_r9),
    kInstruction_rev16_eq_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r11_r4),
    kInstruction_rev16_ge_r11_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r1_r12),
    kInstruction_rev16_hi_r1_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r0_r1),
    kInstruction_rev16_ge_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r2_r3),
    kInstruction_rev16_lt_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r12_r9),
    kInstruction_rev16_al_r12_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r2_r10),
    kInstruction_rev16_hi_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r14_r11),
    kInstruction_rev16_mi_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r3_r10),
    kInstruction_rev16_pl_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r1_r6),
    kInstruction_rev16_vs_r1_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r7_r6),
    kInstruction_rev16_al_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r6_r8),
    kInstruction_rev16_ge_r6_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r3_r3),
    kInstruction_rev16_eq_r3_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r14_r4),
    kInstruction_rev16_ne_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r13_r10),
    kInstruction_rev16_vc_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r3_r12),
    kInstruction_rev16_mi_r3_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r9_r1),
    kInstruction_rev16_pl_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r14_r14),
    kInstruction_rev16_hi_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r0_r9),
    kInstruction_rev16_ne_r0_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r1_r1),
    kInstruction_rev16_mi_r1_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r7_r2),
    kInstruction_rev16_hi_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r2_r3),
    kInstruction_rev16_gt_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r2_r0),
    kInstruction_rev16_eq_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r10_r12),
    kInstruction_rev16_vs_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r11_r7),
    kInstruction_rev16_gt_r11_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r13_r2),
    kInstruction_rev16_vs_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r11_r12),
    kInstruction_rev16_ls_r11_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r8_r8),
    kInstruction_rev16_al_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r6_r10),
    kInstruction_rev16_hi_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r5_r1),
    kInstruction_rev16_vs_r5_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r0_r10),
    kInstruction_rev16_ls_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r0_r1),
    kInstruction_rev16_gt_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r11_r12),
    kInstruction_rev16_ne_r11_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r13_r5),
    kInstruction_rev16_ne_r13_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r0_r12),
    kInstruction_rev16_mi_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r11_r6),
    kInstruction_rev16_lt_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r11_r14),
    kInstruction_rev16_eq_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r11_r10),
    kInstruction_rev16_vc_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r3_r3),
    kInstruction_rev16_cs_r3_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r12_r2),
    kInstruction_rev16_le_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r13_r8),
    kInstruction_rev16_hi_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r6_r6),
    kInstruction_rev16_pl_r6_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r4_r5),
    kInstruction_rev16_al_r4_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r1_r0),
    kInstruction_rev16_hi_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r10_r11),
    kInstruction_rev16_ls_r10_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r8_r7),
    kInstruction_rev16_al_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r7_r1),
    kInstruction_rev16_vc_r7_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r7_r14),
    kInstruction_rev16_ne_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r5_r9),
    kInstruction_rev16_lt_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r13_r8),
    kInstruction_rev16_al_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r6_r14),
    kInstruction_rev16_ls_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r12_r0),
    kInstruction_rev16_eq_r12_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r8_r14),
    kInstruction_rev16_mi_r8_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r13_r2),
    kInstruction_rev16_hi_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r13_r2),
    kInstruction_rev16_al_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r8_r9),
    kInstruction_rev16_vs_r8_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r6_r2),
    kInstruction_rev16_cc_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r8_r0),
    kInstruction_rev16_lt_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r3_r13),
    kInstruction_rev16_ls_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r10_r14),
    kInstruction_rev16_gt_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r9_r8),
    kInstruction_rev16_pl_r9_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r14_r11),
    kInstruction_rev16_pl_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r9_r3),
    kInstruction_rev16_lt_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r9_r0),
    kInstruction_rev16_hi_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r9_r3),
    kInstruction_rev16_cc_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r10_r14),
    kInstruction_rev16_ge_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r2_r1),
    kInstruction_rev16_vs_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r4_r13),
    kInstruction_rev16_vc_r4_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r1_r9),
    kInstruction_rev16_ls_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r13_r11),
    kInstruction_rev16_lt_r13_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r2_r10),
    kInstruction_rev16_cs_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r0_r13),
    kInstruction_rev16_le_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r13_r11),
    kInstruction_rev16_al_r13_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r5_r2),
    kInstruction_rev16_eq_r5_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r5_r12),
    kInstruction_rev16_vs_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r12_r0),
    kInstruction_rev16_al_r12_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r13_r9),
    kInstruction_rev16_le_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r14_r4),
    kInstruction_rev16_cs_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r5_r7),
    kInstruction_rev16_ne_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r6_r6),
    kInstruction_rev16_al_r6_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r4_r8),
    kInstruction_rev16_gt_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r12_r8),
    kInstruction_rev16_gt_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r4_r12),
    kInstruction_rev16_eq_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r7_r13),
    kInstruction_rev16_cs_r7_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r2_r4),
    kInstruction_rev16_cs_r2_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r10_r3),
    kInstruction_rev16_al_r10_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r8_r9),
    kInstruction_rev16_cs_r8_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r1_r12),
    kInstruction_rev16_cs_r1_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r13_r0),
    kInstruction_rev16_gt_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r13_r12),
    kInstruction_rev16_vc_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r12_r14),
    kInstruction_rev16_lt_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r0_r1),
    kInstruction_rev16_lt_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r10_r2),
    kInstruction_rev16_cc_r10_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r3_r5),
    kInstruction_rev16_le_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r2_r11),
    kInstruction_rev16_eq_r2_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r12_r4),
    kInstruction_rev16_al_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r6_r5),
    kInstruction_rev16_cs_r6_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r13_r10),
    kInstruction_rev16_hi_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r4_r3),
    kInstruction_rev16_vs_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r7_r9),
    kInstruction_rev16_ls_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r14_r8),
    kInstruction_rev16_vs_r14_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r1_r0),
    kInstruction_rev16_cs_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r10_r8),
    kInstruction_rev16_mi_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r10_r4),
    kInstruction_rev16_ge_r10_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r5_r4),
    kInstruction_rev16_cc_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r0_r7),
    kInstruction_rev16_lt_r0_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r14_r10),
    kInstruction_rev16_mi_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r0_r14),
    kInstruction_rev16_mi_r0_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r14_r10),
    kInstruction_rev16_eq_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r4_r4),
    kInstruction_rev16_ls_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r14_r1),
    kInstruction_rev16_pl_r14_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r10_r8),
    kInstruction_rev16_eq_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r10_r6),
    kInstruction_rev16_cs_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r12_r2),
    kInstruction_rev16_al_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r12_r1),
    kInstruction_rev16_ls_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r12_r11),
    kInstruction_rev16_eq_r12_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r4_r1),
    kInstruction_rev16_vc_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r12_r2),
    kInstruction_rev16_vs_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r11_r8),
    kInstruction_rev16_al_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r6_r13),
    kInstruction_rev16_hi_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r2_r8),
    kInstruction_rev16_eq_r2_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r9_r5),
    kInstruction_rev16_cc_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r9_r7),
    kInstruction_rev16_cc_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r4_r6),
    kInstruction_rev16_lt_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r14_r13),
    kInstruction_rev16_cc_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r3_r2),
    kInstruction_rev16_vc_r3_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r6_r13),
    kInstruction_rev16_al_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r10_r10),
    kInstruction_rev16_vs_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r6_r10),
    kInstruction_rev16_cs_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r8_r12),
    kInstruction_rev16_cc_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r7_r5),
    kInstruction_rev16_vs_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r14_r10),
    kInstruction_rev16_pl_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r1_r14),
    kInstruction_rev16_hi_r1_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r8_r12),
    kInstruction_rev16_vc_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r2_r4),
    kInstruction_rev16_ls_r2_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r5_r12),
    kInstruction_rev16_mi_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r6_r12),
    kInstruction_rev16_eq_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r14_r9),
    kInstruction_rev16_lt_r14_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r11_r9),
    kInstruction_rev16_lt_r11_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r1_r9),
    kInstruction_rev16_ne_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r11_r8),
    kInstruction_rev16_pl_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r0_r6),
    kInstruction_rev16_ne_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r4_r4),
    kInstruction_rev16_vs_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r12_r9),
    kInstruction_rev16_ls_r12_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r9_r7),
    kInstruction_rev16_cs_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r7_r2),
    kInstruction_rev16_ne_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r9_r10),
    kInstruction_rev16_hi_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r5_r2),
    kInstruction_rev16_gt_r5_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r4_r6),
    kInstruction_rev16_pl_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r11_r8),
    kInstruction_rev16_lt_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r13_r4),
    kInstruction_rev16_hi_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r1_r10),
    kInstruction_rev16_le_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r11_r3),
    kInstruction_rev16_le_r11_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r0_r11),
    kInstruction_rev16_pl_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r7_r4),
    kInstruction_rev16_le_r7_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r2_r11),
    kInstruction_rev16_le_r2_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r1_r10),
    kInstruction_rev16_cc_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r13_r14),
    kInstruction_rev16_gt_r13_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r10_r6),
    kInstruction_rev16_ls_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r13_r4),
    kInstruction_rev16_ls_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r12_r13),
    kInstruction_rev16_gt_r12_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r13_r7),
    kInstruction_rev16_pl_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r14_r0),
    kInstruction_rev16_le_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r1_r4),
    kInstruction_rev16_gt_r1_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r3_r5),
    kInstruction_rev16_mi_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r4_r0),
    kInstruction_rev16_vc_r4_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r4_r11),
    kInstruction_rev16_gt_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r5_r3),
    kInstruction_rev16_vc_r5_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r4_r7),
    kInstruction_rev16_pl_r4_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r12_r6),
    kInstruction_rev16_al_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r2_r3),
    kInstruction_rev16_mi_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r12_r4),
    kInstruction_rev16_lt_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r10_r4),
    kInstruction_rev16_lt_r10_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r10_r8),
    kInstruction_rev16_hi_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r0_r14),
    kInstruction_rev16_al_r0_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r3_r3),
    kInstruction_rev16_cc_r3_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r10_r13),
    kInstruction_rev16_pl_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r7_r8),
    kInstruction_rev16_lt_r7_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r12_r7),
    kInstruction_rev16_le_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r11_r8),
    kInstruction_rev16_ge_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r10_r8),
    kInstruction_rev16_ls_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r9_r1),
    kInstruction_rev16_vs_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r10_r10),
    kInstruction_rev16_ne_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r6_r4),
    kInstruction_rev16_al_r6_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r10_r0),
    kInstruction_rev16_ls_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r7_r1),
    kInstruction_rev16_eq_r7_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r11_r6),
    kInstruction_rev16_al_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r5_r10),
    kInstruction_rev16_ge_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vs_r0_r8),
    kInstruction_rev16_vs_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r2_r1),
    kInstruction_rev16_lt_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r13_r2),
    kInstruction_rev16_le_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r13_r6),
    kInstruction_rev16_al_r13_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r12_r10),
    kInstruction_rev16_lt_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r13_r1),
    kInstruction_rev16_al_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r8_r14),
    kInstruction_rev16_ge_r8_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r11_r6),
    kInstruction_rev16_mi_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r12_r14),
    kInstruction_rev16_pl_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r14_r9),
    kInstruction_rev16_ne_r14_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r3_r1),
    kInstruction_rev16_cc_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r0_r8),
    kInstruction_rev16_ge_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r7_r9),
    kInstruction_rev16_vc_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r11_r4),
    kInstruction_rev16_gt_r11_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_mi_r4_r0),
    kInstruction_rev16_mi_r4_r0,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r3_r11),
    kInstruction_rev16_ls_r3_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r14_r5),
    kInstruction_rev16_le_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r6_r7),
    kInstruction_rev16_ls_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r4_r6),
    kInstruction_rev16_ne_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r1_r14),
    kInstruction_rev16_cc_r1_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r11_r7),
    kInstruction_rev16_pl_r11_r7,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r6_r5),
    kInstruction_rev16_vc_r6_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r1_r11),
    kInstruction_rev16_al_r1_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r2_r13),
    kInstruction_rev16_ne_r2_r13,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r14_r6),
    kInstruction_rev16_vc_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_gt_r3_r8),
    kInstruction_rev16_gt_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r1_r8),
    kInstruction_rev16_pl_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r2_r14),
    kInstruction_rev16_vc_r2_r14,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_pl_r12_r3),
    kInstruction_rev16_pl_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r0_r12),
    kInstruction_rev16_ls_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_le_r2_r1),
    kInstruction_rev16_le_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r13_r5),
    kInstruction_rev16_eq_r13_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r11_r11),
    kInstruction_rev16_al_r11_r11,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r9_r3),
    kInstruction_rev16_ls_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r7_r12),
    kInstruction_rev16_ne_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_al_r6_r2),
    kInstruction_rev16_al_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r7_r4),
    kInstruction_rev16_ne_r7_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r7_r5),
    kInstruction_rev16_vc_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ne_r7_r1),
    kInstruction_rev16_ne_r7_r1,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r5_r3),
    kInstruction_rev16_eq_r5_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cs_r3_r5),
    kInstruction_rev16_cs_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r7_r4),
    kInstruction_rev16_lt_r7_r4,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r4_r5),
    kInstruction_rev16_ls_r4_r5,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_eq_r11_r2),
    kInstruction_rev16_eq_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_hi_r2_r6),
    kInstruction_rev16_hi_r2_r6,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_vc_r2_r3),
    kInstruction_rev16_vc_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ls_r12_r12),
    kInstruction_rev16_ls_r12_r12,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_lt_r8_r2),
    kInstruction_rev16_lt_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_cc_r14_r8),
    kInstruction_rev16_cc_r14_r8,
  },
  {
    ARRAY_SIZE(kInstruction_rev16_ge_r12_r8),
    kInstruction_rev16_ge_r12_r8,
  },
};

#endif  // VIXL_ASSEMBLER_COND_RD_RN_REV16_A32_H_
