/*
 * test-gen.c - a test input generator for vfserver
 * by Hirotsugu Kakugawa
 *
 *   6 Aug 1997  Upgraded for VFlib 3.3
 */
/*
 * Copyright (C) 1996, 1997 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */


#include <stdio.h>
#include <stdlib.h>


void  usage(void);

int
main(int argc, char **argv)
{
  int   i, ch0, ch1, font_id;
  char  *font;
  double mag, point, dpi;

  argc--;
  argv++;

  font  = NULL;
  mag   = 1;
  point = -1;
  dpi   = -1;
  ch0   = 0x21;
  ch1   = 0x7e;
  font_id = 0;

  while ((argc > 0) && (*argv[0] == '-')){
    if (strcmp(argv[0], "-m") == 0){
      mag = atof(argv[1]); 
      argc--; argv++;
    } else if (strcmp(argv[0], "-p") == 0){
      point = atof(argv[1]); 
      argc--; argv++;
    } else if (strcmp(argv[0], "-d") == 0){
      dpi = atof(argv[1]); 
      argc--; argv++;
    } if ((strcmp(argv[0], "-h") == 0)|| (strcmp(argv[0], "-h") == 0)){
      usage();
    }
    argc--; argv++;
  }

  if (argc <= 0)
    usage();

  font = argv[0];
  if (argc == 2){
    sscanf(argv[1], "%i", &ch0);
    ch1 = ch0;
  } else if (argc >= 3) {
    sscanf(argv[1], "%i", &ch0);
    sscanf(argv[2], "%i", &ch1);
  }

  printf("COMMENT AN INPUT FOR VFSERVER GENERATED BY TEST-GEN.\n");
  printf("DEBUG BITMAP 1\n");
  printf("OPEN1 %s  %.2f  %.4f %.4f  %.2f %.2f\n", 
	 font, point, mag, mag, dpi, dpi);
  for (i = ch0; i <= ch1; i++){
    printf("BITMAP1 %d 0x%x\n", font_id, i);
  }
  printf("%s\n", "QUIT");

  return 0;
}


void 
usage(void)
{
  printf("test-gen - Generate an input for vfserver.\n");
  printf("Usage: test-gen [Options] FONT [CODE_POINT_FROM [CODE_POINT_TO]]\n");
  printf("Options: -m MAG      magnification\n");
  printf("         -p POINT    point size\n");
  printf("         -d DPI      device resolution in dpi\n");
  printf("         -h          print this.\n");
  printf("Example: test-gen timR24.pcf 0x21 0x7e | vfserver \n");
  printf("Example: test-gen timR24.pcf 0x31 | vfserver \n");
  printf("Example: test-gen jiskan16.bdf 0x4121 0x417e | vfserver \n");
  exit(0);
}

/*EOF*/
