//
// Copyright 2022 Ettus Research, A National Instruments Company
//
// SPDX-License-Identifier: LGPL-3.0-or-later
//
// Module: spi_regmap_utils.vh
// Description:
// The constants in this file are autogenerated by XmlParse.

//===============================================================================
// A numerically ordered list of registers and their HDL source files
//===============================================================================

  // RX_DATA_LOW   : 0x0 (ctrlport_to_spi.v)
  // RX_DATA_HIGH  : 0x4 (ctrlport_to_spi.v)
  // TX_DATA_LOW   : 0x8 (ctrlport_to_spi.v)
  // TX_DATA_HIGH  : 0xC (ctrlport_to_spi.v)
  // CONTROL       : 0x10 (ctrlport_to_spi.v)
  // CLOCK_DIVIDER : 0x14 (ctrlport_to_spi.v)
  // SLAVE_SELECT  : 0x18 (ctrlport_to_spi.v)

//===============================================================================
// RegTypes
//===============================================================================

//===============================================================================
// Register Group SPI_REGS
//===============================================================================

  // RX_DATA_LOW Register (from ctrlport_to_spi.v)
  localparam RX_DATA_LOW = 'h0; // Register Offset
  localparam RX_DATA_LOW_SIZE = 32;  // register width in bits
  localparam RX_DATA_LOW_MASK = 32'h0;

  // RX_DATA_HIGH Register (from ctrlport_to_spi.v)
  localparam RX_DATA_HIGH = 'h4; // Register Offset
  localparam RX_DATA_HIGH_SIZE = 32;  // register width in bits
  localparam RX_DATA_HIGH_MASK = 32'h0;

  // TX_DATA_LOW Register (from ctrlport_to_spi.v)
  localparam TX_DATA_LOW = 'h8; // Register Offset
  localparam TX_DATA_LOW_SIZE = 32;  // register width in bits
  localparam TX_DATA_LOW_MASK = 32'h0;

  // TX_DATA_HIGH Register (from ctrlport_to_spi.v)
  localparam TX_DATA_HIGH = 'hC; // Register Offset
  localparam TX_DATA_HIGH_SIZE = 32;  // register width in bits
  localparam TX_DATA_HIGH_MASK = 32'h0;

  // CONTROL Register (from ctrlport_to_spi.v)
  localparam CONTROL = 'h10; // Register Offset
  localparam CONTROL_SIZE = 32;  // register width in bits
  localparam CONTROL_MASK = 32'h0;

  // CLOCK_DIVIDER Register (from ctrlport_to_spi.v)
  localparam CLOCK_DIVIDER = 'h14; // Register Offset
  localparam CLOCK_DIVIDER_SIZE = 8;  // register width in bits
  localparam CLOCK_DIVIDER_MASK = 8'hFF;
  localparam DIVIDER_SIZE = 8;  //CLOCK_DIVIDER:Divider
  localparam DIVIDER_MSB  = 7;  //CLOCK_DIVIDER:Divider
  localparam DIVIDER      = 0;  //CLOCK_DIVIDER:Divider

  // SLAVE_SELECT Register (from ctrlport_to_spi.v)
  localparam SLAVE_SELECT = 'h18; // Register Offset
  localparam SLAVE_SELECT_SIZE = 16;  // register width in bits
  localparam SLAVE_SELECT_MASK = 16'hFFFF;
  localparam SS_SIZE = 16;  //SLAVE_SELECT:SS
  localparam SS_MSB  = 15;  //SLAVE_SELECT:SS
  localparam SS      =  0;  //SLAVE_SELECT:SS
