/* Siconos is a program dedicated to modeling, simulation and control
 * of non smooth dynamical systems.
 *
 * Copyright 2021 INRIA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/



#ifndef NUMERICSMATRIX_TEST_FUNCTION_H
#define NUMERICSMATRIX_TEST_FUNCTION_H

#include "NumericsFwd.h"    // for NumericsMatrix, SparseBlockStructuredMatrix
#include "SiconosConfig.h" // for BUILD_AS_CPP // IWYU pragma: keep


#if defined(__cplusplus) && !defined(BUILD_AS_CPP)
extern "C"
{
#endif
  NumericsMatrix * test_matrix_1(void);
  NumericsMatrix * test_matrix_2(void);
  NumericsMatrix * test_matrix_3(void);
  NumericsMatrix * test_matrix_4(void);
  NumericsMatrix * test_matrix_5(void);
  NumericsMatrix * test_matrix_6(void);
  
  NumericsMatrix * test_matrix_9(void);
  NumericsMatrix * test_matrix_10(void);
  NumericsMatrix * test_matrix_20(void);
  
  int SBM_dense_equal(SparseBlockStructuredMatrix * M, double * m, double tol);
  int NM_dense_equal(NumericsMatrix * M, double * m, double tol);
  int test_build_first_4_NM(NumericsMatrix** MM);

  
  int test_SBM_row_to_dense(SparseBlockStructuredMatrix *M);
  int test_SBM_row_permutation(SparseBlockStructuredMatrix *M);
  int test_SBM_column_permutation(SparseBlockStructuredMatrix *M);
#if defined(__cplusplus) && !defined(BUILD_AS_CPP)
}
#endif

#endif


