% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adverb-quietly.R
\name{quietly}
\alias{quietly}
\title{Wrap a function to capture side-effects}
\usage{
quietly(.f)
}
\arguments{
\item{.f}{A function to modify, specified in one of the following ways:
\itemize{
\item A named function, e.g. \code{mean}.
\item An anonymous function, e.g. \verb{\\(x) x + 1} or \code{function(x) x + 1}.
\item A formula, e.g. \code{~ .x + 1}. Only recommended if you require backward
compatibility with older versions of R.
}}
}
\value{
A function that takes the same arguments as \code{.f}, but returns
a different value, as described above.
}
\description{
Create a modified version of \code{.f} that captures side-effects along with
the return value of the function and returns a list containing
the \code{result}, \code{output}, \code{messages} and \code{warnings}.
}
\section{Adverbs}{
This function is called an adverb because it modifies the effect of a
function (a verb). If you'd like to include a function created an adverb
in a package, be sure to read \link{faq-adverbs-export}.
}

\examples{
f <- function() {
  print("Hi!")
  message("Hello")
  warning("How are ya?")
  "Gidday"
}
f()

f_quiet <- quietly(f)
str(f_quiet())
}
\seealso{
Other adverbs: 
\code{\link{auto_browse}()},
\code{\link{compose}()},
\code{\link{insistently}()},
\code{\link{negate}()},
\code{\link{partial}()},
\code{\link{possibly}()},
\code{\link{safely}()},
\code{\link{slowly}()}
}
\concept{adverbs}
