% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_ggplot_grob.R
\name{wrap_ggplot_grob}
\alias{wrap_ggplot_grob}
\title{Make a gtable created from a ggplot object patchwork compliant}
\usage{
wrap_ggplot_grob(x)
}
\arguments{
\item{x}{A gtable as produced by \code{\link[ggplot2:ggplotGrob]{ggplot2::ggplotGrob()}}}
}
\value{
A \code{table_patch} object to be added to a patchwork
}
\description{
This function converts a gtable, as produced by \code{\link[ggplot2:ggplotGrob]{ggplot2::ggplotGrob()}} and
makes it ready to be added to a patchwork. In contrast to passing
the gtable to \code{\link[=wrap_elements]{wrap_elements()}}, \code{wrap_ggplot_grob()} ensures proper
alignment as expected. On the other hand major restructuring of the gtable
will result in an object that doesn't work properly with
\code{wrap_ggplot_grob()}.
}
\examples{
library(grid)
library(gtable)
library(ggplot2)

p1 <- ggplot(mtcars) + geom_point(aes(mpg, disp)) + ggtitle('disp and mpg seems connected')
p2 <- ggplot(mtcars) + geom_boxplot(aes(gear, disp, group = gear))

# Convert p2 so we can add new stuff to it
p2_table <- ggplotGrob(p2)
stamp <- textGrob('TOP SECRET', rot = 35,
  gp = gpar(fontsize = 72, fontface = 'bold')
)
p2_table <- gtable_add_grob(p2_table, stamp,
  t = 1, l = 1, b = nrow(p2_table), r = ncol(p2_table)
)

# Adding it directly will loose alignment
p1 + p2_table

# Use wrap_ggplot_grob to keep alignment
p1 + wrap_ggplot_grob(p2_table)

}
