% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compatibility.R
\name{getResiduals}
\alias{getResiduals}
\alias{getResiduals.default}
\alias{getResiduals.MixMod}
\title{Get model residuals}
\usage{
getResiduals(object, ...)

\method{getResiduals}{default}(object, ...)

\method{getResiduals}{MixMod}(object, ...)
}
\arguments{
\item{object}{a fitted model.}

\item{...}{additional parameters to be passed on, usually to the residual function of the respective model class.}
}
\description{
Wrapper to get the residuals of a fitted model.
}
\details{
The purpose of this wrapper is to standardize the extraction of model residuals. Similar to some other functions, a key question is whether to calculate those conditional or unconditional on the fitted Random Effects.
}
\examples{
testData = createData(sampleSize = 400, family = gaussian())

fittedModel <- lm(observedResponse ~ Environment1 , data = testData)

# response that was used to fit the model
getObservedResponse(fittedModel)

# predictions of the model for these points
getFitted(fittedModel)

# extract simulations from the model as matrix
getSimulations(fittedModel, nsim = 2)

# extract simulations from the model for refit (often requires different structure)
x = getSimulations(fittedModel, nsim = 2, type = "refit")

getRefit(fittedModel, x[[1]])

getRefit(fittedModel, getObservedResponse(fittedModel))
}
\seealso{
\link{getObservedResponse}, \link{getSimulations}, \link{getRefit}, \link{getFixedEffects}, \link{getFitted}
}
\author{
Florian Hartig
}
