"""Constants for Profile resources."""

from enum import IntEnum


class ResourceObjectType(IntEnum):
    """Enum class for Resource Object Types."""

    OBJECT_DEVICE = 0x0000
    OBJECT_ADDRESS_TABLE = 0x0001
    OBJECT_ASSOCIATION_TABLE = 0x0002
    OBJECT_APPLICATION_PROGRAM = 0x0003
    OBJECT_INTERFACE_PROGRAM = 0x0004
    OBJECT_KNX_OBJECT_ASSOCIATION_TABLE = 0x0005
    OBJECT_ROUTER = 0x0006
    OBJECT_LTE_ADDRESS_ROUTING_TABLE = 0x0007
    OBJECT_CEMI_SERVER = 0x0008
    OBJECT_GROUP_OBJECT_TABLE = 0x0009
    OBJECT_POLLING_MASTER = 0x000A
    OBJECT_KNXNETIP_PARAMETER = 0x000B
    OBJECT_FILESERVER = 0x000D
    OBJECT_E_MODE_CHANNEL = 0x000E
    OBJECT_ADJUSTED_E_MODE_CHANNEL = 0x000F
    OBJECT_TEXT_CATALOGUE = 0x0010
    OBJECT_SECURITY = 0x0011
    OBJECT_E_MODE_DEVICE = 0x0012
    OBJECT_RF_MEDIUM_OBJECT = 0x0013


ResourcePropertyId = IntEnum


class ResourceGenericPropertyId(ResourcePropertyId):
    """Enum base class for Property Ids."""

    PID_OBJECT_TYPE = 1  # PDT_UNSIGNED_INT
    PID_OBJECT_NAME = 2  # PDT_UNSIGNED_CHAR[]
    PID_SEMAPHOR = 3
    PID_GROUP_OBJECT_REFERENCE = 4
    PID_LOAD_STATE_CONTROL = 5  # PDT_CONTROL
    PID_RUN_STATE_CONTROL = 6  # PDT_CONTROL
    PID_TABLE_REFERENCE = 7  # PDT_UNSIGNED_LONG
    PID_SERVICE_CONTROL = 8  # PDT_UNSIGNED_INT
    PID_FIRMWARE_REVISION = 9  # PDT_UNSIGNED_CHAR
    PID_SERVICES_SUPPORTED = 10
    PID_SERIAL_NUMBER = 11  # PDT_GENERIC_06
    PID_MANUFACTURER_ID = 12  # PDT_UNSIGNED_INT
    PID_PROGRAM_VERSION = 13  # PDT_GENERIC_05
    PID_DEVICE_CONTROL = 14  # PDT_BITSET8/PDT_GENERIC_01
    PID_ORDER_INFO = 15  # PDT_GENERIC_10
    PID_PEI_TYPE = 16  # PDT_UNSIGNED_CHAR
    PID_PORT_CONFIGURATION = 17  # PDT_UNSIGNED_CHAR
    PID_POLL_GROUP_SETTINGS = 18  # PDT_POLL_GROUP_SETTINGS
    PID_MANUFACTURER_DATA = 19  # PDT_GENERIC_04
    PID_ENABLE = 20
    PID_DESCRIPTION = 21  # PDT_UNSIGNED_CHAR[]
    PID_TABLE = 23
    PID_ENROL = 24  # PDT_FUNCTION
    PID_VERSION = 25  # PDT_VERSION/PDT_GENERIC_02
    PID_GROUP_OBJECT_LINK = 26  # PDT_FUNCTION
    PID_MCB_TABLE = 27  # PDT_GENERIC_08[]
    PID_ERROR_CODE = 28  # PDT_ENUM8/PDT_UNSIGNED_CHAR
    PID_OBJECT_INDEX = 29  # PDT_UNSIGNED_CHAR
    PID_DOWNLOAD_COUNTER = 30  # PDT_UNSIGNED_INT


class ResourceDevicePropertyId(ResourcePropertyId):
    """Extended class for Device Object (Type 0) Property Ids."""

    PID_ROUTING_COUNT = 51  # PDT_UNSIGNED_CHAR
    PID_MAX_RETRY_COUNT = 52  # PDT_GENERIC_01
    PID_ERROR_FLAGS = 53  # PDT_UNSIGNED_CHAR
    PID_PROGMODE = 54  # PDT_GENERIC_01
    PID_PRODUCT_ID = 55  # PDT_GENERIC_10
    PID_MAX_APDU_LENGTH = 56  # PDT_UNSIGNED_INT
    PID_SUBNET_ADDR = 57  # PDT_UNSIGNED_CHAR
    PID_DEVICE_ADDR = 58  # PDT_UNSIGNED_CHAR
    PID_PB_CONFIG = 59  # PDT_GENERIC_04
    PID_ADDR_REPORT = 60  # PDT_GENERIC_06
    PID_ADDR_CHECK = 61  # PDT_GENERIC_01
    PID_OBJECT_VALUE = 62  # PDT_FUNCTION
    PID_OBJECTLINK = 63  # PDT_FUNCTION
    PID_APPLICATION = 64  # PDT_FUNCTION
    PID_PARAMETER = 65  # PDT_FUNCTION
    PID_OBJECTADDRESS = 66  # PDT_FUNCTION
    PID_PSU_TYPE = 67  # PDT_UNSIGNED_INT
    PID_PSU_STATUS = 68  # PDT_BINARY_INFORMATION
    PID_PSU_ENABLE = 69  # PDT_ENUM8
    PID_DOMAIN_ADDRESS = 70  # PDT_UNSIGNED_INT
    PID_IO_LIST = 71  # PDT_UNSIGNED_INT
    PID_MGT_DESCRIPTOR_01 = 72  # PDT_GENERIC_10
    PID_PL110_PARAM = 73  # PDT_GENERIC_01
    PID_RF_REPEAT_COUNTER = 74  # PDT_UNSIGNED_CHAR
    PID_RECEIVE_BLOCK_TABLE = 75  # PDT_UNSIGNED_CHAR[16]
    PID_RANDOM_PAUSE_TABLE = 76  # PDT_UNSIGNED_CHAR[12]
    PID_RECEIVE_BLOCK_NR = 77  # PDT_UNSIGNED_CHAR
    PID_HARDWARE_TYPE = 78  # PDT_GENERIC_06
    PID_RETRANSMITTER_NUMBER = 79  # PDT_UNSIGNED_CHAR
    PID_SERIAL_NR_TABLE = 80  # PDT_GENERIC_06[]
    PID_BIBAT_MASTER_ADDRESS = 81  # PDT_UNSIGNED_INT
    PID_RF_DOMAIN_ADDRESS = 82  # PDT_GENERIC_06
    PID_DEVICE_DESCRIPTOR = 83  # PDT_GENERIC_02
    PID_METERING_FILTER_TABLE = 84  # PDT_GENERIC_08[]
    PID_GROUP_TELEGR_RATE_LIMIT_TIME_BASE = 85  # PDT_UNSIGNED_INT
    PID_GROUP_TELEGR_RATE_LIMIT_NO_OF_TELEGR = 86  # PDT_UNSIGNED_INT
    PID_FEATURES_SUPPORTED = 89  # PDT_GENERIC_10
    PID_CHANNEL_01_PARAM = 101  # PDT_GENERIC_01[]
    PID_CHANNEL_02_PARAM = 102  # PDT_GENERIC_01[]
    PID_CHANNEL_03_PARAM = 103  # PDT_GENERIC_01[]
    PID_CHANNEL_04_PARAM = 104  # PDT_GENERIC_01[]
    PID_CHANNEL_05_PARAM = 105  # PDT_GENERIC_01[]
    PID_CHANNEL_06_PARAM = 106  # PDT_GENERIC_01[]
    PID_CHANNEL_07_PARAM = 107  # PDT_GENERIC_01[]
    PID_CHANNEL_08_PARAM = 108  # PDT_GENERIC_01[]
    PID_CHANNEL_09_PARAM = 109  # PDT_GENERIC_01[]
    PID_CHANNEL_10_PARAM = 110  # PDT_GENERIC_01[]
    PID_CHANNEL_11_PARAM = 111  # PDT_GENERIC_01[]
    PID_CHANNEL_12_PARAM = 112  # PDT_GENERIC_01[]
    PID_CHANNEL_13_PARAM = 113  # PDT_GENERIC_01[]
    PID_CHANNEL_14_PARAM = 114  # PDT_GENERIC_01[]
    PID_CHANNEL_15_PARAM = 115  # PDT_GENERIC_01[]
    PID_CHANNEL_16_PARAM = 116  # PDT_GENERIC_01[]
    PID_CHANNEL_17_PARAM = 117  # PDT_GENERIC_01[]
    PID_CHANNEL_18_PARAM = 118  # PDT_GENERIC_01[]
    PID_CHANNEL_19_PARAM = 119  # PDT_GENERIC_01[]
    PID_CHANNEL_20_PARAM = 120  # PDT_GENERIC_01[]
    PID_CHANNEL_21_PARAM = 121  # PDT_GENERIC_01[]
    PID_CHANNEL_22_PARAM = 122  # PDT_GENERIC_01[]
    PID_CHANNEL_23_PARAM = 123  # PDT_GENERIC_01[]
    PID_CHANNEL_24_PARAM = 124  # PDT_GENERIC_01[]
    PID_CHANNEL_25_PARAM = 125  # PDT_GENERIC_01[]
    PID_CHANNEL_26_PARAM = 126  # PDT_GENERIC_01[]
    PID_CHANNEL_27_PARAM = 127  # PDT_GENERIC_01[]
    PID_CHANNEL_28_PARAM = 128  # PDT_GENERIC_01[]
    PID_CHANNEL_29_PARAM = 129  # PDT_GENERIC_01[]
    PID_CHANNEL_30_PARAM = 130  # PDT_GENERIC_01[]
    PID_CHANNEL_31_PARAM = 131  # PDT_GENERIC_01[]
    PID_CHANNEL_32_PARAM = 132  # PDT_GENERIC_01[]


class ResourceProgramPropertyId(ResourcePropertyId):
    """Extended class for Program Object (Type 3 & 4) Property Ids."""

    PID_OPERATION_MODE = 51  # PDT_FUNCTION/PDT_VARIABLE_LENGTH


class ResourceRouterPropertyId(ResourcePropertyId):
    """Extended class for Router Object (Type 6) Property Ids."""

    PID_MEDIUM_STATUS = 51  # PDT_GENERIC_01
    PID_MAIN_LCCONFIG = 52
    PID_SUB_LCCONFIG = 53
    PID_MAIN_LCGRPCONFIG = 54
    PID_SUB_LCGRPCONFIG = 55
    PID_ROUTETABLE_CONTROL = 56
    PID_COUPL_SERV_CONTROL = 57
    PID_MAX_APDU_LENGTH_ROUTER = 58  # PDT_UNSIGNED_INT
    PID_L2_COUPLER_TYPE = 59  # PDT_BITSET8
    PID_HOP_COUNT = 61  # PDT_UNSIGNED_INT
    PID_MEDIUM = 63  # PDT_ENUM8
    PID_FILTER_TABLE_USE = 67  # PDT_BINARY_INFORMATION
    PID_PL110_SBC_CONTROL = 104  # PDT_FUNCTION
    PID_RF_SBC_CONTROL = 112  # PDT_FUNCTION
    PID_IP_SBC_CONTROL = 120  # PDT_FUNCTION


class ResourceLTERoutingTablePropertyId(ResourcePropertyId):
    """Extended class for LTE Address Routing Table Object (Object Type 7) Property Ids."""

    PID_LTE_ROUTESELECT = 51
    PID_LTE_ROUTETABLE = 52  # PDT_GENERIC_05


class ResourceCEMIServerPropertyId(ResourcePropertyId):
    """Extended class for cEMI Server Object (Object Type 8) Property Ids."""

    PID_MEDIUM_TYPE = 51  # PDT_BITSET16
    PID_COMM_MODE = 52  # PDT_ENUM8
    PID_MEDIUM_AVAILABILITY = 53  # PDT_BITSET16
    PID_ADD_INFO_TYPES = 54  # PDT_ENUM8[]
    PID_TIME_BASE = 55  # PDT_UNSIGNED_INT
    PID_TRANSP_ENABLE = 56  # PDT_BINARY_INFORMATION
    PID_CEMI_SERVER_DEVICE_ADDRESS = 58  # PDT_UNSIGNED_CHAR
    PID_BIBAT_NEXTBLOCK = 59  # PDT_UNSIGNED_CHAR
    PID_RF_MODE_SELECT = 60  # PDT_ENUM8/PDT_UNSIGNED_CHAR
    PID_RF_MODE_SUPPORT = 61  # PDT_BITSET8/PDT_GENERIC_01
    PID_RF_FILTERING_MODE_SELECT = 62  # PDT_ENUM8/PDT_UNSIGNED_CHAR
    PID_RF_FILTERING_MODE_SUPPORT = 63  # PDT_BITSET8/PDT_GENERIC_01
    PID_COMM_MODES_SUPPORTED = 64  # PDT_BITSET16
    PID_FILTERING_MODE_SUPPORT = 65  # PDT_BITSET16/PDT_GENERIC_02
    PID_FILTERING_MODE_SELECT = 66  # PDT_BITSET16/PDT_GENERIC_02
    PID_MAX_INTERFACE_APDU_LENGTH = 68  # PDT_UNSIGNED_INT
    PID_MAX_LOCAL_APDU_LENGTH = 69  # PDT_UNSIGNED_INT


class ResourceGroupObjectTablePropertyId(ResourcePropertyId):
    """Extended class for Group Object Table Object (Object Type 9) Property Ids."""

    PID_GO_DIAGNOSTICS = 66  # PDT_FUNCTION


class ResourcePollingMasterInterfacePropertyId(ResourcePropertyId):
    """Extended class for Polling Master Interface Object (Object Type 10) Property Ids."""

    PID_POLLING_STATE = 51
    PID_POLLING_SLAVE_ADDR = 52
    PID_POLL_CYCLE = 53


class ResourceKNXNETIPPropertyId(ResourcePropertyId):
    """Extended class for KNXNet/IP Object (Object Type 11) Property Ids."""

    PID_PROJECT_INSTALLATION_ID = 51  # PDT_UNSIGNED_INT
    PID_KNX_INDIVIDUAL_ADDRESS = 52  # PDT_UNSIGNED_INT
    PID_ADDITIONAL_INDIVIDUAL_ADDRESSES = 53  # PDT_UNSIGNED_INT[]
    PID_CURRENT_IP_ASSIGNMENT_METHOD = 54  # PDT_UNSIGNED_CHAR
    PID_IP_ASSIGNMENT_METHOD = 55  # PDT_UNSIGNED_CHAR
    PID_IP_CAPABILITIES = 56  # PDT_BITSET8
    PID_CURRENT_IP_ADDRESS = 57  # PDT_UNSIGNED_LONG
    PID_CURRENT_SUBNET_MASK = 58  # PDT_UNSIGNED_LONG
    PID_CURRENT_DEFAULT_GATEWAY = 59  # PDT_UNSIGNED_LONG
    PID_IP_ADDRESS = 60  # PDT_UNSIGNED_LONG
    PID_SUBNET_MASK = 61  # PDT_UNSIGNED_LONG
    PID_DEFAULT_GATEWAY = 62  # PDT_UNSIGNED_LONG
    PID_DHCP_BOOTP_SERVER = 63  # PDT_UNSIGNED_LONG
    PID_MAC_ADDRESS = 64  # PDT_GENERIC_06
    PID_SYSTEM_SETUP_MULTICAST_ADDRESS = 65  # PDT_UNSIGNED_LONG
    PID_ROUTING_MULTICAST_ADDRESS = 66  # PDT_UNSIGNED_LONG
    PID_TTL = 67  # PDT_UNSIGNED_CHAR
    PID_KNXNETIP_DEVICE_CAPABILITIES = 68  # PDT_BITSET16
    PID_KNXNETIP_DEVICE_STATE = 69  # PDT_UNSIGNED_CHAR
    PID_KNXNETIP_ROUTING_CAPABILITIES = 70  # PDT_UNSIGNED_CHAR
    PID_PRIORITY_FIFO_ENABLED = 71  # PDT_BINARY_INFORMATION
    PID_QUEUE_OVERFLOW_TO_IP = 72  # PDT_UNSIGNED_INT
    PID_QUEUE_OVERFLOW_TO_KNX = 73  # PDT_UNSIGNED_INT
    PID_MSG_TRANSMIT_TO_IP = 74  # PDT_UNSIGNED_LONG
    PID_MSG_TRANSMIT_TO_KNX = 75  # PDT_UNSIGNED_LONG
    PID_FRIENDLY_NAME = 76  # PDT_UNSIGNED_CHAR[30]
    PID_ROUTING_BUSY_WAIT_TIME = 78  # PDT_UNSIGNED_INT
    PID_TUNNELLING_ADDRESSES = 79  # PDT_UNSIGNED_CHAR[]


class ResourceEModeChannelPropertyId(ResourcePropertyId):
    """Extended class for E-Mode Channel Object (Object Type 14 & 15) Property Ids."""

    PID_CHAN_NUMBER = 51  # PDT_UNSIGNED_INT
    PID_CHAN_CODE = 52  # PDT_UNSIGNED_INT
    PID_CHAN_FLAGS = 53  # PDT_GENERIC_02
    PID_CHAN_FB_LIST = 54  # PDT_UNSIGNED_INT[]
    PID_CHAN_ADJ_LISTS = 55  # PDT_UNSIGNED_CHAR[]
    PID_GO_CCODES_LIST = 61  # PDT_GENERIC_08[]
    PID_GO_CFLAGS_LIST = 62  # PDT_BITSET16[]
    PID_OBJECTLINK = 63  # PDT_FUNCTION
    PID_GO_SUBUNIT = 64  # PDT_UNSIGNED_CHAR[]
    PID_GO_NAME_LIST = 65  # PDT_GENERIC_10[]/PDT_REFERENCE[]
    PID_GO_DIAGNOSTICS = 66  # PDT_FUNCTION
    PID_PARAM_TYPES = 70  # PDT_GENERIC_10[]
    PID_PARAM_FLAGS = 71  # PDT_BITSET16[]
    PID_PARAM_NAMES = 72  # PDT_GENERIC_10[]/PDT_REFERENCE[]
    PID_PARAM_UNITS = 73  # PDT_GENERIC_10[]/PDT_REFERENCE[]
    PID_PARAM_VALUES = (
        79  # PDT_GENERIC_01[]/PDT_GENERIC_02[]/PDT_GENERIC_04[]/PDT_GENERIC_010[]
    )


class ResourceTextCataloguePropertyId(ResourcePropertyId):
    """Extended class for Text Catalogue Object (Object Type 16) Property Ids."""

    PID_LOCALE_LIST = 51  # PDT_GENERIC_04[]
    PID_LOCALE_SELECTION = 52  # PDT_GENERIC_04
    PID_ACTIVE_LOCALE = 53  # PDT_GENERIC_04
    # PID_STRING_001 to PID_STRING_141 is [60-200]
    PID_STRING_001 = 60  # PDT_UTF_8


class ResourceSecureInterfacePropertyId(ResourcePropertyId):
    """Extended class for Secure Interface Object (Object Type 17) Property Ids."""

    PID_SECURITY_MODE = 51  # PDT_FUNCTION
    PID_P2P_KEY_TABLE = 52  # PDT_GENERIC_20[]
    PID_GRP_KEY_TABLE = 53  # PDT_GENERIC_18[]
    PID_SECURITY_INDIVIDUAL_ADDRESS_TABLE = 54  # PDT_GENERIC_08[]
    PID_SECURITY_FAILURES_LOG = 55  # PDT_FUNCTION
    PID_TOOL_KEY = 56  # PDT_GENERIC_16
    PID_SECURITY_REPORT = 57  # PDT_BITSET8
    PID_SECURITY_REPORT_CONTROL = 58  # PDT_BINARY_INFORMATION
    PID_SEQUENCE_NUMBER_SENDING = 59  # PDT_GENERIC_06
    PID_ZONE_KEY_TABLE = 60  # PDT_GENERIC_19[]
    PID_GO_SECURITY_FLAGS = 61  # PDT_GENERIC_01[]


class ResourceEModeDevicePropertyId(ResourcePropertyId):
    """Extended class for E-Mode Device Object (Object Type 18) Property Ids."""

    PID_LOCALISATION_MODE = 60  # PDT_BINARY_INFORMATION/PDT_UNSIGNED_CHAR
    PID_LOCALISATION_REPORT = 61  # PDT_UNSIGNED_INT
    PID_LOCALISATION_COMMAND = 62  # PDT_GENERIC_03


class ResourceRFMediumPropertyId(ResourcePropertyId):
    """Extended class for RF Medium Object (Object Type 19) Property Ids."""

    PID_RF_MULTI_TYPE = 51  # PDT_BITSET8
    PID_RF_MULTI_PHYSICAL_FEATURES = 52  # PDT_BITSET8
    PID_RF_MULTI_CALL_CHANNEL = 53  # PDT_GENERIC_01
    PID_RF_MULTI_OBJECT_LINK = 54  # PDT_FUNCTION
    PID_RF_MULTI_EXT_GA_REPEATED = 55  # PDT_FUNCTION
    PID_RF_RETRANSMITTER = 57  # PDT_BINARY_INFORMATION
    PID_RF_BIDIR_TIMEOUT = 60  # PDT_FUNCTION
    PID_RF_DIAG_SA_FILTER_TABLE = 61  # PDT_GENERIC_03[]
    PID_RF_DIAG_QUALITY_TABLE = 62  # PDT_GENERIC_04[]
    PID_RF_DIAG_PROBE = 63  # PDT_FUNCTION
    PID_TRANSMISSION_MODE = 70  # PDT_ENUM8
    PID_RECEPTION_MODE = 71  # PDT_ENUM8
    PID_TEST_SIGNAL = 72  # PDT_GENERIC_02
    PID_FAST_ACK = 73  # PDT_GENERIC_02[]
    PID_FAST_ACK_ACTIVATE = 74  # PDT_BINARY_INFORMATION
    PID_RF_TYPES_SUPPORTED = 75  # PDT_BITSET8/PDT_GENERIC_01
