/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import java.io.Serializable;
import weka.classifiers.evaluation.Prediction;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class NumericPrediction
implements Prediction,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = -4880216423674233887L;
    private double m_Actual = MISSING_VALUE;
    private double m_Predicted = MISSING_VALUE;
    private double m_Weight = 1.0;

    public NumericPrediction(double actual, double predicted) {
        this(actual, predicted, 1.0);
    }

    public NumericPrediction(double actual, double predicted, double weight) {
        this.m_Actual = actual;
        this.m_Predicted = predicted;
        this.m_Weight = weight;
    }

    public double actual() {
        return this.m_Actual;
    }

    public double predicted() {
        return this.m_Predicted;
    }

    public double weight() {
        return this.m_Weight;
    }

    public double error() {
        if (this.m_Actual == MISSING_VALUE || this.m_Predicted == MISSING_VALUE) {
            return MISSING_VALUE;
        }
        return this.m_Predicted - this.m_Actual;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("NUM: ").append(this.actual()).append(' ').append(this.predicted());
        sb.append(' ').append(this.weight());
        return sb.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.9 $");
    }
}

