(* a quick and dirty rfc 2255 ldap url lexer for referral processing Will
   only parse a subset of the ldapurl

   Copyright (C) 2004 Eric Stokes, and The California State University
   at Northridge

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)

open Ldap_urllexer

exception Invalid_ldap_url of int * string

let of_string s =
  let lx = Lexing.from_string s in
    try lexurl lx
    with
        Failure "lexing: empty token" ->
          raise (Invalid_ldap_url (lx.Lexing.lex_last_pos, "syntax error"))
      | exn ->
          raise (Invalid_ldap_url (lx.Lexing.lex_last_pos, Printexc.to_string exn))
