# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class ByteSwap(Object):
    r"""
    ByteSwap - perform machine dependent byte swapping
    
    Superclass: Object
    
    ByteSwap is used by other classes to perform machine dependent
    byte swapping. Byte swapping is often used when reading or writing
    binary files.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkByteSwap, obj, update, **traits)
    
    def swap2_be(self, *args):
        """
        swap2_be(p:Pointer) -> None
        C++: static void swap2_be(void *p)
        Swap 2, 4, or 8 bytes for storage as Big Endian.
        """
        ret = self._wrap_call(self._vtk_obj.Swap2BE, *args)
        return ret

    def swap2_be_range(self, *args):
        """
        swap2_be_range(p:Pointer, num:int) -> None
        C++: static void swap2_be_range(void *p, size_t num)
        Swap a block of 2-, 4-, or 8-byte segments for storage as Big
        Endian.
        """
        ret = self._wrap_call(self._vtk_obj.Swap2BERange, *args)
        return ret

    def swap2_le(self, *args):
        """
        swap2_le(p:Pointer) -> None
        C++: static void swap2_le(void *p)
        Swap 2, 4, or 8 bytes for storage as Little Endian.
        """
        ret = self._wrap_call(self._vtk_obj.Swap2LE, *args)
        return ret

    def swap2_le_range(self, *args):
        """
        swap2_le_range(p:Pointer, num:int) -> None
        C++: static void swap2_le_range(void *p, size_t num)
        Swap a block of 2-, 4-, or 8-byte segments for storage as Little
        Endian.
        """
        ret = self._wrap_call(self._vtk_obj.Swap2LERange, *args)
        return ret

    def swap4_be(self, *args):
        """
        swap4_be(p:Pointer) -> None
        C++: static void swap4_be(void *p)"""
        ret = self._wrap_call(self._vtk_obj.Swap4BE, *args)
        return ret

    def swap4_be_range(self, *args):
        """
        swap4_be_range(p:Pointer, num:int) -> None
        C++: static void swap4_be_range(void *p, size_t num)"""
        ret = self._wrap_call(self._vtk_obj.Swap4BERange, *args)
        return ret

    def swap4_le(self, *args):
        """
        swap4_le(p:Pointer) -> None
        C++: static void swap4_le(void *p)"""
        ret = self._wrap_call(self._vtk_obj.Swap4LE, *args)
        return ret

    def swap4_le_range(self, *args):
        """
        swap4_le_range(p:Pointer, num:int) -> None
        C++: static void swap4_le_range(void *p, size_t num)"""
        ret = self._wrap_call(self._vtk_obj.Swap4LERange, *args)
        return ret

    def swap8_be(self, *args):
        """
        swap8_be(p:Pointer) -> None
        C++: static void swap8_be(void *p)"""
        ret = self._wrap_call(self._vtk_obj.Swap8BE, *args)
        return ret

    def swap8_be_range(self, *args):
        """
        swap8_be_range(p:Pointer, num:int) -> None
        C++: static void swap8_be_range(void *p, size_t num)"""
        ret = self._wrap_call(self._vtk_obj.Swap8BERange, *args)
        return ret

    def swap8_le(self, *args):
        """
        swap8_le(p:Pointer) -> None
        C++: static void swap8_le(void *p)"""
        ret = self._wrap_call(self._vtk_obj.Swap8LE, *args)
        return ret

    def swap8_le_range(self, *args):
        """
        swap8_le_range(p:Pointer, num:int) -> None
        C++: static void swap8_le_range(void *p, size_t num)"""
        ret = self._wrap_call(self._vtk_obj.Swap8LERange, *args)
        return ret

    def swap_be(self, *args):
        """
        swap_be(p:[float, ...]) -> None
        C++: static void swap_be(double *p)
        swap_be(p:str) -> None
        C++: static void swap_be(char *p)
        swap_be(p:[int, ...]) -> None
        C++: static void swap_be(int *p)
        swap_be(p:[int, ...]) -> None
        C++: static void swap_be(long *p)
        swap_be(p:[int, ...]) -> None
        C++: static void swap_be(long long *p)"""
        ret = self._wrap_call(self._vtk_obj.SwapBE, *args)
        return ret

    def swap_be_range(self, *args):
        """
        swap_be_range(p:[float, ...], num:int) -> None
        C++: static void swap_be_range(double *p, size_t num)
        swap_be_range(p:str, num:int) -> None
        C++: static void swap_be_range(char *p, size_t num)
        swap_be_range(p:[int, ...], num:int) -> None
        C++: static void swap_be_range(int *p, size_t num)
        swap_be_range(p:[int, ...], num:int) -> None
        C++: static void swap_be_range(long *p, size_t num)
        swap_be_range(p:[int, ...], num:int) -> None
        C++: static void swap_be_range(long long *p, size_t num)"""
        ret = self._wrap_call(self._vtk_obj.SwapBERange, *args)
        return ret

    def swap_le(self, *args):
        """
        swap_le(p:[float, ...]) -> None
        C++: static void swap_le(double *p)
        swap_le(p:str) -> None
        C++: static void swap_le(char *p)
        swap_le(p:[int, ...]) -> None
        C++: static void swap_le(int *p)
        swap_le(p:[int, ...]) -> None
        C++: static void swap_le(long *p)
        swap_le(p:[int, ...]) -> None
        C++: static void swap_le(long long *p)"""
        ret = self._wrap_call(self._vtk_obj.SwapLE, *args)
        return ret

    def swap_le_range(self, *args):
        """
        swap_le_range(p:[float, ...], num:int) -> None
        C++: static void swap_le_range(double *p, size_t num)
        swap_le_range(p:str, num:int) -> None
        C++: static void swap_le_range(char *p, size_t num)
        swap_le_range(p:[int, ...], num:int) -> None
        C++: static void swap_le_range(int *p, size_t num)
        swap_le_range(p:[int, ...], num:int) -> None
        C++: static void swap_le_range(long *p, size_t num)
        swap_le_range(p:[int, ...], num:int) -> None
        C++: static void swap_le_range(long long *p, size_t num)"""
        ret = self._wrap_call(self._vtk_obj.SwapLERange, *args)
        return ret

    def swap_void_range(self, *args):
        """
        swap_void_range(buffer:Pointer, numWords:int, wordSize:int) -> None
        C++: static void swap_void_range(void *buffer, size_t numWords,
            size_t wordSize)
        Swaps the bytes of a buffer.  Uses an arbitrary word size, but
        assumes the word size is divisible by two.
        """
        ret = self._wrap_call(self._vtk_obj.SwapVoidRange, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ByteSwap, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ByteSwap properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit ByteSwap properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ByteSwap properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

