/*
 *  $Id: rk_bltinfn.c,v 1.6 2005/04/10 15:26:38 aonoto Exp $
 */

/*
 * FreeWnn is a network-extensible Kana-to-Kanji conversion system.
 * This file is part of FreeWnn.
 * 
 * Copyright Kyoto University Research Institute for Mathematical Sciences
 *                 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1999
 * Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright FreeWnn Project 1999, 2000, 2002
 *
 * Maintainer:  FreeWnn Project   <freewnn@tomo.gr.jp>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/***********************************************************************
                        rk_bltinfn.c
                                                87.12. 6   

        ѴѤȤ߹ߴؿΤʣʤΤƤ롣
        ѢȾѤѴΡ
***********************************************************************/
/*  Version 3.0  */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#if STDC_HEADERS
#  include <string.h>
#elif HAVE_STRINGS_H
#  include <strings.h>
#endif /* STDC_HEADERS */

#include "commonhd.h"
#include "wnn_config.h"
#include "rk_header.h"

 /* ȾʸΥɤdefine */
#define HKCHOU  (HNKAK1 * 0x100 + 0xB0) /*  */
#define HKDKTN  (HNKAK1 * 0x100 + 0xDE) /*  */
#define HKHNDK  (HNKAK1 * 0x100 + 0xDF) /*  */
#define HKMARU  (HNKAK1 * 0x100 + 0xA1) /*  */
#define HKHRKG  (HNKAK1 * 0x100 + 0xA2) /*  */
#define HKTJKG  (HNKAK1 * 0x100 + 0xA3) /*  */
#define HKTTEN  (HNKAK1 * 0x100 + 0xA4) /*  */
#define HKNKPT  (HNKAK1 * 0x100 + 0xA5) /*  */

 /* ʸΥɤdefine */
#define CHOUON  (0xA1BC)        /*  */
#define DAKUTN  (0xA1AB)        /*  */
#define HNDAKU  (0xA1AC)        /*  */
#define MNMARU  (0xA1A3) /*  */       /* ̾ MaNMARUʤޤޤˤά */
#define HRKKAG  (0xA1D6)        /*  */
#define TJIKAG  (0xA1D7)        /*  */
#define TOUTEN  (0xA1A2)        /*  */
#define NKPOTU  (0xA1A6)        /*  */

static char _lang[6];

void
romkan_set_lang (lang)
     char *lang;
{
  strncpy (_lang, lang, 5);
  _lang[5] = 0;
}

 /** ASCIIʸ */
/* *INDENT-OFF* */
letter
to_zenalpha (l)
    letter l;
/* *INDENT-ON* */
{
  letter retval;

  static uns_chr *data = (uns_chr *) "ɡǡʡˡܡݡ䡩\
£ãģţƣǣȣɣʣˣ̣ͣΣϣУѣңӣԣգ֣ףأ٣ڡΡϡ\
Сáѡ";

#ifdef  CHINESE
  static uns_chr *data_cn = (uns_chr *) "磥\
£ãģţƣǣȣɣʣˣ̣ͣΣϣУѣңӣԣգ֣ףأ٣ڣۣݣޣߣ\
";
#endif /* CHINESE */
#ifdef  KOREAN
  static uns_chr *data_ko = (uns_chr *) "\
£ãģţƣǣȣɣʣˣ̣ͣΣϣУѣңӣԣգ֣ףأ٣ڣۣܣݣޣߣ\
";
#endif /* KOREAN */

  if (' ' <= l && l <= '~')
    {
      l = (l - ' ') << 1;
#ifdef  CHINESE
      if (!strcmp (_lang, WNN_C_LANG) || !strcmp (_lang, WNN_T_LANG))
        {
          retval = data_cn[l] << 8;
          retval += data_cn[++l];
        }
      else
#endif
#ifdef  KOREAN
      if (!strcmp (_lang, WNN_K_LANG))
        {
          retval = data_ko[l] << 8;
          retval += data_ko[++l];
        }
      else
#endif /* KOREAN */
        {
          retval = data[l] << 8;
          retval += data[++l];
        }
      return (retval);
    }
  else
    return (l);
}

static char *hankdata[] = {
  "", "", "", "", "", "", "", "", "", "",
  "", "", "", "", "", "", "", "", "", "",
  "", "", "", "", "", "", "", "", "", "",
  "", "", "", "", "", "", "", "", "Î", "", "Ď",
  "", "", "", "", "",
  "", "ʎ", "ʎ", "", "ˎ", "ˎ", "", "̎", "̎",
  "", "͎", "͎", "", "Ύ", "Ύ",
  "", "", "", "", "",
  "", "", "", "", "", "",
  "", "", "", "", "",
  "", "", "", "", "", "",
  "", "", ""
};                              /* ѤäƤΤ */

 /**    hankdataºݤ˻ȤȾѥɤɽƤʤȤºݤΤΤ
        롣˰Ƥ */
void
hank_setup ()
{
  int i;
  char *s, orig_hnkak1;

  orig_hnkak1 = *hankdata[0];
  /*     *hankdata[] ǤȾʸΣХȤᡣȾʸΣХȤۤʤ
     褦¾˰ܿȤϡHNKAK1defineѤOKâromkan
     ȾʸʤΥեˤΤ¸ߡˤ⥳СȤơε
     ˹碌ۤ˾ޤǥǤΥե
     ˡȾʸΰޤʤ礬Τǡä
     СȤ򤷤ʤȤư褦˽֤ϤƤ롣줬
     hank_setup()Ǥ롣hankdataϡ hank_setup()ˤä
     ºݤȾѥɤľ롣 */

  if (orig_hnkak1 == (char) HNKAK1)
    return;
  for (i = 0; i < numberof (hankdata); i++)
    {
      for (s = hankdata[i]; *s; s += 2)
        if (*s == orig_hnkak1)
          *s = HNKAK1;
    }
}

 /** ʢȾѥʡ̤ʸˤʤ뤳Ȥ⤢롣*/
void
to_hankata (in, outp)
     letter in, **outp;
{
  uns_chr *p, c;
  letter *out;

  out = *outp;
  switch (in)
    {
    case CHOUON:
      *out++ = HKCHOU;
      break;
    case DAKUTN:
      *out++ = HKDKTN;
      break;
    case HNDAKU:
      *out++ = HKHNDK;
      break;
    case MNMARU:
      *out++ = HKMARU;
      break;
    case HRKKAG:
      *out++ = HKHRKG;
      break;
    case TJIKAG:
      *out++ = HKTJKG;
      break;
    case TOUTEN:
      *out++ = HKTTEN;
      break;
    case NKPOTU:
      *out++ = HKNKPT;
      break;
    default:
      if (is_kata (in))
        {
          for (p = (uns_chr *) hankdata[in - KATBGN]; c = *p; p++)
            *out++ = (c << 8) + *++p;
        }
      else if (is_hira (in))
        {
          for (p = (uns_chr *) hankdata[in - HIRBGN]; c = *p; p++)
            *out++ = (c << 8) + *++p;
        }
      else
        {
          *out++ = in;
        }
    }
  *out = EOLTTR;
  *outp = out;
}

 /**    ȾѥʢҤ餬ʡâʸĤˤޤȤƤ
        ʤΤա*/
/* *INDENT-OFF* */
letter
to_zenhira (l)
    letter l;
/* *INDENT-ON* */
{
  letter retval;

  static uns_chr *data = (uns_chr *) "֡ס򤡤á\
ĤƤȤʤˤ̤ͤΤϤҤդؤۤޤߤ󡫡";

#ifdef  CHINESE
  static uns_chr *data_cn = (uns_chr *) "򤡤á𤭤Ȥ\
ĤƤȤʤˤ̤͵ĤϤҤդؤۤޤߤҲ";
#endif /* CHINESE */

  if (is_hankata (l))
    {
      l = (l - HKKBGN) << 1;
#ifdef  CHINESE
      if (!strcmp (_lang, WNN_C_LANG) || !strcmp (_lang, WNN_T_LANG))
        {
          retval = data_cn[l] << 8;
          retval += data_cn[++l];
        }
      else
#endif
        {
          retval = data[l] << 8;
          retval += data[++l];
        }
      return (retval);
    }
  else
    return (l);
}

 /**    ȾѥʢѡâʸĤˤޤȤƤ
        ʤΤա*/
/* *INDENT-OFF* */
letter
to_zenkata (l)
   letter l;
/* *INDENT-ON* */
{
  return (is_hankata (l) ? (l = to_zenhira (l), to_kata (l)) : l);
}

 /* ӥåȥ٥ι */
#define bitvec(b0, b1, b2, b3, b4, b5, b6, b7) (                         \
        (char)b0 | ((char)b1 << 1) | ((char)b2 << 2) | ((char)b3 << 3) | ((char)b4 << 4) | ((char)b5 << 5) | \
        ((char)b6 << 6) | ((char)b7 << 7)                                                \
)

 /** char h ӥåȥ٥ȸƤiӥåȤå */
#define bitlook(h, i) (h[(i) >> 3] & (1 << ((i) & 7)))

#define KATRPT  0xA1B3          /*  */
#define HIRRPT  0xA1B5          /*  */
#define KATA_U  0xA5A6          /*  */
#define KAT_VU  0xA5F4          /*  */
#define HIR_KA  0xA4AB          /*  */
#define HIR_HO  0xA4DB          /*  */
#define KAT_KA  0xA5AB          /*  */
#define KAT_HO  0xA5DB          /*  */
#define HIR_HA  0xA4CF          /*  */
#define KAT_HA  0xA5CF          /*  */

 /**    Ⱦ򤯤äĤ롣̤ϰʸ*/
void
handakuadd (in, outp)
     letter in, **outp;
{
  if ((HIR_HA <= in && in <= HIR_HO) ? 0 == (in - HIR_HA) % 3 : (KAT_HA <= in && in <= KAT_HO && 0 == (in - KAT_HA) % 3))
    {
      *(*outp)++ = in + 2;
    }
  else
    {
      *(*outp)++ = in;
      *(*outp)++ = HNDAKU;
    }
  **outp = EOLTTR;
}

 /**    򤯤äĤ롣̤ϰʸ*/
void
dakuadd (in, outp)
     letter in, **outp;
{
  static char flgbit[] = {
    bitvec (1, 0, 1, 0, 1, 0, 1, 0),    /*  */
    bitvec (1, 0, 1, 0, 1, 0, 1, 0),    /*  */
    bitvec (1, 0, 1, 0, 1, 0, 1, 0),    /*  */
    bitvec (0, 1, 0, 1, 0, 1, 0, 0),    /* äĤŤƤǤȤɤ */
    bitvec (0, 0, 0, 0, 1, 0, 0, 1),    /* ˤ̤ͤΤϤФѤ */
    bitvec (0, 0, 1, 0, 0, 1, 0, 0),    /* ӤԤդ֤פؤ٤ */
    bitvec (1, 0, 0, 0, 0, 0, 0, 0)     /*  */
  };
  letter c;

  if ((HIR_KA <= in && in <= HIR_HO) ? (c = in - HIR_KA, 1) : (KAT_KA <= in && in <= KAT_HO && (c = in - KAT_KA, 1)))
    {
      if (bitlook (flgbit, c))
        {
          *(*outp)++ = in + 1;
        }
      else
        {
          *(*outp)++ = in;
          *(*outp)++ = DAKUTN;
        }
    }
  else
    switch (in)
      {
      case KATRPT:
      case HIRRPT:
        *(*outp)++ = in + 1;
        break;
      case KATA_U:
        *(*outp)++ = KAT_VU;
        break;
      default:
        *(*outp)++ = in;
        *(*outp)++ = DAKUTN;
      }
  **outp = EOLTTR;
}

 /** inͿ줿ɤbaseʤοˤoutp롣*/
void
to_digit (in, base, outp)
     letter in, base, **outp;
{
  letter c, vtol ();

  if (c = in, c /= base)
    to_digit (c, base, outp);
  *(*outp)++ = vtol (in % base);
  **outp = EOLTTR;
}
