/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#include "phrasor.h"
#include "dingl.h"

void phrasor::draw (unsigned int i, float r, float g, float b) {
  if (i < (unsigned int) sz) {
    glColor3f (r, g, b); draw_marker (data[i].x, data[i].y);
  }
}

void phrasor::draw_marker (int x, int y) {
  static const int msz = 25;
  glBegin (GL_LINES);
    glVertex2i (x - msz, y);
    glVertex2i (x + msz, y);
    glVertex2i (x, y - msz);
    glVertex2i (x, y + msz);
  glEnd ();
}



