/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
/*
 * din irc bot
 *
 * based on LGPLed code by Georgy Yunaev gyunaev@ulduzsoft.com
 * of libircclient.sourceforge.net.
 *
*/

#ifndef __BOT
#define __BOT

#include <libircclient/libircclient.h>
#include <cstring>
#include "command.h"
#include "globals.h"
#include <queue>
#include <vector>

void* irc_monitor (void *pbot);

// callbacks for various irc events
void dump_event (irc_session_t* session, const char* event, const char* origin, const char** params, unsigned int count);
void event_join (irc_session_t* session, const char* event, const char* origin, const char** params, unsigned int count);
void event_connect (irc_session_t* session, const char* event, const char* origin, const char** params, unsigned int count);
void event_privmsg (irc_session_t* session, const char* event, const char* origin, const char** params, unsigned int count);
void event_channel (irc_session_t* session, const char* event, const char* origin, const char** params, unsigned int count);
void irc_event_dcc_chat (irc_session_t* session, const char* nick, const char* addr, irc_dcc_t dccid);
void irc_event_dcc_send (irc_session_t* session, const char* nick, const char* addr, const char* filename, unsigned long size, irc_dcc_t dccid);
void event_numeric (irc_session_t* session, unsigned int event, const char* origin, const char** params, unsigned int count);

// utils
std::string get_nick (const char * origin);
struct tokenizer;

// the bot
//
struct bot_t : command, pusher<bot_t> {

  // libircclient
  irc_callbacks_t callbacks;
  irc_session_t* sess;

  // server, nickname and channel
  std::string srv, nick, chan, passwd;

  std::string nickolon; // nick:
  int len;

  // messages from irc
  std::string mesg;
  std::queue<std::string> cmds, mesgs;
  void handle_input ();

  // irc monitoring thread
  pthread_t tid;

  int prefixed; // yes?
  std::string prefix; // eg., some_nick:

  std::vector<std::string> allowed;

  bot_t (const std::string& ln, const std::string& sn);
  int make ();

  ~bot_t ();

  std::string quitmsg;
  int kill ();

  bool operator() (tokenizer& ss); // command parser

  // pusher
  bot_t& operator<< (const std::string& s);
  bot_t& operator<< (char c) {return *this;}


};

#endif
