# Section J - What do anarchists do?

This section discusses what anarchists get up to. There is little point
thinking about the world unless you also want to change it for the better. And
by trying to change it, you change yourself and others, making radical change
more of a possibility. Therefore anarchists give their whole-hearted support
to attempts by ordinary people to improve their lives by their own actions. We
urge _" **emancipation through practical action** "_ recognising that the
_"collective experience"_ gained in _"the collective struggle of the workers
against the bosses"_ will transform how they see the world and the world
itself. [Bakunin, **The Basic Bakunin** , p. 103] Ultimately, _"[t]he true man
does not lie in the future, an object of longing, but lies, existent and real,
in the present._ [Stirner, **The Ego and Its Own** , p. 327]

Anarchism is more than just a critique of statism and capitalism or a vision
of a freer, better way of life. It is first and foremost a movement, the
movement of working class people attempting to change the world. Therefore the
kind of activity we discuss in this section of the FAQ forms the bridge
between capitalism and anarchy. By self-activity and direct action, people can
change both themselves and their surroundings. They develop within themselves
the mental, ethical and spiritual qualities which can make an anarchist
society a viable option. As Noam Chomsky argues:

> _"Only through their own struggle for liberation will ordinary people come
> to comprehend their true nature, suppressed and distorted within
> institutional structures designed to assure obedience and subordination.
> Only in this way will people develop more humane ethical standards, 'a new
> sense of right', 'the consciousness of their strength and their importance
> as a social factor in the life of their time' and their capacity to realise
> the strivings of their 'inmost nature.' Such direct engagement in the work
> of social reconstruction is a prerequisite for coming to perceive this
> 'inmost nature' and is the indispensable foundations upon which it can
> flourish"_ [ _"preface"_ , Rudolf Rocker, **Anarcho-Syndicalism** , p. iii]

In other words, anarchism is not primarily a vision of a better future, but
the actual social movement which is fighting within the current unjust and
unfree society for that better future and to improve things in the here and
now. Without standing up for yourself and what you believe is right, nothing
will change. Thus anarchy can be found _"wherever free thought breaks loose
from the chains of dogma; wherever the spirit of inquiry rejects the old
formulas, wherever the human will asserts itself through independent actions;
wherever honest people, rebelling against all enforced discipline, join freely
together in order to educate themselves, and to reclaim, without any master,
their share of life, and the complete satisfaction of their needs."_ [Elisée
Reclus, quoted by John P. Clark and Camille Martin (ed.), **Anarchy,
Geography, Modernity** , p. 62]

For anarchists, the future is **already appearing in the present** and is
expressed by the creativity of working class self-activity. Anarchy is not
some-day-to-be-achieved utopia, it is a living reality whose growth only needs
to be freed from constraint. As such anarchist activity is about discovering
and aiding emerging trends of mutual aid which work against capitalist
domination, so the Anarchist _"studies society and tries to discover its
**tendencies** , past and present, its growing needs, intellectual and
economic, and in his [or her] ideal he merely points out in which direction
evolution goes."_ [Peter Kropotkin, **Anarchism** , p. 47] Indeed, as we
discussed in [section I.2.3](secI2.md#seci23), the future structures of a
free society are created in the struggles against oppression today.

The kinds of activity outlined in this section are a general overview of
anarchist work. It is by no means exclusive -- we are sure to have left
something out. However, the key aspect of **real** anarchist activity is
**_direct action_** \- self-activity, self-help, self-liberation and
solidarity ( _"We wish,"_ as French syndicalist Fernand Pelloutier wrote,
_"that the emancipation of the people might be the work of the people
themselves."_ [quoted by Jeremy Jennings, **Syndicalism in France** , p. 18]).
Such activity may be done by individuals (for example, propaganda work), but
usually anarchists emphasise collective activity. This is because most of our
problems are of a social nature, meaning that their solutions can only be
worked on collectively. Individual solutions to social problems are doomed to
failure, at best slowing down what they are opposed to (most obviously,
ethical consumerism as discussed in [section E.5](secE5.md)). In addition,
collective action gets us used to working together, promoting the experience
of self-management and building organisations that will allow us to actively
manage our own affairs. Also, and we would like to emphasise this, it can be
**fun** to get together with other people and work with them, it can be
fulfilling and empowering.

Anarchists do not ask those in power to give up that power. No, we promote
forms of activity and organisation by which all the oppressed can liberate
themselves by their own hands. In other words, we do not think that those in
power will altruistically renounce that power or their privileges. Instead,
the oppressed must take the power **back** into their own hands by their own
actions. We must free ourselves, no one else can do it for us.

Here we will discuss anarchist ideas on struggle, what anarchists actually
(and, almost as importantly, do not) do in the here and now and the sort of
alternatives anarchists try to build within statism and capitalism in order to
destroy them. As well as a struggle against oppression, anarchist activity is
also struggle for freedom. As well as fighting against material poverty,
anarchists combat spiritual poverty. By resisting hierarchy we emphasis the
importance of **living** and of **life as art.** By proclaiming **_"Neither
Master nor Slave"_** we urge an ethical transformation, a transformation that
will help create the possibility of a truly free society. This point was
stressed by Emma Goldman after she saw the defeat of the Russian Revolution by
a combination of Leninist politics and capitalist armed intervention:

> _"revolution is in vain unless inspired by its ultimate ideal. Revolutionary
> methods must be in tune with revolutionary aims . . . In short, the ethical
> values which the revolution is to establish must be initiated with the
> revolutionary activities . . . The latter can only serve as a real and
> dependable bridge to the better life if built of the same material as the
> life to be achieved."_ [ **Red Emma Speaks** , p. 404]

In other words, anarchist activity is more than creating libertarian
alternatives and resisting hierarchy, it is about building the new world in
the shell of the old not only with regards to organisations and self-activity,
but also within the individual. It is about transforming yourself while
transforming the world (both processes obviously interacting and supporting
each other) for while _"we associate ourselves with others in working for . .
. social revolution, which for us means the destruction of all monopoly and
all government, and the direct seizure by the workers of the means of
production"_ we do not forget that _"the first aim of Anarchism is to assert
and make good the dignity of the individual human being."_ [Charlotte Wilson,
**Anarchist Essays** , p. 43 and p. 51]

By direct action, self-management and self-activity we can make the words
first heard in Paris, 1968 a living reality: **_"All power to the
imagination!"_** Words, we are sure, previous generations of anarchists would
have whole-heartedly agreed with. There is a power in humans, a creative
power, a power to alter _what is_ into _what should be_. Anarchists try to
create alternatives that will allow that power to be expressed, the power of
imagination.

Such a social movement will change how we act as individuals, with anarchists
seeking to apply our principles in our daily lives as much as our daily
struggles. This means that libertarians must change how we relate to our
comrades and fellow workers by applying our egalitarian ideals everywhere.
Part of the task of anarchists is to challenge social hierarchies everywhere,
including in the home. As Durruti put it:

> _"When will you stop thinking like the bourgeoisie, that women are men's
> servants? It's enough that society is divided into classes. We're not going
> to make even more classes by creating differences between men and women in
> our own homes!"_ [quoted by Abel Paz, **Durruti in the Spanish Revolution**
> , p. 341]

So we have a interactive process of struggle and transformation of both
society and the individuals within it. In the sections that follow we will
discuss the forms of self-activity and self-organisation which anarchists
think will stimulate and develop the imagination of those oppressed by
hierarchy, build anarchy in action and help create a free society.

[‹ Section J - What do anarchists do?](secJcon.md "Go to previous page")
[up](secJcon.md "Go to parent page") [J.1 Are anarchists involved in social
struggles? ›](secJ1.md "Go to next page")

