untrusted comment: verify with openbsd-77-base.pub
RWSbCCUoGpcxVYrcVhRxJ+ieUL6V0TtuK2Qmt6JzJUHwfi9usjHZ7VwlkM40y56fKSqK142TiqXFn3iVEAE5EtJ6ANO0MvNRxgU=

OpenBSD 7.7 errata 008, July 1, 2025:

TIOCUCNTL ioctl(2) could crash the kernel if called with a non-file
argument.

Apply by doing:
    signify -Vep /etc/signify/openbsd-77-base.pub -x 008_pledge.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/kern_pledge.c
===================================================================
RCS file: /cvs/src/sys/kern/kern_pledge.c,v
diff -u -p -r1.323 kern_pledge.c
--- sys/kern/kern_pledge.c	12 Feb 2025 14:11:26 -0000	1.323
+++ sys/kern/kern_pledge.c	29 Jun 2025 07:38:30 -0000
@@ -1263,9 +1263,11 @@ pledge_ioctl(struct proc *p, long com, s
 				break;
 			if ((pledge & PLEDGE_WPATH) == 0)
 				break;
-			if (cdevsw[major(vp->v_rdev)].d_open != ptcopen)
-				break;
-			return (0);
+			if (fp->f_type == DTYPE_VNODE &&
+			    vp->v_type == VCHR &&
+			    cdevsw[major(vp->v_rdev)].d_open == ptcopen)
+				return (0);
+			break;
 #endif /* NPTY > 0 */
 		case TIOCSPGRP:
 			if ((pledge & PLEDGE_PROC) == 0)
