/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test;

import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.opengl.Display;

public class SysTest {
    public void executeTest() {
        this.testAlert();
        this.testDebug();
        this.testTimer();
        this.testUrl();
        this.testClipboard();
    }

    private void testDebug() {
        System.out.println("==== Test Debug ====");
        if (LWJGLUtil.DEBUG) {
            LWJGLUtil.log((CharSequence)"Debug is enabled, you should now see output from LWJGL during the following tests.");
        } else {
            System.out.println("Debug is not enabled. Please set the org.lwjgl.Sys.debug property to true to enable debugging");
            System.out.println("Example:\n  java -Dorg.lwjgl.util.Debug=true ...");
            System.out.println("You will not see any debug output in the following tests.");
        }
        try {
            Display.getAvailableDisplayModes();
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
        System.out.println("---- Test Debug ----\n");
    }

    private void testTimer() {
        long resolution = Sys.getTimerResolution();
        long time = Sys.getTime();
        System.out.println("==== Test Timer ====");
        System.out.println("Resolution of timer (ticks per second): " + resolution);
        System.out.println("Current time: " + time);
        System.out.println("Sleeping for 2 seconds, using Thread.sleep()");
        this.pause(2000L);
        long time2 = Sys.getTime();
        System.out.println("Current time: " + time2);
        System.out.println("Actually slept for: " + (float)(time2 - time) / (float)resolution + " seconds");
        System.out.println("---- Test Timer ----\n");
    }

    private void testAlert() {
        System.out.println("==== Test Alert ====");
        System.out.println("Opening native alert window");
        Sys.alert((String)"SysTest", (String)"Hello World!");
        System.out.println("---- Test Alert ----\n");
    }

    private void testUrl() {
        System.out.println("==== Test URL ====");
        System.out.println("Opening a browser window to http://www.lwjgl.org");
        Sys.openURL((String)"http://www.lwjgl.org");
        System.out.println("---- Test URL ----\n");
    }

    private void busyWait(int priority, int seconds, String message) {
        long future = Sys.getTime() + Sys.getTimerResolution() * (long)seconds;
        System.out.print(message);
        while (Sys.getTime() < future) {
        }
        System.out.println("done");
    }

    private void pause(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void testClipboard() {
        System.out.println("Contents of clipboard: '" + Sys.getClipboard() + "'");
    }

    public static void main(String[] args) {
        new SysTest().executeTest();
        System.exit(0);
    }
}

