/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.presentation.rmi;

import com.sun.corba.se.impl.presentation.rmi.DynamicStubImpl;
import com.sun.corba.se.impl.presentation.rmi.StubInvocationHandlerImpl;
import com.sun.corba.se.spi.orbutil.proxy.CompositeInvocationHandlerImpl;
import com.sun.corba.se.spi.orbutil.proxy.DelegateInvocationHandlerImpl;
import com.sun.corba.se.spi.orbutil.proxy.InvocationHandlerFactory;
import com.sun.corba.se.spi.orbutil.proxy.LinkedInvocationHandler;
import com.sun.corba.se.spi.presentation.rmi.DynamicStub;
import com.sun.corba.se.spi.presentation.rmi.PresentationManager;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.omg.CORBA.Object;

public class InvocationHandlerFactoryImpl
implements InvocationHandlerFactory {
    private final PresentationManager.ClassData classData;
    private final PresentationManager pm;
    private Class[] proxyInterfaces;

    public InvocationHandlerFactoryImpl(PresentationManager presentationManager, PresentationManager.ClassData classData) {
        this.classData = classData;
        this.pm = presentationManager;
        Class[] classArray = classData.getIDLNameTranslator().getInterfaces();
        this.proxyInterfaces = new Class[classArray.length + 1];
        for (int i = 0; i < classArray.length; ++i) {
            this.proxyInterfaces[i] = classArray[i];
        }
        this.proxyInterfaces[classArray.length] = DynamicStub.class;
    }

    @Override
    public InvocationHandler getInvocationHandler() {
        DynamicStubImpl dynamicStubImpl = new DynamicStubImpl(this.classData.getTypeIds());
        return this.getInvocationHandler(dynamicStubImpl);
    }

    InvocationHandler getInvocationHandler(DynamicStub dynamicStub) {
        final InvocationHandler invocationHandler = DelegateInvocationHandlerImpl.create(dynamicStub);
        StubInvocationHandlerImpl stubInvocationHandlerImpl = new StubInvocationHandlerImpl(this.pm, this.classData, dynamicStub);
        final CustomCompositeInvocationHandlerImpl customCompositeInvocationHandlerImpl = new CustomCompositeInvocationHandlerImpl(dynamicStub);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                customCompositeInvocationHandlerImpl.addInvocationHandler(DynamicStub.class, invocationHandler);
                customCompositeInvocationHandlerImpl.addInvocationHandler(Object.class, invocationHandler);
                customCompositeInvocationHandlerImpl.addInvocationHandler(java.lang.Object.class, invocationHandler);
                return null;
            }
        });
        customCompositeInvocationHandlerImpl.setDefaultHandler(stubInvocationHandlerImpl);
        return customCompositeInvocationHandlerImpl;
    }

    @Override
    public Class[] getProxyInterfaces() {
        return this.proxyInterfaces;
    }

    private class CustomCompositeInvocationHandlerImpl
    extends CompositeInvocationHandlerImpl
    implements LinkedInvocationHandler,
    Serializable {
        private transient DynamicStub stub;

        @Override
        public void setProxy(Proxy proxy) {
            ((DynamicStubImpl)this.stub).setSelf((DynamicStub)((java.lang.Object)proxy));
        }

        @Override
        public Proxy getProxy() {
            return (Proxy)((java.lang.Object)((DynamicStubImpl)this.stub).getSelf());
        }

        public CustomCompositeInvocationHandlerImpl(DynamicStub dynamicStub) {
            this.stub = dynamicStub;
        }

        public java.lang.Object writeReplace() throws ObjectStreamException {
            return this.stub;
        }
    }
}

