/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.resolver;

import java.util.Objects;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.resolve.resolver.FilteringResolvedArtifactSet;

public class ExcludingVariantArtifactSet
implements ResolvedVariant,
VariantResolveMetadata.Identifier {
    private final ResolvedVariant delegate;
    private final ModuleIdentifier moduleId;
    private final ExcludeSpec exclusions;
    private final VariantResolveMetadata.Identifier id;

    public ExcludingVariantArtifactSet(ResolvedVariant delegate, ModuleIdentifier moduleId, ExcludeSpec exclusions) {
        this.delegate = delegate;
        this.moduleId = moduleId;
        this.exclusions = exclusions;
        this.id = new ExcludingIdentifier(delegate.getIdentifier(), moduleId, exclusions);
    }

    @Override
    public DisplayName asDescribable() {
        return Describables.of((Object)this.delegate.asDescribable(), (Object)this.exclusions);
    }

    @Override
    @Nullable
    public VariantResolveMetadata.Identifier getIdentifier() {
        return this.id;
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return this.delegate.getAttributes();
    }

    @Override
    public ImmutableCapabilities getCapabilities() {
        return this.delegate.getCapabilities();
    }

    @Override
    public ResolvedArtifactSet getArtifacts() {
        ResolvedArtifactSet artifacts = this.delegate.getArtifacts();
        return new FilteringResolvedArtifactSet(artifacts, this::include);
    }

    private boolean include(ResolvableArtifact artifact) {
        return !this.exclusions.excludesArtifact(this.moduleId, artifact.getArtifactName());
    }

    private static class ExcludingIdentifier
    implements VariantResolveMetadata.Identifier {
        private final VariantResolveMetadata.Identifier identifier;
        private final ModuleIdentifier moduleId;
        private final ExcludeSpec exclusions;

        public ExcludingIdentifier(@Nullable VariantResolveMetadata.Identifier identifier, ModuleIdentifier moduleId, ExcludeSpec exclusions) {
            this.identifier = identifier;
            this.moduleId = moduleId;
            this.exclusions = exclusions;
        }

        public int hashCode() {
            int result = Objects.hashCode(this.identifier);
            result = 31 * result + this.moduleId.hashCode();
            result = 31 * result + this.exclusions.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ExcludingIdentifier other = (ExcludingIdentifier)obj;
            return ExcludingIdentifier.areIdsEqual(this.identifier, other.identifier) && this.moduleId.equals(other.moduleId) && this.exclusions.equals(other.exclusions);
        }

        private static boolean areIdsEqual(@Nullable VariantResolveMetadata.Identifier id1, @Nullable VariantResolveMetadata.Identifier id2) {
            if (id1 == null || id2 == null) {
                return false;
            }
            return id1.equals(id2);
        }
    }
}

