/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.contentassist;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalCreator;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalPriorities;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.lib.Procedures;

public class IdeCrossrefProposalProvider {
    private static final Logger LOG = Logger.getLogger(IdeCrossrefProposalProvider.class);
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IdeContentProposalCreator proposalCreator;
    @Inject
    private IdeContentProposalPriorities proposalPriorities;

    public void lookupCrossReference(IScope scope, CrossReference crossReference, ContentAssistContext context, IIdeContentProposalAcceptor acceptor, Predicate<IEObjectDescription> filter) {
        try {
            for (IEObjectDescription candidate : this.queryScope(scope, crossReference, context)) {
                if (!acceptor.canAcceptMoreProposals()) {
                    return;
                }
                if (!filter.apply((Object)candidate)) continue;
                ContentAssistEntry entry = this.createProposal(candidate, crossReference, context);
                acceptor.accept(entry, this.proposalPriorities.getCrossRefPriority(candidate, entry));
            }
        }
        catch (UnsupportedOperationException uoe) {
            LOG.error((Object)"Failed to create content assist proposals for cross-reference.", (Throwable)uoe);
        }
    }

    protected Iterable<IEObjectDescription> queryScope(IScope scope, CrossReference crossReference, ContentAssistContext context) {
        return scope.getAllElements();
    }

    protected ContentAssistEntry createProposal(IEObjectDescription candidate, CrossReference crossRef, ContentAssistContext context) {
        return this.proposalCreator.createProposal(this.qualifiedNameConverter.toString(candidate.getName()), context, (Procedures.Procedure1<? super ContentAssistEntry>)((Procedures.Procedure1)e -> {
            e.setSource(candidate);
            e.setDescription(candidate.getEClass() != null ? candidate.getEClass().getName() : null);
            e.setKind("REFERENCE");
        }));
    }

    protected IQualifiedNameConverter getQualifiedNameConverter() {
        return this.qualifiedNameConverter;
    }

    protected IdeContentProposalCreator getProposalCreator() {
        return this.proposalCreator;
    }
}

