/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.JustInTimeInjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.utilities.GreedyDefaultImplementation;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;

@Singleton
@Visibility(value=DescriptorVisibility.LOCAL)
public class GreedyResolver
implements JustInTimeInjectionResolver {
    private final ServiceLocator locator;

    @Inject
    private GreedyResolver(ServiceLocator locator) {
        this.locator = locator;
    }

    @Override
    public boolean justInTimeResolution(Injectee failedInjectionPoint) {
        Type rawType;
        Type type2 = failedInjectionPoint.getRequiredType();
        if (type2 == null) {
            return false;
        }
        Class<?> clazzToAdd = null;
        if (type2 instanceof Class) {
            clazzToAdd = (Class<?>)type2;
        } else if (type2 instanceof ParameterizedType && (rawType = ((ParameterizedType)type2).getRawType()) instanceof Class) {
            clazzToAdd = (Class)rawType;
        }
        if (clazzToAdd == null) {
            return false;
        }
        if (clazzToAdd.isInterface()) {
            GreedyDefaultImplementation gdi = clazzToAdd.getAnnotation(GreedyDefaultImplementation.class);
            if (gdi != null) {
                clazzToAdd = gdi.value();
            } else {
                return false;
            }
        }
        ServiceLocatorUtilities.addClasses(this.locator, clazzToAdd);
        return true;
    }
}

