// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkConstantUnsignedLongArray
 * @brief   constant implicit array of unsigned long.
 *
 * vtkConstantUnsignedLongArray is a constant implicit array of values of type unsigned long.
 * see vtkConstantArray, vtkConstantImplicitBackend
 *
 * This file is generated by vtkImplicitArrays.cmake
 */

#ifndef vtkConstantUnsignedLongArray_h
#define vtkConstantUnsignedLongArray_h

#include "vtkConstantArray.h" // Real Superclass
#include "vtkCommonCoreModule.h"     // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkConstantArray<unsigned long>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkConstantUnsignedLongArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkConstantUnsignedLongArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  // This macro expands to the set of method declarations that
  // make up the interface of vtkAOSDataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(unsigned long);
#endif

  static vtkConstantUnsignedLongArray* New();
  static vtkConstantUnsignedLongArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkConstantUnsignedLongArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkConstantUnsignedLongArray*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the constant value for this array.
   */
  void ConstructBackend(unsigned long value);

protected:
  vtkConstantUnsignedLongArray();
  ~vtkConstantUnsignedLongArray() override;

private:
  typedef vtkConstantArray<unsigned long> RealSuperclass;

  vtkConstantUnsignedLongArray(const vtkConstantUnsignedLongArray&) = delete;
  void operator=(const vtkConstantUnsignedLongArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkConstantUnsignedLongArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
