/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.format;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.measure.format.QuantityFormat;
import javax.measure.format.UnitFormat;
import javax.measure.spi.FormatService;
import tech.units.indriya.format.EBNFUnitFormat;
import tech.units.indriya.format.FormatBehavior;
import tech.units.indriya.format.LocalUnitFormat;
import tech.units.indriya.format.NumberDelimiterQuantityFormat;
import tech.units.indriya.format.SimpleQuantityFormat;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.uom.lib.common.function.IntPrioritySupplier;

public class DefaultFormatService
implements FormatService,
IntPrioritySupplier {
    private static final int PRIO = 1000;
    private static final String SIMPLE_KEY = "SIMPLE";
    private static final String EBNF_KEY = "EBNF";
    private static final String LOCAL_KEY = "LOCAL";
    private static final String DEFAULT_QUANTITY_FORMAT_NAME = "SIMPLE";
    private static final String DEFAULT_UNIT_FORMAT_NAME = "SIMPLE_DEFAULT";
    private static final String ASCII_UNIT_FORMAT_NAME = "SIMPLE_ASCII";
    private final Map<String, QuantityFormat> quantityFormats = new HashMap<String, QuantityFormat>();
    private final Map<String, UnitFormat> unitFormats = new HashMap<String, UnitFormat>();
    private final Map<String, String> unitFormatAliases = new HashMap<String, String>();
    private final Map<String, String> quantityFormatAliases = new HashMap<String, String>();
    private static final NumberDelimiterQuantityFormat EBNF_QUANTITY_FORMAT = new NumberDelimiterQuantityFormat.Builder().setNumberFormat(NumberFormat.getInstance(Locale.ROOT)).setUnitFormat(EBNFUnitFormat.getInstance()).build();

    public DefaultFormatService() {
        this.unitFormats.put(DEFAULT_UNIT_FORMAT_NAME, SimpleUnitFormat.getInstance());
        this.unitFormats.put(ASCII_UNIT_FORMAT_NAME, SimpleUnitFormat.getInstance(SimpleUnitFormat.Flavor.ASCII));
        this.unitFormats.put(EBNF_KEY, EBNFUnitFormat.getInstance());
        this.unitFormats.put(LOCAL_KEY, LocalUnitFormat.getInstance());
        this.unitFormatAliases.put("DEFAULT", DEFAULT_UNIT_FORMAT_NAME);
        this.unitFormatAliases.put("ASCII", ASCII_UNIT_FORMAT_NAME);
        this.quantityFormats.put("SIMPLE", SimpleQuantityFormat.getInstance());
        this.quantityFormats.put("NUMBERDELIMITER", NumberDelimiterQuantityFormat.getInstance());
        this.quantityFormats.put(EBNF_KEY, EBNF_QUANTITY_FORMAT);
        this.quantityFormats.put(LOCAL_KEY, NumberDelimiterQuantityFormat.getInstance(FormatBehavior.LOCALE_SENSITIVE));
        this.quantityFormatAliases.put("NUMBERSPACE", "NUMBERDELIMITER");
    }

    public QuantityFormat getQuantityFormat(String key) {
        Objects.requireNonNull(key, "Format name or alias required");
        String alias = this.quantityFormatAliases.get(key.toUpperCase());
        if (alias != null && alias.length() > 0) {
            return this.quantityFormats.get(alias.toUpperCase());
        }
        return this.quantityFormats.get(key.toUpperCase());
    }

    public QuantityFormat getQuantityFormat() {
        return this.getQuantityFormat("SIMPLE");
    }

    public Set<String> getAvailableFormatNames(FormatService.FormatType type) {
        switch (type) {
            case QUANTITY_FORMAT: {
                return this.quantityFormats.keySet();
            }
        }
        return this.unitFormats.keySet();
    }

    public UnitFormat getUnitFormat(String key) {
        Objects.requireNonNull(key, "Format name or alias required");
        String alias = this.unitFormatAliases.get(key.toUpperCase());
        if (alias != null && alias.length() > 0) {
            return this.unitFormats.get(alias);
        }
        return this.unitFormats.get(key.toUpperCase());
    }

    public UnitFormat getUnitFormat() {
        return this.getUnitFormat(DEFAULT_UNIT_FORMAT_NAME);
    }

    public UnitFormat getUnitFormat(String name, String variant) {
        StringBuilder sb = new StringBuilder(name);
        if (null != variant && !variant.isEmpty()) {
            sb.append("_");
            sb.append(variant);
        }
        return this.getUnitFormat(sb.toString());
    }

    public int getPriority() {
        return 1000;
    }
}

