/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HmdQuaternion_t")
public class HmdQuaternion
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int W;
    public static final int X;
    public static final int Y;
    public static final int Z;

    public HmdQuaternion(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), HmdQuaternion.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public double w() {
        return HmdQuaternion.nw(this.address());
    }

    public double x() {
        return HmdQuaternion.nx(this.address());
    }

    public double y() {
        return HmdQuaternion.ny(this.address());
    }

    public double z() {
        return HmdQuaternion.nz(this.address());
    }

    public HmdQuaternion w(double value) {
        HmdQuaternion.nw(this.address(), value);
        return this;
    }

    public HmdQuaternion x(double value) {
        HmdQuaternion.nx(this.address(), value);
        return this;
    }

    public HmdQuaternion y(double value) {
        HmdQuaternion.ny(this.address(), value);
        return this;
    }

    public HmdQuaternion z(double value) {
        HmdQuaternion.nz(this.address(), value);
        return this;
    }

    public HmdQuaternion set(double w, double x, double y, double z) {
        this.w(w);
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public HmdQuaternion set(HmdQuaternion src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static HmdQuaternion malloc() {
        return (HmdQuaternion)HmdQuaternion.wrap(HmdQuaternion.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static HmdQuaternion calloc() {
        return (HmdQuaternion)HmdQuaternion.wrap(HmdQuaternion.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static HmdQuaternion create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (HmdQuaternion)HmdQuaternion.wrap(HmdQuaternion.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static HmdQuaternion create(long address) {
        return (HmdQuaternion)HmdQuaternion.wrap(HmdQuaternion.class, (long)address);
    }

    @Nullable
    public static HmdQuaternion createSafe(long address) {
        return address == 0L ? null : (HmdQuaternion)HmdQuaternion.wrap(HmdQuaternion.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)HmdQuaternion.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)HmdQuaternion.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)HmdQuaternion.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = HmdQuaternion.__create((int)capacity, (int)SIZEOF);
        return (Buffer)HmdQuaternion.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)HmdQuaternion.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)HmdQuaternion.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static HmdQuaternion mallocStack() {
        return HmdQuaternion.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdQuaternion callocStack() {
        return HmdQuaternion.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdQuaternion mallocStack(MemoryStack stack) {
        return HmdQuaternion.malloc(stack);
    }

    @Deprecated
    public static HmdQuaternion callocStack(MemoryStack stack) {
        return HmdQuaternion.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return HmdQuaternion.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return HmdQuaternion.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdQuaternion.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdQuaternion.calloc(capacity, stack);
    }

    public static HmdQuaternion malloc(MemoryStack stack) {
        return (HmdQuaternion)HmdQuaternion.wrap(HmdQuaternion.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HmdQuaternion calloc(MemoryStack stack) {
        return (HmdQuaternion)HmdQuaternion.wrap(HmdQuaternion.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)HmdQuaternion.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)HmdQuaternion.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static double nw(long struct) {
        return UNSAFE.getDouble(null, struct + (long)W);
    }

    public static double nx(long struct) {
        return UNSAFE.getDouble(null, struct + (long)X);
    }

    public static double ny(long struct) {
        return UNSAFE.getDouble(null, struct + (long)Y);
    }

    public static double nz(long struct) {
        return UNSAFE.getDouble(null, struct + (long)Z);
    }

    public static void nw(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)W, value);
    }

    public static void nx(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)X, value);
    }

    public static void ny(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)Y, value);
    }

    public static void nz(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)Z, value);
    }

    static {
        Struct.Layout layout = HmdQuaternion.__struct((Struct.Member[])new Struct.Member[]{HmdQuaternion.__member((int)8), HmdQuaternion.__member((int)8), HmdQuaternion.__member((int)8), HmdQuaternion.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        W = layout.offsetof(0);
        X = layout.offsetof(1);
        Y = layout.offsetof(2);
        Z = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<HmdQuaternion, Buffer>
    implements NativeResource {
        private static final HmdQuaternion ELEMENT_FACTORY = HmdQuaternion.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected HmdQuaternion getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public double w() {
            return HmdQuaternion.nw(this.address());
        }

        public double x() {
            return HmdQuaternion.nx(this.address());
        }

        public double y() {
            return HmdQuaternion.ny(this.address());
        }

        public double z() {
            return HmdQuaternion.nz(this.address());
        }

        public Buffer w(double value) {
            HmdQuaternion.nw(this.address(), value);
            return this;
        }

        public Buffer x(double value) {
            HmdQuaternion.nx(this.address(), value);
            return this;
        }

        public Buffer y(double value) {
            HmdQuaternion.ny(this.address(), value);
            return this;
        }

        public Buffer z(double value) {
            HmdQuaternion.nz(this.address(), value);
            return this;
        }
    }
}

