/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.document;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XDevice;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XChild;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.container.XNamed;
import com.sun.star.drawing.XControlShape;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPageSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapeGrouper;
import com.sun.star.drawing.XShapes;
import com.sun.star.form.XFormsSupplier;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.view.XControlAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.document.Control;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FormHandler {
    private static final String CHECKBOX = "CheckBox";
    private static final String DATEFIELD = "DateField";
    private static final String FORMATTEDFIELD = "FormattedField";
    private static final String TEXTFIELD = "TextField";
    private static final String TIMEFIELD = "TimeField";
    private XFormsSupplier xFormsSupplier;
    public XMultiServiceFactory xMSFDoc;
    public XMultiServiceFactory xMSF;
    public XDrawPage xDrawPage;
    public String[] sModelServices = new String[8];
    public static ControlData[] oControlData;
    public static final int SOLABEL = 0;
    public static final int SOTEXTBOX = 1;
    public static final int SOCHECKBOX = 2;
    public static final int SODATECONTROL = 3;
    public static final int SOTIMECONTROL = 4;
    public static final int SONUMERICCONTROL = 5;
    public static final int SOGRIDCONTROL = 6;
    public static final int SOIMAGECONTROL = 7;
    public static final int SODATETIMECONTROL = 8;
    public static String SOSIZETEXT;
    private int iXPixelFactor = -1;
    private int iYPixelFactor = -1;
    private int iXNirwanaPos = 50000;
    private int iYNirwanaPos = 50000;
    private int nLabelHeight = -1;
    private int nDBRefHeight = -1;
    private int BasicLabelDiffHeight = -1;
    private XNameAccess xNamedForms;
    XControlAccess xControlAccess;
    XShapeGrouper xShapeGrouper;

    public FormHandler(XMultiServiceFactory xMultiServiceFactory, XTextDocument xTextDocument) {
        this.xMSF = xMultiServiceFactory;
        XDrawPageSupplier xDrawPageSupplier = (XDrawPageSupplier)UnoRuntime.queryInterface(XDrawPageSupplier.class, (Object)xTextDocument);
        this.xDrawPage = xDrawPageSupplier.getDrawPage();
        this.xFormsSupplier = (XFormsSupplier)UnoRuntime.queryInterface(XFormsSupplier.class, (Object)this.xDrawPage);
        this.xShapeGrouper = (XShapeGrouper)UnoRuntime.queryInterface(XShapeGrouper.class, (Object)this.xDrawPage);
        this.xControlAccess = (XControlAccess)UnoRuntime.queryInterface(XControlAccess.class, (Object)xTextDocument.getCurrentController());
        this.xMSFDoc = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xTextDocument);
        this.sModelServices[0] = "com.sun.star.form.component.FixedText";
        this.sModelServices[1] = "com.sun.star.form.component.TextField";
        this.sModelServices[2] = "com.sun.star.form.component.CheckBox";
        this.sModelServices[3] = "com.sun.star.form.component.DateField";
        this.sModelServices[4] = "com.sun.star.form.component.TimeField";
        this.sModelServices[5] = "com.sun.star.form.component.FormattedField";
        this.sModelServices[6] = "com.sun.star.form.component.GridControl";
        this.sModelServices[7] = "com.sun.star.form.component.DatabaseImageControl";
        oControlData = new ControlData[23];
        FormHandler.oControlData[0] = this.createControlData(-7, 2, CHECKBOX);
        FormHandler.oControlData[1] = this.createControlData(16, 2, CHECKBOX);
        FormHandler.oControlData[2] = this.createControlData(-6, 5, FORMATTEDFIELD);
        FormHandler.oControlData[3] = this.createControlData(5, 5, FORMATTEDFIELD);
        FormHandler.oControlData[4] = this.createControlData(4, 5, FORMATTEDFIELD);
        FormHandler.oControlData[5] = this.createControlData(-5, 5, FORMATTEDFIELD);
        FormHandler.oControlData[6] = this.createControlData(6, 5, FORMATTEDFIELD);
        FormHandler.oControlData[7] = this.createControlData(7, 5, FORMATTEDFIELD);
        FormHandler.oControlData[8] = this.createControlData(8, 5, FORMATTEDFIELD);
        FormHandler.oControlData[9] = this.createControlData(2, 5, FORMATTEDFIELD);
        FormHandler.oControlData[10] = this.createControlData(3, 5, FORMATTEDFIELD);
        FormHandler.oControlData[11] = this.createControlData(1, 1, TEXTFIELD);
        FormHandler.oControlData[12] = this.createControlData(12, 1, TEXTFIELD);
        FormHandler.oControlData[13] = this.createControlData(-1, 1, TEXTFIELD);
        FormHandler.oControlData[14] = this.createControlData(91, 3, DATEFIELD);
        FormHandler.oControlData[15] = this.createControlData(92, 4, TIMEFIELD);
        FormHandler.oControlData[16] = this.createControlData(93, 3, TEXTFIELD);
        FormHandler.oControlData[17] = this.createControlData(-2, 7, TEXTFIELD);
        FormHandler.oControlData[18] = this.createControlData(-3, 7, TEXTFIELD);
        FormHandler.oControlData[19] = this.createControlData(-4, 7, TEXTFIELD);
        FormHandler.oControlData[20] = this.createControlData(2004, 7, TEXTFIELD);
        FormHandler.oControlData[21] = this.createControlData(2005, 7, TEXTFIELD);
        FormHandler.oControlData[22] = this.createControlData(1111, 7, TEXTFIELD);
    }

    public int getControlType(int n) {
        for (int i = 0; i < oControlData.length; ++i) {
            if (FormHandler.oControlData[i].DataType != n) continue;
            return oControlData[i].ControlType;
        }
        return -1;
    }

    private void initializeBasicControlValues() {
        Control control = new Control(this, 0, new Point(), new Size());
        XDevice xDevice = (XDevice)UnoRuntime.queryInterface(XDevice.class, (Object)control.xWindowPeer);
        this.iXPixelFactor = (int)(100000.0 / xDevice.getInfo().PixelPerMeterX);
        this.iYPixelFactor = (int)(100000.0 / xDevice.getInfo().PixelPerMeterY);
        this.nLabelHeight = control.getPreferredHeight("The quick brown fox...") + 1;
        Control control2 = new Control(this, 1, new Point(), new Size());
        this.nDBRefHeight = control2.getPreferredHeight("The quick brown fox...") + 1;
        this.BasicLabelDiffHeight = (this.nDBRefHeight - this.nLabelHeight) / 2;
        this.xDrawPage.remove(control.xShape);
        this.xDrawPage.remove(control2.xShape);
    }

    private ControlData createControlData(int n, int n2, String string) {
        ControlData controlData = new ControlData();
        controlData.DataType = n;
        controlData.ControlType = n2;
        controlData.GridColumnName = string;
        return controlData;
    }

    public XNameContainer getDocumentForms() {
        return this.xFormsSupplier.getForms();
    }

    public String getValueofHiddenControl(XNameAccess xNameAccess, String string) {
        String string2 = "";
        try {
            if (xNameAccess.hasByName(string)) {
                string2 = AnyConverter.toString((Object)Helper.getUnoPropertyValue(xNameAccess.getByName(string), "HiddenValue"));
            }
        }
        catch (Exception exception) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, exception);
        }
        return string2;
    }

    public void insertHiddenControl(XNameAccess xNameAccess, XNameContainer xNameContainer, String string, String string2) {
        try {
            XInterface xInterface;
            if (xNameAccess.hasByName(string)) {
                xInterface = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)xNameAccess.getByName(string));
            } else {
                xInterface = (XInterface)this.xMSFDoc.createInstance("com.sun.star.form.component.HiddenControl");
                xNameContainer.insertByName(string, (Object)xInterface);
            }
            Helper.setUnoPropertyValue(xInterface, "HiddenValue", string2);
        }
        catch (Exception exception) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    private boolean hasFormByName(String string) {
        XNameContainer xNameContainer = this.getDocumentForms();
        this.xNamedForms = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xNameContainer);
        return this.xNamedForms.hasByName(string);
    }

    public void removeControlsofForm(String string) {
        try {
            for (int i = this.xDrawPage.getCount() - 1; i >= 0; --i) {
                if (!this.belongsToForm(this.xDrawPage.getByIndex(i), string)) continue;
                XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)this.xDrawPage.getByIndex(i));
                this.xDrawPage.remove(xShape);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    public void removeElement(XNameContainer xNameContainer, String string) {
        try {
            xNameContainer.removeByName(string);
        }
        catch (WrappedTargetException wrappedTargetException) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, wrappedTargetException);
        }
        catch (NoSuchElementException noSuchElementException) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, noSuchElementException);
        }
    }

    private boolean belongsToForm(Object object, String string) {
        XShapes xShapes;
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)object);
        while (xServiceInfo.supportsService("com.sun.star.drawing.GroupShape")) {
            xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)object);
            try {
                object = xShapes.getByIndex(0);
                xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)object);
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (xServiceInfo.supportsService("com.sun.star.drawing.ControlShape")) {
            xShapes = (XControlShape)UnoRuntime.queryInterface(XControlShape.class, (Object)object);
            XControlModel xControlModel = xShapes.getControl();
            xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)xShapes.getControl());
            if (xServiceInfo.supportsService("com.sun.star.form.FormComponent")) {
                XChild xChild = (XChild)UnoRuntime.queryInterface(XChild.class, (Object)xControlModel);
                XNamed xNamed = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)xChild.getParent());
                String string2 = xNamed.getName();
                return string.equals(string2);
            }
        }
        return false;
    }

    public XNameContainer insertFormbyName(String string, XNameContainer xNameContainer) {
        try {
            if (!this.hasFormByName(string)) {
                Object object = this.xMSFDoc.createInstance("com.sun.star.form.component.Form");
                xNameContainer.insertByName(string, object);
                XNameContainer xNameContainer2 = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)object);
                return xNameContainer2;
            }
            return this.getFormByName(string);
        }
        catch (Exception exception) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, exception);
            return null;
        }
    }

    public XNameContainer insertFormbyName(String string) {
        return this.insertFormbyName(string, this.getDocumentForms());
    }

    private XNameContainer getFormByName(String string) {
        XNameContainer xNameContainer = null;
        try {
            if (this.xNamedForms.hasByName(string)) {
                Object object = AnyConverter.toObject((Type)new Type(XInterface.class), (Object)Helper.getUnoObjectbyName(this.xNamedForms, string));
                xNameContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)object);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
        }
        return xNameContainer;
    }

    public int getXPixelFactor() {
        if (this.iXPixelFactor == -1) {
            this.initializeBasicControlValues();
        }
        return this.iXPixelFactor;
    }

    public int getYPixelFactor() {
        if (this.iYPixelFactor == -1) {
            this.initializeBasicControlValues();
        }
        return this.iYPixelFactor;
    }

    public void moveShapesToNirwana(Control[] controlArray) {
        if (controlArray != null) {
            for (int i = 0; i < controlArray.length; ++i) {
                if (controlArray[i] == null) continue;
                controlArray[i].setPosition(new Point(this.iXNirwanaPos, this.iYNirwanaPos));
            }
        }
    }

    public void removeShape(XShape xShape) {
        this.xDrawPage.remove(xShape);
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xShape);
        xComponent.dispose();
    }

    public XShape groupShapesTogether(XMultiServiceFactory xMultiServiceFactory, XShape xShape, XShape xShape2) {
        try {
            Object object = xMultiServiceFactory.createInstance("com.sun.star.drawing.ShapeCollection");
            XShapes xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)object);
            xShapes.add(xShape);
            xShapes.add(xShape2);
            return this.xShapeGrouper.group(xShapes);
        }
        catch (Exception exception) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, exception);
            return null;
        }
    }

    public int getBasicLabelDiffHeight() {
        if (this.BasicLabelDiffHeight == -1) {
            this.initializeBasicControlValues();
        }
        return this.BasicLabelDiffHeight;
    }

    public int getControlReferenceHeight() {
        if (this.nDBRefHeight == -1) {
            this.initializeBasicControlValues();
        }
        return this.nDBRefHeight;
    }

    public int getLabelHeight() {
        if (this.nLabelHeight == -1) {
            this.initializeBasicControlValues();
        }
        return this.nLabelHeight;
    }

    public void setDrawObjectsCaptureMode(boolean bl) {
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xMSFDoc.createInstance("com.sun.star.text.DocumentSettings"));
            xPropertySet.setPropertyValue("DoNotCaptureDrawObjsOnPage", (Object)(!bl ? 1 : 0));
        }
        catch (Exception exception) {
            Logger.getLogger(FormHandler.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    static {
        SOSIZETEXT = "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog.";
    }

    public static class ControlData {
        int DataType;
        private int ControlType;
        String GridColumnName;
    }
}

