/* SPDX-FileCopyrightText: 2003 - Paolo Maggi <paolo.maggi@polito.it>
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#if !defined (GTK_SOURCE_H_INSIDE) && !defined (GTK_SOURCE_COMPILATION)
#error "Only <gtksourceview/gtksource.h> can be included directly."
#endif

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define GTK_SOURCE_TYPE_LANGUAGE		(gtk_source_language_get_type ())
#define GTK_SOURCE_LANGUAGE(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), GTK_SOURCE_TYPE_LANGUAGE, GtkSourceLanguage))
#define GTK_SOURCE_LANGUAGE_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), GTK_SOURCE_TYPE_LANGUAGE, GtkSourceLanguageClass))
#define GTK_SOURCE_IS_LANGUAGE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), GTK_SOURCE_TYPE_LANGUAGE))
#define GTK_SOURCE_IS_LANGUAGE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_SOURCE_TYPE_LANGUAGE))
#define GTK_SOURCE_LANGUAGE_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_SOURCE_TYPE_LANGUAGE, GtkSourceLanguageClass))

typedef struct _GtkSourceLanguage         GtkSourceLanguage;
typedef struct _GtkSourceLanguageClass    GtkSourceLanguageClass;
typedef struct _GtkSourceLanguagePrivate  GtkSourceLanguagePrivate;

struct _GtkSourceLanguage
{
	GObject parent_instance;

	GtkSourceLanguagePrivate *priv;
};

struct _GtkSourceLanguageClass
{
	GObjectClass parent_class;

	/* Padding for future expansion */
	gpointer padding[1];
};

G_MODULE_EXPORT
GType		  gtk_source_language_get_type 		(void) G_GNUC_CONST;

G_MODULE_EXPORT
const gchar	 *gtk_source_language_get_id		(GtkSourceLanguage *language);

G_MODULE_EXPORT
const gchar	 *gtk_source_language_get_name		(GtkSourceLanguage *language);

G_MODULE_EXPORT
const gchar	 *gtk_source_language_get_section	(GtkSourceLanguage *language);

G_MODULE_EXPORT
gboolean	  gtk_source_language_get_hidden 	(GtkSourceLanguage *language);

G_MODULE_EXPORT
const gchar	 *gtk_source_language_get_metadata	(GtkSourceLanguage *language,
							 const gchar       *name);

G_MODULE_EXPORT
gchar		**gtk_source_language_get_mime_types	(GtkSourceLanguage *language);

G_MODULE_EXPORT
gchar		**gtk_source_language_get_globs		(GtkSourceLanguage *language);

G_MODULE_EXPORT
gchar		**gtk_source_language_get_style_ids 	(GtkSourceLanguage *language);

G_MODULE_EXPORT
const gchar	*gtk_source_language_get_style_name	(GtkSourceLanguage *language,
							 const gchar       *style_id);

G_MODULE_EXPORT
const gchar	*gtk_source_language_get_style_fallback	(GtkSourceLanguage *language,
							 const gchar       *style_id);

G_END_DECLS
