/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifDirectoryBase;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.iptc.IptcDirectory;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.date.DateUtils;

public final class ExifReader {
    private ExifReader() {
    }

    public static Instant readInstant(File filename) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(filename);
            return ExifReader.readInstant(metadata);
        }
        catch (JpegProcessingException | IOException e) {
            Logging.error(e);
            return null;
        }
    }

    public static Instant readInstant(Metadata metadata) {
        block17: {
            try {
                String dateTimeOrig = null;
                String dateTime = null;
                String dateTimeDig = null;
                String subSecOrig = null;
                String subSec = null;
                String subSecDig = null;
                for (Directory dirIt : metadata.getDirectories()) {
                    if (!(dirIt instanceof ExifDirectoryBase)) continue;
                    for (Tag tag : dirIt.getTags()) {
                        if (tag.getTagType() == 36867 && !tag.getDescription().matches("\\[\\d+ .+]")) {
                            dateTimeOrig = tag.getDescription();
                            continue;
                        }
                        if (tag.getTagType() == 306) {
                            dateTime = tag.getDescription();
                            continue;
                        }
                        if (tag.getTagType() == 36868) {
                            dateTimeDig = tag.getDescription();
                            continue;
                        }
                        if (tag.getTagType() == 37521) {
                            subSecOrig = tag.getDescription();
                            continue;
                        }
                        if (tag.getTagType() == 37520) {
                            subSec = tag.getDescription();
                            continue;
                        }
                        if (tag.getTagType() != 37522) continue;
                        subSecDig = tag.getDescription();
                    }
                }
                String dateStr = null;
                String subSeconds = null;
                if (dateTimeOrig != null) {
                    dateStr = dateTimeOrig;
                    subSeconds = subSecOrig;
                } else if (dateTime != null) {
                    dateStr = dateTime;
                    subSeconds = subSec;
                } else if (dateTimeDig != null) {
                    dateStr = dateTimeDig;
                    subSeconds = subSecDig;
                }
                if (dateStr == null) break block17;
                dateStr = dateStr.replace('/', ':');
                Instant date = DateUtils.parseInstant(dateStr);
                if (subSeconds != null) {
                    try {
                        date = date.plusMillis((long)((double)TimeUnit.SECONDS.toMillis(1L) * Double.parseDouble("0." + subSeconds)));
                    }
                    catch (NumberFormatException e) {
                        Logging.warn("Failed parsing sub seconds from [{0}]", subSeconds);
                        Logging.warn(e);
                    }
                }
                return date;
            }
            catch (DateTimeException | UncheckedParseException e) {
                Logging.error(e);
            }
        }
        return null;
    }

    public static Instant readGpsInstant(File filename) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(filename);
            GpsDirectory dirGps = metadata.getFirstDirectoryOfType(GpsDirectory.class);
            return ExifReader.readGpsInstant(dirGps);
        }
        catch (JpegProcessingException | IOException e) {
            Logging.error(e);
            return null;
        }
    }

    public static Instant readGpsInstant(GpsDirectory dirGps) {
        if (dirGps != null) {
            try {
                return dirGps.getGpsDate().toInstant();
            }
            catch (DateTimeException | UncheckedParseException e) {
                Logging.error(e);
            }
        }
        return null;
    }

    public static Integer readOrientation(File filename) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(filename);
            ExifIFD0Directory dir = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
            return dir == null ? null : dir.getInteger(274);
        }
        catch (JpegProcessingException | IOException e) {
            Logging.error(e);
            return null;
        }
    }

    public static LatLon readLatLon(File filename) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(filename);
            GpsDirectory dirGps = metadata.getFirstDirectoryOfType(GpsDirectory.class);
            return ExifReader.readLatLon(dirGps);
        }
        catch (JpegProcessingException | MetadataException | IOException e) {
            Logging.error(e);
            return null;
        }
    }

    public static LatLon readLatLon(GpsDirectory dirGps) throws MetadataException {
        if (dirGps != null && dirGps.containsTag(2) && dirGps.containsTag(4)) {
            double lat = ExifReader.readAxis(dirGps, 2, 1, 'S');
            double lon = ExifReader.readAxis(dirGps, 4, 3, 'W');
            return new LatLon(lat, lon);
        }
        return null;
    }

    public static Double readDirection(File filename) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(filename);
            GpsDirectory dirGps = metadata.getFirstDirectoryOfType(GpsDirectory.class);
            return ExifReader.readDirection(dirGps);
        }
        catch (JpegProcessingException | IOException e) {
            Logging.error(e);
            return null;
        }
    }

    public static Double readDirection(GpsDirectory dirGps) {
        Rational direction;
        if (dirGps != null && (direction = dirGps.getRational(17)) != null) {
            return direction.doubleValue();
        }
        return null;
    }

    public static Double readGpsTrackDirection(File filename) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(filename);
            GpsDirectory dirGps = metadata.getFirstDirectoryOfType(GpsDirectory.class);
            return ExifReader.readGpsTrackDirection(dirGps);
        }
        catch (JpegProcessingException | IOException e) {
            Logging.error(e);
            return null;
        }
    }

    public static Double readGpsTrackDirection(GpsDirectory dirGps) {
        Rational trackDirection;
        if (dirGps != null && (trackDirection = dirGps.getRational(15)) != null) {
            return trackDirection.doubleValue();
        }
        return null;
    }

    private static double readAxis(GpsDirectory dirGps, int gpsTag, int gpsTagRef, char cRef) throws MetadataException {
        double value;
        Rational[] components = dirGps.getRationalArray(gpsTag);
        if (components != null) {
            double deg = components[0].doubleValue();
            double min = components[1].doubleValue();
            double sec = components[2].doubleValue();
            if (Double.isNaN(deg) && Double.isNaN(min) && Double.isNaN(sec)) {
                throw new IllegalArgumentException("deg, min and sec are NaN");
            }
            value = Double.isNaN(deg) ? 0.0 : deg + (Double.isNaN(min) ? 0.0 : min / 60.0) + (Double.isNaN(sec) ? 0.0 : sec / 3600.0);
            String s = dirGps.getString(gpsTagRef);
            if (s != null && s.charAt(0) == cRef) {
                value = -value;
            }
        } else {
            value = dirGps.getDouble(gpsTag);
        }
        return value;
    }

    public static Double readSpeed(File filename) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(filename);
            GpsDirectory dirGps = metadata.getFirstDirectoryOfType(GpsDirectory.class);
            return ExifReader.readSpeed(dirGps);
        }
        catch (JpegProcessingException | IOException e) {
            Logging.error(e);
            return null;
        }
    }

    public static Double readSpeed(GpsDirectory dirGps) {
        Double speed;
        if (dirGps != null && (speed = dirGps.getDoubleObject(13)) != null) {
            String speedRef = dirGps.getString(12);
            if ("M".equalsIgnoreCase(speedRef)) {
                speed = speed * (SystemOfMeasurement.IMPERIAL.bValue / 1000.0);
            } else if ("N".equalsIgnoreCase(speedRef)) {
                speed = speed * (SystemOfMeasurement.NAUTICAL_MILE.bValue / 1000.0);
            }
            return speed;
        }
        return null;
    }

    public static Double readElevation(File filename) {
        try {
            return ExifReader.readElevation(JpegMetadataReader.readMetadata(filename).getFirstDirectoryOfType(GpsDirectory.class));
        }
        catch (JpegProcessingException | IOException e) {
            Logging.error(e);
            return null;
        }
    }

    public static Double readElevation(GpsDirectory dirGps) {
        Double ele;
        if (dirGps != null && (ele = dirGps.getDoubleObject(6)) != null) {
            Integer d = dirGps.getInteger(5);
            if (d != null && d == 1) {
                ele = ele * -1.0;
            }
            return ele;
        }
        return null;
    }

    public static Double readHpositioningError(File filename) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(filename);
            GpsDirectory dirGps = metadata.getFirstDirectoryOfType(GpsDirectory.class);
            return ExifReader.readHpositioningError(dirGps);
        }
        catch (JpegProcessingException | IOException e) {
            Logging.error(e);
            return null;
        }
    }

    public static Double readHpositioningError(GpsDirectory dirGps) {
        Double hposerr;
        if (dirGps != null && (hposerr = dirGps.getDoubleObject(31)) != null) {
            return hposerr;
        }
        return null;
    }

    public static Integer readGpsDiffMode(File filename) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(filename);
            GpsDirectory dirGps = metadata.getFirstDirectoryOfType(GpsDirectory.class);
            return ExifReader.readGpsDiffMode(dirGps);
        }
        catch (JpegProcessingException | IOException e) {
            Logging.error(e);
            return null;
        }
    }

    public static Integer readGpsDiffMode(GpsDirectory dirGps) {
        Integer gpsDiffMode;
        if (dirGps != null && (gpsDiffMode = dirGps.getInteger(30)) != null) {
            return gpsDiffMode;
        }
        return null;
    }

    public static Integer readGpsMeasureMode(File filename) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(filename);
            GpsDirectory dirGps = metadata.getFirstDirectoryOfType(GpsDirectory.class);
            return ExifReader.readGpsMeasureMode(dirGps);
        }
        catch (JpegProcessingException | IOException e) {
            Logging.error(e);
            return null;
        }
    }

    public static Integer readGpsMeasureMode(GpsDirectory dirGps) {
        Integer gps2d3dMode;
        if (dirGps != null && (gps2d3dMode = dirGps.getInteger(10)) != null) {
            return gps2d3dMode;
        }
        return null;
    }

    public static Double readGpsDop(File filename) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(filename);
            GpsDirectory dirGps = metadata.getFirstDirectoryOfType(GpsDirectory.class);
            return ExifReader.readGpsDop(dirGps);
        }
        catch (JpegProcessingException | IOException e) {
            Logging.error(e);
            return null;
        }
    }

    public static Double readGpsDop(GpsDirectory dirGps) {
        Double gpsDop;
        if (dirGps != null && (gpsDop = dirGps.getDoubleObject(11)) != null) {
            return gpsDop;
        }
        return null;
    }

    public static String readGpsDatum(File filename) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(filename);
            GpsDirectory dirGps = metadata.getFirstDirectoryOfType(GpsDirectory.class);
            return ExifReader.readGpsDatum(dirGps);
        }
        catch (JpegProcessingException | IOException e) {
            Logging.error(e);
            return null;
        }
    }

    public static String readGpsDatum(GpsDirectory dirGps) {
        String gpsDatum;
        if (dirGps != null && (gpsDatum = dirGps.getString(18)) != null) {
            return gpsDatum;
        }
        return null;
    }

    public static String readGpsProcessingMethod(File filename) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(filename);
            GpsDirectory dirGps = metadata.getFirstDirectoryOfType(GpsDirectory.class);
            return ExifReader.readGpsProcessingMethod(dirGps);
        }
        catch (JpegProcessingException | IOException e) {
            Logging.error(e);
            return null;
        }
    }

    public static String readGpsProcessingMethod(GpsDirectory dirGps) {
        String gpsProcessingMethod;
        if (dirGps != null && (gpsProcessingMethod = dirGps.getDescription(27)) != null) {
            return gpsProcessingMethod;
        }
        return null;
    }

    public static String readCaption(IptcDirectory dirIptc) {
        return dirIptc == null ? null : dirIptc.getDescription(632);
    }

    public static String readHeadline(IptcDirectory dirIptc) {
        return dirIptc == null ? null : dirIptc.getDescription(617);
    }

    public static List<String> readKeywords(IptcDirectory dirIptc) {
        return dirIptc == null ? null : dirIptc.getKeywords();
    }

    public static String readObjectName(IptcDirectory dirIptc) {
        return dirIptc == null ? null : dirIptc.getDescription(517);
    }

    public static AffineTransform getRestoreOrientationTransform(int orientation, int width, int height) {
        double ay;
        double ax;
        int q;
        switch (orientation) {
            case 8: {
                q = -1;
                ax = (double)width / 2.0;
                ay = (double)width / 2.0;
                break;
            }
            case 3: {
                q = 2;
                ax = (double)width / 2.0;
                ay = (double)height / 2.0;
                break;
            }
            case 6: {
                q = 1;
                ax = (double)height / 2.0;
                ay = (double)height / 2.0;
                break;
            }
            default: {
                q = 0;
                ax = 0.0;
                ay = 0.0;
            }
        }
        return AffineTransform.getQuadrantRotateInstance(q, ax, ay);
    }

    public static boolean orientationSwitchesDimensions(int orientation) {
        return orientation == 6 || orientation == 8;
    }

    public static boolean orientationNeedsCorrection(int orientation) {
        return orientation == 3 || orientation == 6 || orientation == 8;
    }
}

