/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class NoteInputDialog
extends ExtendedDialog {
    private final JosmTextArea textArea = new JosmTextArea();

    public NoteInputDialog(Component parent, String title, String buttonText) {
        super(parent, title, buttonText, I18n.tr("Cancel", new Object[0]));
        this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(MainApplication.getMainFrame(), new Dimension(400, 300)));
    }

    public void showNoteDialog(String message, Icon icon) {
        this.showNoteDialog(message, icon, "");
    }

    public void showNoteDialog(String message, Icon icon, String text) {
        this.textArea.setText(text);
        this.textArea.setRows(6);
        this.textArea.setColumns(30);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        scrollPane.setAlignmentX(0.0f);
        JLabel label = new JLabel(message);
        label.setLabelFor(this.textArea);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.add(label);
        contentPanel.add(scrollPane);
        this.setContent(contentPanel, false);
        this.setButtonIcons(icon, ImageProvider.get("cancel"));
        this.showDialog();
    }

    public String getInputText() {
        return this.textArea.getText();
    }
}

