/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaAllocatorInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int INSTANCE;
    public static final int PHYSICALDEVICE;
    public static final int DEVICE;

    public VmaAllocatorInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VmaAllocatorInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkInstance")
    public long instance() {
        return VmaAllocatorInfo.ninstance(this.address());
    }

    @NativeType(value="VkPhysicalDevice")
    public long physicalDevice() {
        return VmaAllocatorInfo.nphysicalDevice(this.address());
    }

    @NativeType(value="VkDevice")
    public long device() {
        return VmaAllocatorInfo.ndevice(this.address());
    }

    public static VmaAllocatorInfo malloc() {
        return (VmaAllocatorInfo)VmaAllocatorInfo.wrap(VmaAllocatorInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VmaAllocatorInfo calloc() {
        return (VmaAllocatorInfo)VmaAllocatorInfo.wrap(VmaAllocatorInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VmaAllocatorInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VmaAllocatorInfo)VmaAllocatorInfo.wrap(VmaAllocatorInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VmaAllocatorInfo create(long address) {
        return (VmaAllocatorInfo)VmaAllocatorInfo.wrap(VmaAllocatorInfo.class, (long)address);
    }

    @Nullable
    public static VmaAllocatorInfo createSafe(long address) {
        return address == 0L ? null : (VmaAllocatorInfo)VmaAllocatorInfo.wrap(VmaAllocatorInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VmaAllocatorInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VmaAllocatorInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VmaAllocatorInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaAllocatorInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VmaAllocatorInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VmaAllocatorInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VmaAllocatorInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VmaAllocatorInfo malloc(MemoryStack stack) {
        return (VmaAllocatorInfo)VmaAllocatorInfo.wrap(VmaAllocatorInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaAllocatorInfo calloc(MemoryStack stack) {
        return (VmaAllocatorInfo)VmaAllocatorInfo.wrap(VmaAllocatorInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VmaAllocatorInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VmaAllocatorInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long ninstance(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)INSTANCE));
    }

    public static long nphysicalDevice(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PHYSICALDEVICE));
    }

    public static long ndevice(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DEVICE));
    }

    static {
        Struct.Layout layout = VmaAllocatorInfo.__struct((Struct.Member[])new Struct.Member[]{VmaAllocatorInfo.__member((int)POINTER_SIZE), VmaAllocatorInfo.__member((int)POINTER_SIZE), VmaAllocatorInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        INSTANCE = layout.offsetof(0);
        PHYSICALDEVICE = layout.offsetof(1);
        DEVICE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VmaAllocatorInfo, Buffer>
    implements NativeResource {
        private static final VmaAllocatorInfo ELEMENT_FACTORY = VmaAllocatorInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VmaAllocatorInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkInstance")
        public long instance() {
            return VmaAllocatorInfo.ninstance(this.address());
        }

        @NativeType(value="VkPhysicalDevice")
        public long physicalDevice() {
            return VmaAllocatorInfo.nphysicalDevice(this.address());
        }

        @NativeType(value="VkDevice")
        public long device() {
            return VmaAllocatorInfo.ndevice(this.address());
        }
    }
}

