/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;

abstract class Authenticator {
    protected final byte[] block;

    private Authenticator(byte[] byArray) {
        this.block = byArray;
    }

    static Authenticator valueOf(ProtocolVersion protocolVersion) {
        if (protocolVersion.useTLS13PlusSpec()) {
            return new TLS13Authenticator(protocolVersion);
        }
        if (protocolVersion.useTLS10PlusSpec()) {
            return new TLS10Authenticator(protocolVersion);
        }
        return new SSL30Authenticator();
    }

    static <T extends Authenticator> T valueOf(ProtocolVersion protocolVersion, CipherSuite.MacAlg macAlg, SecretKey secretKey) throws NoSuchAlgorithmException, InvalidKeyException {
        if (protocolVersion.useTLS13PlusSpec()) {
            throw new RuntimeException("No MacAlg used in TLS 1.3");
        }
        if (protocolVersion.useTLS10PlusSpec()) {
            return (T)new TLS10Mac(protocolVersion, macAlg, secretKey);
        }
        return (T)new SSL30Mac(protocolVersion, macAlg, secretKey);
    }

    static Authenticator nullTlsMac() {
        return new SSLNullMac();
    }

    abstract boolean seqNumOverflow();

    abstract boolean seqNumIsHuge();

    final byte[] sequenceNumber() {
        return Arrays.copyOf(this.block, 8);
    }

    final void increaseSequenceNumber() {
        int n = 7;
        while (n >= 0) {
            int n2 = n--;
            this.block[n2] = (byte)(this.block[n2] + 1);
            if (this.block[n2] == 0) continue;
        }
    }

    byte[] acquireAuthenticationBytes(byte by, int n, byte[] byArray) {
        throw new UnsupportedOperationException("Used by AEAD algorithms only");
    }

    static final long toLong(byte[] byArray) {
        if (byArray != null && byArray.length == 8) {
            return ((long)byArray[0] & 0xFFL) << 56 | ((long)byArray[1] & 0xFFL) << 48 | ((long)byArray[2] & 0xFFL) << 40 | ((long)byArray[3] & 0xFFL) << 32 | ((long)byArray[4] & 0xFFL) << 24 | ((long)byArray[5] & 0xFFL) << 16 | ((long)byArray[6] & 0xFFL) << 8 | (long)byArray[7] & 0xFFL;
        }
        return -1L;
    }

    private static final class TLS10Mac
    extends TLS10Authenticator
    implements MAC {
        private final MacImpl macImpl;

        public TLS10Mac(ProtocolVersion protocolVersion, CipherSuite.MacAlg macAlg, SecretKey secretKey) throws NoSuchAlgorithmException, InvalidKeyException {
            super(protocolVersion);
            this.macImpl = new MacImpl(protocolVersion, macAlg, secretKey);
        }

        @Override
        public CipherSuite.MacAlg macAlg() {
            return this.macImpl.macAlg;
        }

        @Override
        public byte[] compute(byte by, ByteBuffer byteBuffer, byte[] byArray, boolean bl) {
            return this.macImpl.compute(by, byteBuffer, byArray, bl);
        }
    }

    private static final class SSL30Mac
    extends SSL30Authenticator
    implements MAC {
        private final MacImpl macImpl;

        public SSL30Mac(ProtocolVersion protocolVersion, CipherSuite.MacAlg macAlg, SecretKey secretKey) throws NoSuchAlgorithmException, InvalidKeyException {
            this.macImpl = new MacImpl(protocolVersion, macAlg, secretKey);
        }

        @Override
        public CipherSuite.MacAlg macAlg() {
            return this.macImpl.macAlg;
        }

        @Override
        public byte[] compute(byte by, ByteBuffer byteBuffer, byte[] byArray, boolean bl) {
            return this.macImpl.compute(by, byteBuffer, byArray, bl);
        }
    }

    private static final class SSLNullMac
    extends SSLNullAuthenticator
    implements MAC {
        private final MacImpl macImpl = new MacImpl();

        @Override
        public CipherSuite.MacAlg macAlg() {
            return this.macImpl.macAlg;
        }

        @Override
        public byte[] compute(byte by, ByteBuffer byteBuffer, byte[] byArray, boolean bl) {
            return this.macImpl.compute(by, byteBuffer, byArray, bl);
        }
    }

    private class MacImpl
    implements MAC {
        private final CipherSuite.MacAlg macAlg;
        private final Mac mac;

        private MacImpl() {
            this.macAlg = CipherSuite.MacAlg.M_NULL;
            this.mac = null;
        }

        private MacImpl(ProtocolVersion protocolVersion, CipherSuite.MacAlg macAlg, SecretKey secretKey) throws NoSuchAlgorithmException, InvalidKeyException {
            String string;
            if (macAlg == null) {
                throw new RuntimeException("Null MacAlg");
            }
            boolean bl = protocolVersion.id < ProtocolVersion.TLS10.id;
            switch (macAlg) {
                case M_MD5: {
                    string = bl ? "SslMacMD5" : "HmacMD5";
                    break;
                }
                case M_SHA: {
                    string = bl ? "SslMacSHA1" : "HmacSHA1";
                    break;
                }
                case M_SHA256: {
                    string = "HmacSHA256";
                    break;
                }
                case M_SHA384: {
                    string = "HmacSHA384";
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown MacAlg " + (Object)((Object)macAlg));
                }
            }
            Mac mac = JsseJce.getMac(string);
            mac.init(secretKey);
            this.macAlg = macAlg;
            this.mac = mac;
        }

        @Override
        public CipherSuite.MacAlg macAlg() {
            return this.macAlg;
        }

        @Override
        public byte[] compute(byte by, ByteBuffer byteBuffer, byte[] byArray, boolean bl) {
            if (this.macAlg.size == 0) {
                return new byte[0];
            }
            if (!bl) {
                byte[] byArray2 = Authenticator.this.acquireAuthenticationBytes(by, byteBuffer.remaining(), byArray);
                this.mac.update(byArray2);
            }
            this.mac.update(byteBuffer);
            return this.mac.doFinal();
        }
    }

    static interface MAC {
        public CipherSuite.MacAlg macAlg();

        public byte[] compute(byte var1, ByteBuffer var2, byte[] var3, boolean var4);

        default public byte[] compute(byte by, ByteBuffer byteBuffer, boolean bl) {
            return this.compute(by, byteBuffer, null, bl);
        }
    }

    private static final class TLS13Authenticator
    extends SSLAuthenticator {
        private static final int BLOCK_SIZE = 13;

        private TLS13Authenticator(ProtocolVersion protocolVersion) {
            super(new byte[13]);
            this.block[9] = ProtocolVersion.TLS12.major;
            this.block[10] = ProtocolVersion.TLS12.minor;
        }

        @Override
        byte[] acquireAuthenticationBytes(byte by, int n, byte[] byArray) {
            byte[] byArray2 = Arrays.copyOfRange(this.block, 8, 13);
            this.increaseSequenceNumber();
            byArray2[0] = by;
            byArray2[3] = (byte)(n >> 8);
            byArray2[4] = (byte)(n & 0xFF);
            return byArray2;
        }
    }

    private static class TLS10Authenticator
    extends SSLAuthenticator {
        private static final int BLOCK_SIZE = 13;

        private TLS10Authenticator(ProtocolVersion protocolVersion) {
            super(new byte[13]);
            this.block[9] = protocolVersion.major;
            this.block[10] = protocolVersion.minor;
        }

        @Override
        byte[] acquireAuthenticationBytes(byte by, int n, byte[] byArray) {
            byte[] byArray2 = (byte[])this.block.clone();
            if (byArray != null) {
                if (byArray.length != 8) {
                    throw new RuntimeException("Insufficient explicit sequence number bytes");
                }
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            } else {
                this.increaseSequenceNumber();
            }
            byArray2[8] = by;
            byArray2[11] = (byte)(n >> 8);
            byArray2[12] = (byte)n;
            return byArray2;
        }
    }

    private static class SSL30Authenticator
    extends SSLAuthenticator {
        private static final int BLOCK_SIZE = 11;

        private SSL30Authenticator() {
            super(new byte[11]);
        }

        @Override
        byte[] acquireAuthenticationBytes(byte by, int n, byte[] byArray) {
            byte[] byArray2 = (byte[])this.block.clone();
            this.increaseSequenceNumber();
            byArray2[8] = by;
            byArray2[9] = (byte)(n >> 8);
            byArray2[10] = (byte)n;
            return byArray2;
        }
    }

    private static class SSLNullAuthenticator
    extends SSLAuthenticator {
        private SSLNullAuthenticator() {
            super(new byte[8]);
        }
    }

    private static class SSLAuthenticator
    extends Authenticator {
        private SSLAuthenticator(byte[] byArray) {
            super(byArray);
        }

        @Override
        boolean seqNumOverflow() {
            return this.block.length != 0 && this.block[0] == -1 && this.block[1] == -1 && this.block[2] == -1 && this.block[3] == -1 && this.block[4] == -1 && this.block[5] == -1 && this.block[6] == -1;
        }

        @Override
        boolean seqNumIsHuge() {
            return this.block.length != 0 && this.block[0] == -1 && this.block[1] == -1 && this.block[2] == -1 && this.block[3] == -1;
        }
    }
}

