/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.tableinput;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.tableinput.Messages;
import org.pentaho.di.trans.steps.tableinput.TableInputData;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;

public class TableInput
extends BaseStep
implements StepInterface {
    private TableInputMeta meta;
    private TableInputData data;

    public TableInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private synchronized RowMetaAndData readStartDate() throws KettleException {
        if (this.log.isDetailed()) {
            this.logDetailed("Reading from step [" + this.meta.getLookupStepname() + "]");
        }
        RowMeta parametersMeta = new RowMeta();
        Object[] parametersData = new Object[]{};
        RowSet rowSet = this.findInputRowSet(this.meta.getLookupStepname());
        if (rowSet != null) {
            Object[] rowData = this.getRowFrom(rowSet);
            while (rowData != null) {
                parametersData = RowDataUtil.addRowData((Object[])parametersData, (int)parametersMeta.size(), (Object[])rowData);
                parametersMeta.addRowMeta(rowSet.getRowMeta());
                rowData = this.getRowFrom(rowSet);
            }
            if (parametersMeta.size() == 0) {
                throw new KettleException("Expected to read parameters from step [" + this.meta.getLookupStepname() + "] but none were found.");
            }
        } else {
            throw new KettleException("Unable to find rowset to read from, perhaps step [" + this.meta.getLookupStepname() + "] doesn't exist. (or perhaps you are trying a preview?)");
        }
        RowMetaAndData parameters = new RowMetaAndData((RowMetaInterface)parametersMeta, parametersData);
        return parameters;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        boolean success;
        if (this.first) {
            RowMeta parametersMeta;
            Object[] parameters;
            this.first = false;
            if (this.meta.getInfoSteps() != null) {
                if (this.meta.isExecuteEachInputRow()) {
                    if (this.log.isDetailed()) {
                        this.logDetailed("Reading single row from stream [" + this.meta.getLookupStepname() + "]");
                    }
                    this.data.rowSet = this.findInputRowSet(this.meta.getLookupStepname());
                    parameters = this.getRowFrom(this.data.rowSet);
                    parametersMeta = this.data.rowSet.getRowMeta();
                } else {
                    if (this.log.isDetailed()) {
                        this.logDetailed("Reading query parameters from stream [" + this.meta.getLookupStepname() + "]");
                    }
                    RowMetaAndData rmad = this.readStartDate();
                    parameters = rmad.getData();
                    parametersMeta = rmad.getRowMeta();
                }
                if (parameters != null && this.log.isDetailed()) {
                    this.logDetailed("Query parameters found = " + parametersMeta.getString(parameters));
                }
            } else {
                parameters = new Object[]{};
                parametersMeta = new RowMeta();
            }
            if (this.meta.isExecuteEachInputRow() && (parameters == null || parametersMeta.size() == 0)) {
                this.setOutputDone();
                return false;
            }
            success = this.doQuery((RowMetaInterface)parametersMeta, parameters);
            if (!success) {
                return false;
            }
        } else if (this.data.thisrow != null) {
            this.data.nextrow = this.data.db.getRow(this.data.rs, this.meta.isLazyConversionActive());
            if (this.data.nextrow != null) {
                this.incrementLinesInput();
            }
        }
        if (this.data.thisrow == null) {
            boolean done = false;
            if (this.meta.isExecuteEachInputRow()) {
                Object[] nextRow = this.getRowFrom(this.data.rowSet);
                if (nextRow == null) {
                    done = true;
                } else {
                    this.closePreviousQuery();
                    success = this.doQuery(this.data.rowSet.getRowMeta(), nextRow);
                    if (!success) {
                        return false;
                    }
                    if (this.data.thisrow != null) {
                        this.putRow(this.data.rowMeta, this.data.thisrow);
                        this.data.thisrow = this.data.nextrow;
                        if (this.checkFeedback(this.getLinesInput()) && this.log.isBasic()) {
                            this.logBasic("linenr " + this.getLinesInput());
                        }
                    }
                }
            } else {
                done = true;
            }
            if (done) {
                this.setOutputDone();
                return false;
            }
        } else {
            this.putRow(this.data.rowMeta, this.data.thisrow);
            this.data.thisrow = this.data.nextrow;
            if (this.checkFeedback(this.getLinesInput()) && this.log.isBasic()) {
                this.logBasic("linenr " + this.getLinesInput());
            }
        }
        return true;
    }

    private void closePreviousQuery() throws KettleDatabaseException {
        this.data.db.closeQuery(this.data.rs);
    }

    private boolean doQuery(RowMetaInterface parametersMeta, Object[] parameters) throws KettleDatabaseException {
        boolean success = true;
        String sql = null;
        sql = this.meta.isVariableReplacementActive() ? this.environmentSubstitute(this.meta.getSQL()) : this.meta.getSQL();
        this.data.rs = this.data.db.openQuery(sql, parametersMeta, parameters, 1000, this.meta.isLazyConversionActive());
        if (this.data.rs == null) {
            this.logError("Couldn't open Query [" + sql + "]");
            this.setErrors(1L);
            this.stopAll();
            success = false;
        } else {
            this.data.rowMeta = this.data.db.getReturnRowMeta();
            if (this.data.rowMeta != null) {
                for (ValueMetaInterface valueMeta : this.data.rowMeta.getValueMetaList()) {
                    valueMeta.setOrigin(this.getStepname());
                }
            }
            this.data.thisrow = this.data.db.getRow(this.data.rs);
            if (this.data.thisrow != null) {
                this.incrementLinesInput();
                this.data.nextrow = this.data.db.getRow(this.data.rs);
                if (this.data.nextrow != null) {
                    this.incrementLinesInput();
                }
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        block7: {
            if (this.log.isBasic()) {
                this.logBasic("Finished reading query, closing connection.");
            }
            try {
                try {
                    this.closePreviousQuery();
                }
                catch (KettleException e) {
                    this.logError("Unexpected error closing query : " + e.toString());
                    this.setErrors(1L);
                    this.stopAll();
                    Object var5_4 = null;
                    if (this.data.db != null) {
                        this.data.db.disconnect();
                    }
                    break block7;
                }
                Object var5_3 = null;
                if (this.data.db == null) break block7;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (this.data.db != null) {
                    this.data.db.disconnect();
                }
                throw throwable;
            }
            this.data.db.disconnect();
        }
        super.dispose(smi, sdi);
    }

    public synchronized void stopRunning(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (TableInputMeta)smi;
        this.data = (TableInputData)sdi;
        this.setStopped(true);
        if (this.data.db != null && !this.data.isCanceled) {
            this.data.db.cancelQuery();
            this.data.isCanceled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TableInputMeta)smi;
        this.data = (TableInputData)sdi;
        if (super.init(smi, sdi)) {
            boolean passed = true;
            if (Const.isEmpty((String)this.meta.getSQL())) {
                this.logError(Messages.getString("TableInput.Exception.SQLIsNeeded"));
                passed = false;
            }
            if (this.meta.getDatabaseMeta() == null) {
                this.logError(Messages.getString("TableInput.Exception.DatabaseConnectionsIsNeeded"));
                passed = false;
            }
            if (!passed) {
                return false;
            }
            this.data.db = new Database(this.meta.getDatabaseMeta());
            this.data.db.shareVariablesWith((VariableSpace)this);
            this.data.db.setQueryLimit(this.meta.getRowLimit());
            try {
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    Trans trans = this.getTrans();
                    synchronized (trans) {
                        this.data.db.connect(this.getTrans().getThreadName(), this.getPartitionID());
                    }
                } else {
                    this.data.db.connect(this.getPartitionID());
                }
                if (this.meta.getDatabaseMeta().isRequiringTransactionsOnQueries()) {
                    this.data.db.setCommit(100);
                }
                if (this.log.isDetailed()) {
                    this.logDetailed("Connected to database...");
                }
                return true;
            }
            catch (KettleException e) {
                this.logError("An error occurred, processing will be stopped: " + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

