/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.snapshot;

import java.io.File;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshot;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshotCategory;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshotDescriptorProvider;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshotProvider;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.core.model.ModelProvider;
import org.graalvm.visualvm.core.snapshot.RegisteredSnapshotCategories;
import org.graalvm.visualvm.core.snapshot.SnapshotCategory;
import org.graalvm.visualvm.core.snapshot.SnapshotsContainer;

public final class ApplicationSnapshotsSupport {
    private static ApplicationSnapshotsSupport instance;
    private static final String SNAPSHOTS_STORAGE_DIRNAME = "snapshots";
    private static File snapshotsStorageDirectory;
    private static String snapshotsStorageDirectoryString;
    private ApplicationSnapshotProvider snapshotProvider;
    private ApplicationSnapshotCategory snapshotCategory = new ApplicationSnapshotCategory();

    public static synchronized ApplicationSnapshotsSupport getInstance() {
        if (instance == null) {
            instance = new ApplicationSnapshotsSupport();
        }
        return instance;
    }

    public SnapshotCategory<ApplicationSnapshot> getCategory() {
        return this.snapshotCategory;
    }

    ApplicationSnapshotCategory getApplicationSnapshotCategory() {
        return this.snapshotCategory;
    }

    ApplicationSnapshotProvider getSnapshotProvider() {
        return this.snapshotProvider;
    }

    static synchronized String getStorageDirectoryString() {
        if (snapshotsStorageDirectoryString == null) {
            snapshotsStorageDirectoryString = Storage.getPersistentStorageDirectoryString() + File.separator + SNAPSHOTS_STORAGE_DIRNAME;
        }
        return snapshotsStorageDirectoryString;
    }

    static synchronized File getStorageDirectory() {
        if (snapshotsStorageDirectory == null) {
            String snapshotsStorageString = ApplicationSnapshotsSupport.getStorageDirectoryString();
            snapshotsStorageDirectory = new File(snapshotsStorageString);
            if (snapshotsStorageDirectory.exists() && snapshotsStorageDirectory.isFile()) {
                throw new IllegalStateException("Cannot create snapshots storage directory " + snapshotsStorageString + ", file in the way");
            }
            if (!(!snapshotsStorageDirectory.exists() || snapshotsStorageDirectory.canRead() && snapshotsStorageDirectory.canWrite())) {
                throw new IllegalStateException("Cannot access snapshots storage directory " + snapshotsStorageString + ", read&write permission required");
            }
            if (!Utils.prepareDirectory((File)snapshotsStorageDirectory)) {
                throw new IllegalStateException("Cannot create snapshots storage directory " + snapshotsStorageString);
            }
        }
        return snapshotsStorageDirectory;
    }

    static boolean storageDirectoryExists() {
        return new File(ApplicationSnapshotsSupport.getStorageDirectoryString()).isDirectory();
    }

    private ApplicationSnapshotsSupport() {
        DataSourceDescriptorFactory.getDefault().registerProvider((ModelProvider)new ApplicationSnapshotDescriptorProvider());
        this.snapshotProvider = ApplicationSnapshotProvider.sharedInstance();
        RegisteredSnapshotCategories.sharedInstance().registerCategory((SnapshotCategory)this.snapshotCategory);
        SnapshotsContainer.sharedInstance();
        this.snapshotProvider.initialize();
    }
}

